/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.executorservice;

import com.sun.enterprise.config.serverbeans.Config;
import fish.payara.nucleus.executorservice.PayaraExecutorServiceConfiguration;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="payara-executor-service")
public class PayaraExecutorService
implements ConfigListener,
EventListener {
    @Inject
    @Named(value="default-instance-name")
    @Optional
    PayaraExecutorServiceConfiguration payaraExecutorServiceConfiguration;
    @Inject
    Transactions transactions;
    @Inject
    ServerEnvironment serverEnvironment;
    @Inject
    private ProcessEnvironment processEnvironment;
    @Inject
    private Events events;
    private ThreadPoolExecutor threadPoolExecutor;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;

    @PostConstruct
    public void postConstruct() {
        if (this.events != null) {
            this.events.register((EventListener)this);
        }
        if (this.payaraExecutorServiceConfiguration == null) {
            this.payaraExecutorServiceConfiguration = (PayaraExecutorServiceConfiguration)Globals.get(PayaraExecutorServiceConfiguration.class);
        }
        if (this.transactions != null) {
            this.transactions.addListenerForType(PayaraExecutorServiceConfiguration.class, (ConfigListener)this);
        }
        this.initialiseThreadPools();
    }

    public void event(EventListener.Event event) {
        if (event.is(Deployment.ALL_APPLICATIONS_LOADED)) {
            if (null == this.threadPoolExecutor) {
                this.initialiseThreadPools();
            }
        } else if (event.is(EventTypes.SERVER_SHUTDOWN)) {
            this.terminateThreadPools();
        }
    }

    private void terminateThreadPools() {
        if (this.threadPoolExecutor == null) {
            return;
        }
        this.threadPoolExecutor.shutdown();
        this.scheduledThreadPoolExecutor.shutdown();
        try {
            this.threadPoolExecutor.awaitTermination(5L, TimeUnit.SECONDS);
            this.scheduledThreadPoolExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.threadPoolExecutor.isShutdown()) {
            this.threadPoolExecutor.shutdownNow();
        }
        if (!this.scheduledThreadPoolExecutor.isShutdown()) {
            this.scheduledThreadPoolExecutor.shutdownNow();
        }
        this.threadPoolExecutor = null;
        this.scheduledThreadPoolExecutor = null;
    }

    private void initialiseThreadPools() {
        if (this.isACC()) {
            this.threadPoolExecutor = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), r -> new Thread(r, "payara-executor-service-task"));
            this.threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
            this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(0, r -> {
                Thread t = new Thread(r, "payara-executor-service-scheduled-task");
                t.setUncaughtExceptionHandler((thread, thrwbl) -> Logger.getLogger(PayaraExecutorService.class.getName()).log(Level.SEVERE, "Uncaught exception in Payara Scheduled Executor thread ", thrwbl));
                return t;
            });
            this.scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
        } else {
            int threadPoolExecutorQueueSize = Integer.valueOf(this.payaraExecutorServiceConfiguration.getThreadPoolExecutorQueueSize());
            this.threadPoolExecutor = threadPoolExecutorQueueSize > 0 ? new ThreadPoolExecutor((int)Integer.valueOf(this.payaraExecutorServiceConfiguration.getThreadPoolExecutorCorePoolSize()), (int)Integer.valueOf(this.payaraExecutorServiceConfiguration.getThreadPoolExecutorMaxPoolSize()), (long)Integer.valueOf(this.payaraExecutorServiceConfiguration.getThreadPoolExecutorKeepAliveTime()).intValue(), TimeUnit.valueOf(this.payaraExecutorServiceConfiguration.getThreadPoolExecutorKeepAliveTimeUnit()), new LinkedBlockingQueue<Runnable>(threadPoolExecutorQueueSize), r -> new Thread(r, "payara-executor-service-task")) : new ThreadPoolExecutor((int)Integer.valueOf(this.payaraExecutorServiceConfiguration.getThreadPoolExecutorCorePoolSize()), (int)Integer.valueOf(this.payaraExecutorServiceConfiguration.getThreadPoolExecutorMaxPoolSize()), (long)Integer.valueOf(this.payaraExecutorServiceConfiguration.getThreadPoolExecutorKeepAliveTime()).intValue(), TimeUnit.valueOf(this.payaraExecutorServiceConfiguration.getThreadPoolExecutorKeepAliveTimeUnit()), new SynchronousQueue<Runnable>(), r -> new Thread(r, "payara-executor-service-task"));
            this.threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
            this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor((int)Integer.valueOf(this.payaraExecutorServiceConfiguration.getScheduledThreadPoolExecutorCorePoolSize()), r -> {
                Thread t = new Thread(r, "payara-executor-service-scheduled-task");
                t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread thread, Throwable thrwbl) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Uncaught exception in Payara Scheduled Executor thread ", thrwbl);
                    }
                });
                return t;
            });
            this.scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
        }
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.threadPoolExecutor.submit(task);
    }

    public Future<?> submit(Runnable task) {
        return this.threadPoolExecutor.submit(task);
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return this.threadPoolExecutor.submit(task, result);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.scheduledThreadPoolExecutor.schedule(callable, delay, unit);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.scheduledThreadPoolExecutor.schedule(command, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduledThreadPoolExecutor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduledThreadPoolExecutor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public ExecutorService getUnderlyingExecutorService() {
        return this.threadPoolExecutor;
    }

    public ScheduledExecutorService getUnderlyingScheduledExecutorService() {
        return this.scheduledThreadPoolExecutor;
    }

    public int getExecutorThreadPoolSize() {
        return Integer.valueOf(this.payaraExecutorServiceConfiguration.getThreadPoolExecutorMaxPoolSize());
    }

    public int getScheduledExecutorThreadPoolSize() {
        return Integer.valueOf(this.payaraExecutorServiceConfiguration.getScheduledThreadPoolExecutorCorePoolSize());
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] propertyChangeEvents) {
        ArrayList<UnprocessedChangeEvent> unprocessedChanges = new ArrayList<UnprocessedChangeEvent>();
        boolean keepAliveChanged = false;
        block16: for (PropertyChangeEvent propertyChangeEvent : propertyChangeEvents) {
            switch (propertyChangeEvent.getPropertyName()) {
                case "thread-pool-executor-core-pool-size": {
                    if (!this.isCurrentInstanceMatchTarget(propertyChangeEvent) || propertyChangeEvent.getOldValue().equals(propertyChangeEvent.getNewValue())) continue block16;
                    this.threadPoolExecutor.setCorePoolSize((Integer)propertyChangeEvent.getNewValue());
                    continue block16;
                }
                case "thread-pool-executor-max-pool-size": {
                    if (!this.isCurrentInstanceMatchTarget(propertyChangeEvent) || propertyChangeEvent.getOldValue().equals(propertyChangeEvent.getNewValue())) continue block16;
                    this.threadPoolExecutor.setMaximumPoolSize((Integer)propertyChangeEvent.getNewValue());
                    continue block16;
                }
                case "thread-pool-executor-keep-alive-time": {
                    if (!this.isCurrentInstanceMatchTarget(propertyChangeEvent) || propertyChangeEvent.getOldValue().equals(propertyChangeEvent.getNewValue()) || keepAliveChanged) continue block16;
                    for (PropertyChangeEvent pce : propertyChangeEvents) {
                        if (!this.isCurrentInstanceMatchTarget(pce) || !pce.getPropertyName().equals("thread-pool-executor-keep-alive-time-unit")) continue;
                        if (!pce.getOldValue().equals(pce.getNewValue())) {
                            keepAliveChanged = true;
                            this.threadPoolExecutor.setKeepAliveTime(Long.valueOf((String)propertyChangeEvent.getNewValue()), TimeUnit.valueOf((String)pce.getNewValue()));
                            continue;
                        }
                        this.threadPoolExecutor.setKeepAliveTime(((Integer)propertyChangeEvent.getNewValue()).intValue(), TimeUnit.valueOf(this.payaraExecutorServiceConfiguration.getThreadPoolExecutorKeepAliveTimeUnit()));
                    }
                    if (keepAliveChanged) continue block16;
                    this.threadPoolExecutor.setKeepAliveTime(Long.valueOf((String)propertyChangeEvent.getNewValue()), TimeUnit.valueOf(this.payaraExecutorServiceConfiguration.getThreadPoolExecutorKeepAliveTimeUnit()));
                    continue block16;
                }
                case "thread-pool-executor-keep-alive-time-unit": {
                    if (!this.isCurrentInstanceMatchTarget(propertyChangeEvent) || propertyChangeEvent.getOldValue().equals(propertyChangeEvent.getNewValue()) || keepAliveChanged) continue block16;
                    for (PropertyChangeEvent pce : propertyChangeEvents) {
                        if (!this.isCurrentInstanceMatchTarget(pce) || !pce.getPropertyName().equals("thread-pool-executor-keep-alive-time")) continue;
                        if (!pce.getOldValue().equals(pce.getNewValue())) {
                            keepAliveChanged = true;
                            this.threadPoolExecutor.setKeepAliveTime(Long.valueOf((String)pce.getNewValue()), TimeUnit.valueOf((String)propertyChangeEvent.getNewValue()));
                            continue;
                        }
                        this.threadPoolExecutor.setKeepAliveTime(Long.valueOf(this.payaraExecutorServiceConfiguration.getThreadPoolExecutorKeepAliveTime()), TimeUnit.valueOf((String)propertyChangeEvent.getNewValue()));
                    }
                    if (keepAliveChanged) continue block16;
                    this.threadPoolExecutor.setKeepAliveTime(Long.valueOf(this.payaraExecutorServiceConfiguration.getThreadPoolExecutorKeepAliveTime()), TimeUnit.valueOf((String)propertyChangeEvent.getNewValue()));
                    continue block16;
                }
                case "thread-pool-executor-queue-size": {
                    if (!this.isCurrentInstanceMatchTarget(propertyChangeEvent) || propertyChangeEvent.getOldValue().equals(propertyChangeEvent.getNewValue())) continue block16;
                    unprocessedChanges.add(new UnprocessedChangeEvent(propertyChangeEvent, "Payara Executor Service requires restarting"));
                    continue block16;
                }
                case "scheduled-thread-pool-executor-core-pool-size": {
                    if (!this.isCurrentInstanceMatchTarget(propertyChangeEvent) || propertyChangeEvent.getOldValue().equals(propertyChangeEvent.getNewValue())) continue block16;
                    this.scheduledThreadPoolExecutor.setCorePoolSize((Integer)propertyChangeEvent.getNewValue());
                }
            }
        }
        if (unprocessedChanges.isEmpty()) {
            return null;
        }
        return new UnprocessedChangeEvents(unprocessedChanges);
    }

    private boolean isCurrentInstanceMatchTarget(PropertyChangeEvent pe) {
        ConfigBeanProxy proxy;
        if (this.serverEnvironment.isInstance()) {
            return true;
        }
        for (proxy = (ConfigBeanProxy)pe.getSource(); proxy != null && !(proxy instanceof Config); proxy = proxy.getParent()) {
        }
        if (proxy != null) {
            return ((Config)proxy).isDas();
        }
        return false;
    }

    public boolean isACC() {
        return this.processEnvironment.getProcessType().equals((Object)ProcessEnvironment.ProcessType.ACC);
    }
}

