/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.executorservice.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.nucleus.executorservice.PayaraExecutorServiceConfiguration;
import java.util.HashMap;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-payara-executor-service-configuration")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=PayaraExecutorServiceConfiguration.class, opType=RestEndpoint.OpType.GET, path="get-payara-executor-service-configuration", description="Gets the Payara Executor Service Configuration")})
public class GetPayaraExecutorServiceConfigurationCommand
implements AdminCommand {
    @Inject
    private Target targetUtil;
    @Param(name="target", optional=true, defaultValue="server-config")
    String target;
    private static final String[] HEADERS = new String[]{"Thread Pool Executor Core Pool Size", "Thread Pool Executor Max Pool Size", "Thread Pool Executor Keep Alive Time", "Thread Pool Executor Keep Alive Time Unit", "Thread Pool Executor Queue Size", "Scheduled Thread Pool Executor Core Pool Size"};

    public void execute(AdminCommandContext acc) {
        Config configNode = this.targetUtil.getConfig(this.target);
        PayaraExecutorServiceConfiguration payaraExecutorServiceConfiguration = (PayaraExecutorServiceConfiguration)configNode.getExtensionByType(PayaraExecutorServiceConfiguration.class);
        ColumnFormatter columnFormatter = new ColumnFormatter(HEADERS);
        Object[] values = new Object[]{payaraExecutorServiceConfiguration.getThreadPoolExecutorCorePoolSize(), payaraExecutorServiceConfiguration.getThreadPoolExecutorMaxPoolSize(), payaraExecutorServiceConfiguration.getThreadPoolExecutorKeepAliveTime(), payaraExecutorServiceConfiguration.getThreadPoolExecutorKeepAliveTimeUnit(), payaraExecutorServiceConfiguration.getThreadPoolExecutorQueueSize(), payaraExecutorServiceConfiguration.getScheduledThreadPoolExecutorCorePoolSize()};
        columnFormatter.addRow(values);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Properties extraProps = new Properties();
        map.put("threadPoolExecutorCorePoolSize", values[0]);
        map.put("threadPoolExecutorMaxPoolSize", values[1]);
        map.put("threadPoolExecutorKeepAliveTime", values[2]);
        map.put("threadPoolExecutorKeepAliveTimeUnit", values[3]);
        map.put("threadPoolExecutorQueueSize", values[4]);
        map.put("scheduledThreadPoolExecutorCorePoolSize", values[5]);
        extraProps.put("payaraExecutorServiceConfiguration", map);
        acc.getActionReport().setExtraProperties(extraProps);
        acc.getActionReport().setMessage(columnFormatter.toString());
    }
}

