/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.optional.DBControl;
import java.lang.reflect.Method;
import java.sql.DriverManager;
import java.sql.SQLException;

public final class H2Control
extends DBControl {
    public static final String DB_LOG_FILENAME = "h2.log";
    public static final String JDBC_DRIVER = "org.h2.Driver";

    public H2Control(String dbCommand, String dbHost, String dbPort, String redirect, String dbHome, String dbUser, String dbPassword) {
        super(dbCommand, dbHost, dbPort, redirect, dbHome, dbUser, dbPassword);
        if (this.getDbHome() != null && this.getDbHome().length() > 0) {
            System.setProperty("h2.system.home", this.getDbHome());
        }
        System.setProperty("h2.infolog.append", "true");
    }

    public H2Control(String dbCommand, String dbHost, String dbPort) {
        this(dbCommand, dbHost, dbPort, "true", null, null, null);
    }

    public H2Control(String dbCommand, String dbHost, String dbPort, String redirect) {
        this(dbCommand, dbHost, dbPort, redirect, null, null, null);
    }

    public H2Control(String dbCommand, String dbHost, String dbPort, String redirect, String dbHome) {
        this(dbCommand, dbHost, dbPort, redirect, dbHome, null, null);
    }

    public H2Control(String dbCommand, String dbHost, String dbPort, String redirect, String dbUser, String dbPassword) {
        this(dbCommand, dbHost, dbPort, redirect, null, dbUser, dbPassword);
    }

    private void invokeServer() {
        try {
            Class<?> serverClass = Class.forName("org.h2.tools.Server");
            String dbPassword = this.getDbPassword() == null ? "" : this.getDbPassword();
            String url = "tcp://localhost:" + this.getDbPort();
            if (null != this.getDbCommand()) {
                switch (this.getDbCommand()) {
                    case "start": {
                        Method createTcpServer = serverClass.getDeclaredMethod("createTcpServer", String[].class);
                        Object[] paramObj = new Object[]{new String[]{"-tcpPort", this.getDbPort(), "-tcpPassword", dbPassword, "-tcpAllowOthers"}};
                        Object server = createTcpServer.invoke(serverClass, paramObj);
                        serverClass.getDeclaredMethod("start", new Class[0]).invoke(server, new Object[0]);
                        System.out.println(serverClass.getDeclaredMethod("getStatus", new Class[0]).invoke(server, new Object[0]));
                        break;
                    }
                    case "ping": {
                        Class.forName(JDBC_DRIVER);
                        try {
                            DriverManager.getConnection(String.format("jdbc:h2:%s/mem:management_db_%s", url, this.getDbPort()), "", dbPassword).close();
                        }
                        catch (SQLException sqle) {
                            Runtime.getRuntime().exit(2);
                        }
                        break;
                    }
                    case "sysinfo": {
                        Method createTcpServer = serverClass.getDeclaredMethod("createTcpServer", String[].class);
                        Object[] paramObj = new Object[]{new String[]{"-tcpPort", this.getDbPort(), "-tcpAllowOthers"}};
                        Object server = createTcpServer.invoke(serverClass, paramObj);
                        System.out.println(serverClass.getDeclaredMethod("getURL", new Class[0]).invoke(server, new Object[0]));
                        break;
                    }
                    case "shutdown": {
                        Method shutdownTcpServer = serverClass.getDeclaredMethod("shutdownTcpServer", String.class, String.class, Boolean.TYPE, Boolean.TYPE);
                        Object[] paramObj = new Object[]{url, dbPassword, true, true};
                        shutdownTcpServer.invoke(serverClass, paramObj);
                        break;
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Runtime.getRuntime().exit(2);
        }
    }

    @Override
    public String getLogFileName() {
        return DB_LOG_FILENAME;
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("paramters not specified.");
            System.out.println("H2Control <h2 command> <h2 host> <h2 port> <h2 home> <redirect output>");
            System.exit(1);
        }
        H2Control h2Control = null;
        if (args.length == 3) {
            h2Control = new H2Control(args[0], args[1], args[2]);
        } else if (args.length == 4) {
            h2Control = new H2Control(args[0], args[1], args[2], args[3]);
        } else if (args.length == 5) {
            h2Control = new H2Control(args[0], args[1], args[2], args[3], args[4]);
        } else if (args.length > 5) {
            h2Control = new H2Control(args[0], args[1], args[2], args[3], args[4], args[5]);
        }
        if (h2Control != null) {
            h2Control.invokeServer();
        }
    }
}

