/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.deployment.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import org.eclipse.transformer.payara.JakartaNamespaceTransformer;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;

public class PayaraTransformer {
    public static final String TRANSFORM_NAMESPACE = "fish.payara.deployment.transform.namespace";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PayaraTransformer.class);
    private static final String[] commonJavaxClasses = new String[]{"javax.inject.Inject", "javax.servlet.http.HttpServlet", "javax.ws.rs.core.Application", "javax.persistence.Entity"};
    private static final String[] commonJakartaClasses = new String[]{"jakarta.inject.Inject", "jakarta.servlet.http.HttpServlet", "jakarta.ws.rs.core.Application", "jakarta.persistence.Entity"};
    private static final String JAKARTA_PACKAGE_PREFIX = "jakarta.";

    public static boolean isJakartaEEApplication(Types types) {
        for (String _class : commonJavaxClasses) {
            if (types.getBy(_class) == null) continue;
            return false;
        }
        for (String _class : commonJakartaClasses) {
            if (types.getBy(_class) == null) continue;
            return true;
        }
        for (Type classType : types.getAllTypes()) {
            if (!classType.getName().startsWith(JAKARTA_PACKAGE_PREFIX)) continue;
            return true;
        }
        return false;
    }

    public static File transformApplication(File path, AdminCommandContext context, boolean isDirectoryDeployed) throws IOException {
        JakartaNamespaceTransformer transformer = new JakartaNamespaceTransformer(context.getLogger(), path, true);
        int result = transformer.run();
        if (result == 0) {
            File output = transformer.getOutput();
            Path newPath = output.toPath();
            if (!isDirectoryDeployed) {
                Files.walk(path.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                newPath = Files.move(output.toPath(), path.toPath(), new CopyOption[0]);
                if (newPath == null) {
                    String msg = localStrings.getLocalString("application.namespace.transform.failed", "Application namespace transformation failed");
                    context.getActionReport().failure(context.getLogger(), msg);
                    return null;
                }
            }
            return newPath.toFile();
        }
        String msg = localStrings.getLocalString("application.namespace.transform.failed", "Application namespace transformation failed");
        context.getActionReport().failure(context.getLogger(), msg);
        return null;
    }
}

