/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.jwtauth.jaxrs;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import javax.annotation.Priority;
import javax.enterprise.inject.spi.CDI;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.SecurityContext;
import javax.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;

@Priority(value=2000)
public class RolesAllowedRequestFilter
implements ContainerRequestFilter {
    private final SecurityContext securityContext;
    private final String[] rolesAllowed;
    private final boolean permitAll;
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    RolesAllowedRequestFilter(HttpServletRequest request, HttpServletResponse response, String[] rolesAllowed) {
        this(request, response, rolesAllowed, false);
    }

    RolesAllowedRequestFilter(HttpServletRequest request, HttpServletResponse response) {
        this(request, response, null, true);
    }

    private RolesAllowedRequestFilter(HttpServletRequest request, HttpServletResponse response, String[] rolesAllowed, boolean permitAll) {
        this.request = request;
        this.response = response;
        this.rolesAllowed = rolesAllowed;
        this.securityContext = (SecurityContext)CDI.current().select(SecurityContext.class, new Annotation[0]).get();
        this.permitAll = permitAll;
        assert (permitAll == (rolesAllowed == null));
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        boolean hasRole;
        if (this.permitAll) {
            this.securityContext.authenticate(this.request, this.response, AuthenticationParameters.withParams());
            return;
        }
        if (this.rolesAllowed.length > 0 && !this.isAuthenticated()) {
            AuthenticationStatus status = this.securityContext.authenticate(this.request, this.response, AuthenticationParameters.withParams());
            if (status == AuthenticationStatus.NOT_DONE || status == AuthenticationStatus.SEND_FAILURE) {
                throw new NotAuthorizedException("Authentication resulted in " + status, Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
            if (status == AuthenticationStatus.SUCCESS && !this.isAuthenticated()) {
                throw new NotAuthorizedException("Authentication not done (i.e. no JWT credential found)", Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
        }
        if (!(hasRole = Arrays.stream(this.rolesAllowed).anyMatch(r -> requestContext.getSecurityContext().isUserInRole(r)))) {
            throw new ForbiddenException("Caller not in requested role");
        }
    }

    private boolean isAuthenticated() {
        return this.securityContext.getCallerPrincipal() != null;
    }
}

