/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.cpool;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.resource.pool.PoolStatus;
import fish.payara.monitoring.collect.MonitoringData;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.monitoring.collect.MonitoringWatchCollector;
import fish.payara.monitoring.collect.MonitoringWatchSource;
import fish.payara.notification.healthcheck.HealthCheckResultEntry;
import fish.payara.nucleus.healthcheck.HealthCheckResult;
import fish.payara.nucleus.healthcheck.cpool.HealthCheckConnectionPoolExecutionOptions;
import fish.payara.nucleus.healthcheck.cpool.configuration.ConnectionPoolChecker;
import fish.payara.nucleus.healthcheck.preliminary.BaseThresholdHealthCheck;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.glassfish.jdbc.config.JdbcResource;
import org.glassfish.jdbc.util.JdbcResourcesUtil;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.jvnet.hk2.annotations.Service;

@Service(name="healthcheck-cpool")
@RunLevel(value=10)
public class ConnectionPoolHealthCheck
extends BaseThresholdHealthCheck<HealthCheckConnectionPoolExecutionOptions, ConnectionPoolChecker>
implements MonitoringDataSource,
MonitoringWatchSource {
    @Inject
    private Domain domain;
    @Inject
    private Applications applications;
    @Inject
    private PoolManager poolManager;

    @PostConstruct
    void postConstruct() {
        this.postConstruct(this, ConnectionPoolChecker.class);
    }

    @Override
    public HealthCheckConnectionPoolExecutionOptions constructOptions(ConnectionPoolChecker checker) {
        return new HealthCheckConnectionPoolExecutionOptions(Boolean.valueOf(checker.getEnabled()), Long.parseLong(checker.getTime()), this.asTimeUnit(checker.getUnit()), Boolean.valueOf(checker.getAddToMicroProfileHealth()), checker.getPropertyValue("threshold-critical", "80"), checker.getPropertyValue("threshold-warning", "50"), checker.getPropertyValue("threshold-good", "0"), checker.getPoolName());
    }

    @Override
    protected String getDescription() {
        return "healthcheck.description.connectionPool";
    }

    @Override
    protected HealthCheckResult doCheckInternal() {
        HealthCheckResult result = new HealthCheckResult();
        this.consumeAllJdbcResources(this.createConsumer((info, usedPercentage) -> result.add(new HealthCheckResultEntry(this.decideOnStatusWithRatio((double)usedPercentage), info.getName() + " Usage (%): " + new DecimalFormat("#.00").format(usedPercentage)))));
        return result;
    }

    public void collect(MonitoringWatchCollector collector) {
        this.collectUsage(collector, "ns:health @:* PoolUsage", "Connection Pool Usage", 5, false);
    }

    @MonitoringData(ns="health", intervalSeconds=8)
    public void collect(MonitoringDataCollector collector) {
        if (this.options != null && ((HealthCheckConnectionPoolExecutionOptions)this.options).isEnabled()) {
            this.consumeAllJdbcResources(this.createConsumer((info, usedPercentage) -> collector.group((CharSequence)info.getName()).collect((CharSequence)"PoolUsage", usedPercentage.longValue())));
        }
    }

    private Consumer<JdbcResource> createConsumer(BiConsumer<PoolInfo, Double> poolUsageConsumer) {
        return resource -> {
            long freeConnection;
            long usedConnection;
            long totalConnection;
            PoolStatus poolStatus;
            ResourceInfo resourceInfo = ResourceUtil.getResourceInfo((BindableResource)resource);
            JdbcConnectionPool pool = JdbcResourcesUtil.createInstance().getJdbcConnectionPoolOfResource(resourceInfo);
            PoolInfo poolInfo = ResourceUtil.getPoolInfo((ResourcePool)pool);
            String name = ((HealthCheckConnectionPoolExecutionOptions)this.getOptions()).getPoolName();
            if ((name == null || name.equals(poolInfo.getName())) && (poolStatus = this.poolManager.getPoolStatus(poolInfo)) != null && (totalConnection = (usedConnection = (long)poolStatus.getNumConnUsed()) + (freeConnection = (long)poolStatus.getNumConnFree())) > 0L) {
                double usedPercentage = 100.0 * (double)usedConnection / (double)totalConnection;
                poolUsageConsumer.accept(poolInfo, usedPercentage);
            }
        };
    }

    private void consumeAllJdbcResources(Consumer<JdbcResource> consumer) {
        ConnectionPoolHealthCheck.consumeJdbcResources(this.domain.getResources(), consumer);
        for (Application app : this.applications.getApplications()) {
            if (!ResourcesUtil.createInstance().isEnabled(app)) continue;
            ConnectionPoolHealthCheck.consumeJdbcResources(app.getResources(), consumer);
            List modules = app.getModule();
            if (modules == null) continue;
            for (Module module : modules) {
                ConnectionPoolHealthCheck.consumeJdbcResources(module.getResources(), consumer);
            }
        }
    }

    private static void consumeJdbcResources(Resources resources, Consumer<JdbcResource> consumer) {
        List list;
        if (resources != null && (list = resources.getResources()) != null) {
            for (Resource r : list) {
                if (!JdbcResource.class.isInstance(r)) continue;
                consumer.accept((JdbcResource)r);
            }
        }
    }
}

