/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.opentracing;

import fish.payara.ejb.opentracing.OpenTracingIiopClientInterceptor;
import fish.payara.ejb.opentracing.OpenTracingIiopServerInterceptor;
import fish.payara.opentracing.OpenTracingService;
import java.lang.annotation.Annotation;
import javax.inject.Singleton;
import org.glassfish.enterprise.iiop.api.IIOPInterceptorFactory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Service;
import org.omg.IOP.Codec;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

@Service(name="OpenTracingIiopInterceptorFactory")
@Singleton
public class OpenTracingIiopInterceptorFactory
implements IIOPInterceptorFactory {
    public static final int OPENTRACING_IIOP_ID = 3226428;
    public static final long OPENTRACING_IIOP_SERIAL_VERSION_UID = 20200731171822L;
    private ClientRequestInterceptor clientRequestInterceptor;
    private ServerRequestInterceptor serverRequestInterceptor;
    private OpenTracingService openTracingService;
    private ServiceLocator serviceLocator;

    @Override
    public ClientRequestInterceptor createClientRequestInterceptor(ORBInitInfo info, Codec codec) {
        if (this.clientRequestInterceptor == null && this.attemptCreation()) {
            this.clientRequestInterceptor = new OpenTracingIiopClientInterceptor(this.openTracingService);
        }
        return this.clientRequestInterceptor;
    }

    @Override
    public ServerRequestInterceptor createServerRequestInterceptor(ORBInitInfo info, Codec codec) {
        if (this.serverRequestInterceptor == null && this.attemptCreation()) {
            this.serverRequestInterceptor = new OpenTracingIiopServerInterceptor(this.openTracingService);
        }
        return this.serverRequestInterceptor;
    }

    private boolean attemptCreation() {
        if (this.serviceLocator == null) {
            this.serviceLocator = Globals.getStaticBaseServiceLocator();
            if (this.serviceLocator == null) {
                return false;
            }
        }
        if (this.openTracingService == null) {
            this.openTracingService = (OpenTracingService)this.serviceLocator.getService(OpenTracingService.class, new Annotation[0]);
            if (this.openTracingService == null) {
                return false;
            }
        }
        return true;
    }
}

