/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.api;

import fish.payara.security.openid.api.AccessToken;
import fish.payara.security.openid.api.JwtClaims;
import fish.payara.security.openid.api.OpenIdClaims;
import java.util.function.Supplier;
import javax.security.enterprise.CallerPrincipal;

public class AccessTokenCallerPrincipal
extends CallerPrincipal {
    private final AccessToken accessToken;
    private final Supplier<OpenIdClaims> userInfoSupplier;

    public AccessTokenCallerPrincipal(AccessToken token, Supplier<OpenIdClaims> userInfoSupplier) {
        super((String)token.getClaim("sub"));
        this.accessToken = token;
        this.userInfoSupplier = userInfoSupplier;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public JwtClaims getClaims() {
        return this.accessToken.getJwtClaims();
    }

    public boolean hasAudience(String audience) {
        return this.getClaims().getAudience().contains(audience);
    }

    public OpenIdClaims getUserInfoClaims() {
        return this.userInfoSupplier.get();
    }
}

