/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.admin;

import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.notification.requesttracing.RequestTrace;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.nucleus.requesttracing.configuration.RequestTracingServiceConfiguration;
import fish.payara.nucleus.requesttracing.domain.execoptions.RequestTracingExecutionOptions;
import fish.payara.nucleus.requesttracing.store.RequestTraceStoreInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@Service(name="list-requesttraces")
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@I18n(value="requesttracing.configure")
@RestEndpoints(value={@RestEndpoint(configBean=RequestTracingServiceConfiguration.class, opType=RestEndpoint.OpType.GET, path="list-requesttraces", description="List slowest request traces stored.")})
public class ListRequestTraces
implements AdminCommand {
    private static final String[] headers = new String[]{"Occurring Time", "Elapsed Time", "Traced Message"};
    @Inject
    protected Target targetUtil;
    @Param(name="target", optional=true, defaultValue="server-config")
    protected String target;
    @Param(name="first", optional=true)
    private Integer first;
    @Param(name="historicTraces", optional=true, alias="historictraces")
    private Boolean historicTraces;
    @Inject
    private RequestTracingService service;
    @Inject
    ServerEnvironment server;

    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        RequestTracingExecutionOptions executionOptions = this.service.getExecutionOptions();
        if ((this.historicTraces == null || this.historicTraces.booleanValue()) && !executionOptions.isHistoricTraceStoreEnabled().booleanValue()) {
            actionReport.setMessage("Historic Request Trace Store is not enabled!");
            actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        } else if (this.server.isDas()) {
            if (this.targetUtil.getConfig(this.target).isDas()) {
                this.generateReport(actionReport);
            }
        } else {
            this.generateReport(actionReport);
        }
    }

    private void generateReport(ActionReport actionReport) {
        RequestTracingExecutionOptions executionOptions = this.service.getExecutionOptions();
        if (this.first == null) {
            this.first = executionOptions.getTraceStoreSize();
        }
        RequestTraceStoreInterface eventStore = this.historicTraces == null || this.historicTraces != false ? this.service.getHistoricRequestTraceStore() : this.service.getRequestTraceStore();
        ColumnFormatter columnFormatter = new ColumnFormatter(headers);
        Properties extrasProps = new Properties();
        ArrayList tracesList = new ArrayList();
        Collection<RequestTrace> traces = eventStore.getTraces(this.first);
        for (RequestTrace requestTrace : traces) {
            LinkedHashMap<String, String> messages = new LinkedHashMap<String, String>();
            Object[] values = new Object[]{requestTrace.getStartTime(), requestTrace.getElapsedTime(), requestTrace.toString()};
            messages.put("occuringTime", values[0].toString());
            messages.put("elapsedTime", values[1].toString());
            messages.put("message", (String)values[2]);
            tracesList.add(messages);
            columnFormatter.addRow(values);
        }
        actionReport.setMessage(columnFormatter.toString());
        extrasProps.put("traces", tracesList);
        actionReport.setExtraProperties(extrasProps);
        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

