/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck;

import fish.payara.nucleus.hazelcast.HazelcastCore;
import fish.payara.nucleus.healthcheck.BoundedTreeSet;
import fish.payara.nucleus.healthcheck.HistoricHealthCheckEvent;
import fish.payara.nucleus.store.ClusteredStore;
import java.io.Serializable;
import java.util.NavigableSet;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class HistoricHealthCheckEventStore {
    private static final String HISTORIC_HEALTHCHECK_EVENT_STORE = "HISTORIC_HEALTHCHECK_EVENT_STORE";
    @Inject
    private HazelcastCore hzCore;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    ClusteredStore store;
    private BoundedTreeSet<HistoricHealthCheckEvent> historicStore;

    void initialize(int storeSize) {
        this.historicStore = new BoundedTreeSet(storeSize);
        if (this.hzCore.isEnabled()) {
            String instanceName = this.serverEnv.getInstanceName();
            BoundedTreeSet instanceHistoricStore = (BoundedTreeSet)this.store.get(HISTORIC_HEALTHCHECK_EVENT_STORE, (Serializable)((Object)instanceName));
            if (instanceHistoricStore == null) {
                this.store.set(HISTORIC_HEALTHCHECK_EVENT_STORE, (Serializable)((Object)instanceName), this.historicStore);
            } else {
                this.historicStore = instanceHistoricStore;
            }
        }
    }

    public void addTrace(long occurringTime, Level level, String userMessage, String message, Object[] parameters) {
        this.historicStore.add(new HistoricHealthCheckEvent(occurringTime, level, userMessage, message, parameters));
    }

    public HistoricHealthCheckEvent[] getTraces() {
        HistoricHealthCheckEvent[] emptyArray = new HistoricHealthCheckEvent[]{};
        if (this.historicStore != null) {
            return this.historicStore.toArray(emptyArray);
        }
        return emptyArray;
    }

    public HistoricHealthCheckEvent[] getTraces(Integer limit) {
        HistoricHealthCheckEvent[] result = null;
        if (this.historicStore != null) {
            HistoricHealthCheckEvent[] historicEvents = this.historicStore.toArray(new HistoricHealthCheckEvent[this.historicStore.size()]);
            if (limit < historicEvents.length) {
                result = new HistoricHealthCheckEvent[limit.intValue()];
                System.arraycopy(historicEvents, 0, result, 0, limit);
            } else {
                result = historicEvents;
            }
        }
        return result;
    }

    public NavigableSet<HistoricHealthCheckEvent> getHistoricStore() {
        return this.historicStore;
    }
}

