/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.admin;

import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.nucleus.healthcheck.HealthCheckService;
import fish.payara.nucleus.healthcheck.HistoricHealthCheckEvent;
import fish.payara.nucleus.healthcheck.HistoricHealthCheckEventStore;
import fish.payara.nucleus.healthcheck.configuration.HealthCheckServiceConfiguration;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@Service(name="list-historic-healthchecks")
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@I18n(value="requesttracing.configure")
@RestEndpoints(value={@RestEndpoint(configBean=HealthCheckServiceConfiguration.class, opType=RestEndpoint.OpType.GET, path="list-historic-healthchecks", description="List latest health checks traces stored historically.")})
public class ListHistoricHealthChecks
implements AdminCommand {
    private static final String SEPARATOR = " - ";
    private static final String[] headers = new String[]{"Occurring Date", "Health Check Message"};
    @Inject
    protected Target targetUtil;
    @Param(name="target", optional=true, defaultValue="server-config")
    protected String target;
    @Param(name="first", optional=true)
    private Integer first;
    @Inject
    private HealthCheckService service;
    @Inject
    private HistoricHealthCheckEventStore eventStore;
    @Inject
    ServerEnvironment server;

    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        if (!this.service.isEnabled()) {
            actionReport.setMessage("Health Check service is not enabled");
            return;
        }
        if (this.server.isDas()) {
            if (this.targetUtil.getConfig(this.target).isDas()) {
                this.generateReport(actionReport);
            }
        } else {
            this.generateReport(actionReport);
        }
    }

    private void generateReport(ActionReport actionReport) {
        if (this.first == null) {
            this.first = this.service.getHistoricalTraceStoreSize();
        }
        HistoricHealthCheckEvent[] traces = this.eventStore.getTraces(this.first);
        ColumnFormatter columnFormatter = new ColumnFormatter(headers);
        Properties extrasProps = new Properties();
        ArrayList historic = new ArrayList();
        if (traces != null) {
            for (HistoricHealthCheckEvent historicHealthCheckEvent : traces) {
                LinkedHashMap<String, String> messages = new LinkedHashMap<String, String>();
                Object[] values = new Object[]{new Date(historicHealthCheckEvent.getOccurringTime()), this.constructMessage(historicHealthCheckEvent)};
                messages.put("dateTime", values[0].toString());
                messages.put("message", (String)values[1]);
                historic.add(messages);
                columnFormatter.addRow(values);
            }
        }
        actionReport.setMessage(columnFormatter.toString());
        extrasProps.put("historicmessages", historic);
        actionReport.setExtraProperties(extrasProps);
        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private String constructMessage(HistoricHealthCheckEvent event) {
        if (event.getParameters() != null && event.getParameters().length > 0) {
            String formattedText = MessageFormat.format(event.getMessage(), event.getParameters());
            return event.getLevel() + SEPARATOR + (event.getUserMessage() != null ? event.getUserMessage() + SEPARATOR + formattedText : formattedText);
        }
        return event.getLevel() + SEPARATOR + (event.getUserMessage() != null ? event.getUserMessage() + SEPARATOR + event.getMessage() : event.getMessage());
    }
}

