/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.nucleus.healthcheck.HealthCheckExecutionOptions;
import fish.payara.nucleus.healthcheck.HealthCheckService;
import fish.payara.nucleus.healthcheck.HealthCheckWithThresholdExecutionOptions;
import fish.payara.nucleus.healthcheck.configuration.Checker;
import fish.payara.nucleus.healthcheck.configuration.CheckerConfigurationType;
import fish.payara.nucleus.healthcheck.configuration.CheckerType;
import fish.payara.nucleus.healthcheck.configuration.HealthCheckServiceConfiguration;
import fish.payara.nucleus.healthcheck.configuration.HoggingThreadsChecker;
import fish.payara.nucleus.healthcheck.configuration.MicroProfileMetricsChecker;
import fish.payara.nucleus.healthcheck.configuration.MonitoredMetric;
import fish.payara.nucleus.healthcheck.configuration.StuckThreadsChecker;
import fish.payara.nucleus.healthcheck.configuration.ThresholdDiagnosticsChecker;
import fish.payara.nucleus.healthcheck.preliminary.BaseHealthCheck;
import fish.payara.nucleus.healthcheck.preliminary.BaseThresholdHealthCheck;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="set-healthcheck-service-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="healthcheck.configure.service")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=HealthCheckServiceConfiguration.class, opType=RestEndpoint.OpType.POST, path="set-healthcheck-service-configuration", description="Enables/Disables Health Check Service Specified With Name")})
public class SetHealthCheckServiceConfiguration
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(SetHealthCheckServiceConfiguration.class);
    @Inject
    private ServiceLocator habitat;
    @Inject
    private Target targetUtil;
    @Inject
    private Logger logger;
    @Inject
    private HealthCheckService healthCheckService;
    @Inject
    private ServerEnvironment server;
    @Inject
    private Domain domain;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    private Config targetConfig;
    @Param(name="service", alias="serviceName")
    private String serviceName;
    private CheckerType serviceType;
    @Param(name="dynamic", optional=true, defaultValue="false")
    private boolean dynamic;
    @Param(name="checker-name", alias="checkerName", optional=true)
    private String checkerName;
    @Param(name="add-to-microprofile-health", alias="addToMicroProfileHealth", optional=true, defaultValue="false")
    private Boolean addToMicroProfileHealth;
    @Param(name="enabled", optional=true)
    private Boolean enabled;
    @Param(name="time", optional=true)
    @Min(value=1L, message="Time period must be 1 or more")
    private @Min(value=1L, message="Time period must be 1 or more") String time;
    @Param(name="time-unit", alias="unit", optional=true, acceptableValues="DAYS,HOURS,MICROSECONDS,MILLISECONDS,MINUTES,NANOSECONDS,SECONDS")
    private String timeUnit;
    @Param(name="hogging-threads-threshold", alias="threshold-percentage", optional=true)
    @Min(value=0L, message="Hogging threads threshold is a percentage so must be greater than zero")
    @Max(value=100L, message="Hogging threads threshold is a percentage so must be less than 100")
    private @Min(value=0L, message="Hogging threads threshold is a percentage so must be greater than zero") @Max(value=100L, message="Hogging threads threshold is a percentage so must be less than 100") String hogginThreadsThreshold;
    @Min(value=0L, message="Hogging threads retry count must be zero or more")
    @Param(name="hogging-threads-retry-count", alias="retry-count", optional=true)
    private @Min(value=0L, message="Hogging threads retry count must be zero or more") String hogginThreadsRetryCount;
    @Param(name="stuck-threads-threshold", alias="threshold", optional=true)
    @Min(value=1L, message="Threshold length must be 1 or more")
    private @Min(value=1L, message="Threshold length must be 1 or more") String stuckThreadsThreshold;
    @Param(name="stuck-threads-threshold-unit", alias="thresholdUnit", optional=true, acceptableValues="DAYS,HOURS,MILLISECONDS,MINUTES,SECONDS")
    private String stuckThreadsThresholdUnit;
    @Param(name="threshold-critical", alias="thresholdCritical", optional=true, defaultValue="80")
    @Min(value=0L, message="Critical threshold is a percentage so must be greater than zero")
    @Max(value=100L, message="Critical threshold is a percentage so must be less than 100")
    private @Min(value=0L, message="Critical threshold is a percentage so must be greater than zero") @Max(value=100L, message="Critical threshold is a percentage so must be less than 100") String thresholdCritical;
    @Param(name="threshold-warning", alias="thresholdWarning", optional=true, defaultValue="50")
    @Min(value=0L, message="Warning threshold is a percentage so must be greater than zero")
    @Max(value=100L, message="Wanring threshold is a percentage so must be less than 100")
    private @Min(value=0L, message="Warning threshold is a percentage so must be greater than zero") @Max(value=100L, message="Wanring threshold is a percentage so must be less than 100") String thresholdWarning;
    @Param(name="threshold-good", alias="thresholdGood", optional=true, defaultValue="0")
    @Min(value=0L, message="Good threshold is a percentage so must be greater than zero")
    @Max(value=100L, message="Good threshold is a percentage so must be less than 100")
    private @Min(value=0L, message="Good threshold is a percentage so must be greater than zero") @Max(value=100L, message="Good threshold is a percentage so must be less than 100") String thresholdGood;
    @Param(name="add-metric", optional=true, multiple=true, alias="addMetric")
    private List<String> metricsToAdd;
    @Param(name="delete-metric", optional=true, multiple=true, alias="deleteMetric")
    private List<String> metricsToRemove;
    private ActionReport report;

    public void execute(AdminCommandContext context) {
        this.report = context.getActionReport();
        if (this.report.getExtraProperties() == null) {
            this.report.setExtraProperties(new Properties());
        }
        this.targetConfig = this.targetUtil.getConfig(this.target);
        this.serviceType = SetHealthCheckServiceConfiguration.parseServiceType(this.serviceName);
        if (this.serviceType == null) {
            String values = Arrays.asList(CheckerType.values()).stream().map(type -> type.name().toLowerCase().replace('_', '-')).collect(Collectors.joining(", "));
            this.report.setMessage("No such service: " + this.serviceName + ".\nChoose one of: " + values + ".\nThe name can also be given in short form consisting only of the first letters of each word.");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        this.serviceName = this.serviceType.name().toLowerCase().replace('_', '-');
        BaseHealthCheck<?, ?> service = this.getService();
        if (service == null) {
            this.report.appendMessage(strings.getLocalString("healthcheck.service.configure.status.error", "Service with name {0} could not be found.", new Object[]{this.serviceName}));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        this.updateServiceConfiguration(service);
    }

    private static CheckerType parseServiceType(String serviceName) {
        if (serviceName.length() < 4) {
            for (CheckerType type : CheckerType.values()) {
                if (!Arrays.asList(type.name().split("_")).stream().map(w -> w.charAt(0) + "").collect(Collectors.joining("")).equals(serviceName.toUpperCase())) continue;
                return type;
            }
        } else {
            try {
                return CheckerType.valueOf(serviceName.toUpperCase().replace('-', '_'));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private BaseHealthCheck<?, ?> getService() {
        for (BaseHealthCheck service : this.habitat.getAllServices(BaseHealthCheck.class, new Annotation[0])) {
            if (service.getCheckerType().getAnnotation(CheckerConfigurationType.class).type() != this.serviceType) continue;
            return service;
        }
        return null;
    }

    private <O extends HealthCheckExecutionOptions, C extends Checker> void updateServiceConfiguration(BaseHealthCheck<O, C> service) {
        HealthCheckServiceConfiguration config = (HealthCheckServiceConfiguration)this.targetConfig.getExtensionByType(HealthCheckServiceConfiguration.class);
        Class checkerType = service.getCheckerType();
        C checker = config.getCheckerByType(checkerType);
        try {
            if (checker == null) {
                ConfigSupport.apply(configProxy -> {
                    Checker newChecker = (Checker)configProxy.createChild(checkerType);
                    configProxy.getCheckerList().add(newChecker);
                    this.updateProperties(newChecker, checkerType);
                    return configProxy;
                }, (ConfigBeanProxy)config);
            } else {
                ConfigSupport.apply(proxy -> this.updateProperties((Checker)proxy, checkerType), checker);
            }
            if (ThresholdDiagnosticsChecker.class.isAssignableFrom(checkerType)) {
                ThresholdDiagnosticsChecker thresholdDiagnosisConfig = (ThresholdDiagnosticsChecker)config.getCheckerByType(checkerType);
                this.updateProperty(thresholdDiagnosisConfig, "threshold-critical", this.thresholdCritical);
                this.updateProperty(thresholdDiagnosisConfig, "threshold-warning", this.thresholdWarning);
                this.updateProperty(thresholdDiagnosisConfig, "threshold-good", this.thresholdGood);
            }
            this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure ex) {
            this.logger.log(Level.WARNING, "Exception during command ", ex);
            this.report.setMessage(ex.getCause().getMessage());
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        if (this.dynamic && (!this.server.isDas() || this.targetConfig.isDas())) {
            this.configureDynamically(service, config.getCheckerByType(checkerType));
        }
    }

    private <C extends Checker, O extends HealthCheckExecutionOptions> void configureDynamically(BaseHealthCheck<O, C> service, C config) {
        MicroProfileMetricsChecker checker;
        service.setOptions(service.constructOptions(config));
        boolean register = true;
        if (config instanceof MicroProfileMetricsChecker && (checker = (MicroProfileMetricsChecker)config).getMonitoredMetrics().isEmpty()) {
            register = false;
        }
        if (register) {
            this.healthCheckService.registerCheck(config.getName(), service);
            this.healthCheckService.reboot();
        }
        if (service instanceof BaseThresholdHealthCheck) {
            this.configureDynamically((BaseThresholdHealthCheck)service);
        }
    }

    private void configureDynamically(BaseThresholdHealthCheck<?, ?> service) {
        if (this.thresholdCritical != null) {
            ((HealthCheckWithThresholdExecutionOptions)service.getOptions()).setThresholdCritical(Integer.valueOf(this.thresholdCritical));
            this.report.appendMessage(strings.getLocalString("healthcheck.service.configure.threshold.critical.success", "Critical threshold for {0} service is set with value {1}.", new Object[]{this.serviceName, this.thresholdCritical}));
            this.report.appendMessage("\n");
        }
        if (this.thresholdWarning != null) {
            ((HealthCheckWithThresholdExecutionOptions)service.getOptions()).setThresholdWarning(Integer.valueOf(this.thresholdWarning));
            this.report.appendMessage(strings.getLocalString("healthcheck.service.configure.threshold.warning.success", "Warning threshold for {0} service is set with value {1}.", new Object[]{this.serviceName, this.thresholdWarning}));
            this.report.appendMessage("\n");
        }
        if (this.thresholdGood != null) {
            ((HealthCheckWithThresholdExecutionOptions)service.getOptions()).setThresholdGood(Integer.valueOf(this.thresholdGood));
            this.report.appendMessage(strings.getLocalString("healthcheck.service.configure.threshold.good.success", "Good threshold for {0} service is set with value {1}.", new Object[]{this.serviceName, this.thresholdGood}));
            this.report.appendMessage("\n");
        }
    }

    private <C extends Checker> Checker updateProperties(Checker config, Class<C> type) throws PropertyVetoException, TransactionFailure {
        if (this.enabled != null) {
            this.updateProperty(config, "enabled", config.getEnabled(), this.enabled.toString(), Checker::setEnabled);
        }
        this.updateProperty(config, "checker-name", config.getName(), this.checkerName, Checker::setName);
        this.updateProperty(config, "add-to-microprofile-health", config.getAddToMicroProfileHealth(), this.addToMicroProfileHealth.toString(), Checker::setAddToMicroProfileHealth);
        this.updateProperty(config, "time", config.getTime(), this.time, Checker::setTime);
        this.updateProperty(config, "time-unit", config.getUnit(), this.timeUnit, Checker::setUnit);
        this.updateProperty(config, "checker-name", config.getName(), this.checkerName, Checker::setName);
        if (HoggingThreadsChecker.class.isAssignableFrom(type)) {
            HoggingThreadsChecker hoggingThreadsConfig = (HoggingThreadsChecker)config;
            this.updateProperty(hoggingThreadsConfig, "hogging-threads-threshold", hoggingThreadsConfig.getThresholdPercentage(), this.hogginThreadsThreshold, HoggingThreadsChecker::setThresholdPercentage);
            this.updateProperty(hoggingThreadsConfig, "hogging-threads-retry-count", hoggingThreadsConfig.getRetryCount(), this.hogginThreadsRetryCount, HoggingThreadsChecker::setRetryCount);
        }
        if (StuckThreadsChecker.class.isAssignableFrom(type)) {
            StuckThreadsChecker stuckThreadsConfig = (StuckThreadsChecker)config;
            this.updateProperty(stuckThreadsConfig, "stuck-threads-threshold", stuckThreadsConfig.getThreshold(), this.stuckThreadsThreshold, StuckThreadsChecker::setThreshold);
            this.updateProperty(stuckThreadsConfig, "stuck-threads-threshold-unit", stuckThreadsConfig.getThresholdTimeUnit(), this.stuckThreadsThresholdUnit, StuckThreadsChecker::setThresholdTimeUnit);
        }
        if (MicroProfileMetricsChecker.class.isAssignableFrom(type)) {
            MonitoredMetric monitoredMetric;
            MicroProfileMetricsChecker microProfileMetricsConfig = (MicroProfileMetricsChecker)config;
            microProfileMetricsConfig.setName(config.getName());
            List<MonitoredMetric> metrics = microProfileMetricsConfig.getMonitoredMetrics();
            if (this.metricsToRemove != null && !this.metricsToRemove.isEmpty()) {
                for (String metricToRemove : this.metricsToRemove) {
                    monitoredMetric = this.parseToMonitoredMetric(metricToRemove, (MonitoredMetric)microProfileMetricsConfig.createChild(MonitoredMetric.class));
                    boolean removed = false;
                    for (MonitoredMetric metric : metrics) {
                        if (!metric.equals(monitoredMetric)) continue;
                        metrics.remove(metric);
                        this.report.appendMessage("Metric 'metricName=" + monitoredMetric.getMetricName() + "' successfully deleted.\n");
                        removed = true;
                        break;
                    }
                    if (removed) continue;
                    this.report.appendMessage("Metric 'metricName=" + monitoredMetric.getMetricName() + "' doesn't exist, so was ignored.\n");
                }
            }
            if (this.metricsToAdd != null && !this.metricsToAdd.isEmpty()) {
                for (String metricToAdd : this.metricsToAdd) {
                    monitoredMetric = this.parseToMonitoredMetric(metricToAdd, (MonitoredMetric)microProfileMetricsConfig.createChild(MonitoredMetric.class));
                    boolean metricExists = false;
                    for (MonitoredMetric metric : metrics) {
                        if (!metric.equals(monitoredMetric)) continue;
                        metricExists = true;
                        this.report.appendMessage("Metric 'metricName=" + monitoredMetric.getMetricName() + "' already exists, so was ignored.\n");
                        break;
                    }
                    if (metricExists) continue;
                    metrics.add(monitoredMetric);
                    this.report.appendMessage("Metric 'metricName=" + monitoredMetric.getMetricName() + "' successfully added.\n");
                }
            }
        }
        return config;
    }

    private MonitoredMetric parseToMonitoredMetric(String input, MonitoredMetric monitoredMetric) throws PropertyVetoException {
        String[] metricTokens = input.split("(?=metricName ?=)|(?=description ?=)");
        String metricName = null;
        String description = null;
        if (metricTokens.length < 1) {
            throw new IllegalArgumentException("No metric property was available. The required metric property is 'metricName'.");
        }
        block8: for (String token : metricTokens) {
            String[] param = (token = token.replaceAll("\\\\", "")).split("=", 2);
            if (param.length != 2) {
                throw new IllegalArgumentException("Incorrectly formatted metric property. Correct format is 'metricName=MetricName'.");
            }
            switch (param[0]) {
                case "metricName": {
                    metricName = param[1].trim();
                    continue block8;
                }
                case "description": {
                    description = param[1].trim();
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Unknown metric property: " + param[0] + ". Valid metric properties are: 'metricName' and 'description'.");
                }
            }
        }
        if (metricName == null || metricName.isEmpty()) {
            throw new IllegalArgumentException("Invalid metric property: " + metricName);
        }
        monitoredMetric.setMetricName(metricName);
        if (description != null) {
            monitoredMetric.setDescription(description);
        }
        return monitoredMetric;
    }

    private void updateProperty(ThresholdDiagnosticsChecker config, String name, String value) throws TransactionFailure {
        Property prop = config.getProperty(name);
        if (prop == null) {
            ConfigSupport.apply(configProxy -> {
                Property newProp = (Property)configProxy.createChild(Property.class);
                this.updateProperty(newProp, name, value);
                configProxy.getProperty().add(newProp);
                return configProxy;
            }, (ConfigBeanProxy)config);
        } else {
            ConfigSupport.apply(propertyProxy -> {
                this.updateProperty((Property)propertyProxy, name, value);
                return propertyProxy;
            }, (ConfigBeanProxy)prop);
        }
    }

    private void updateProperty(Property prop, String name, String value) throws PropertyVetoException {
        String from = prop.getValue();
        if (value != null && !value.equals(from)) {
            this.report.appendMessage(this.serviceName + "." + name + " was " + from + " set to " + value + "\n");
            prop.setName(name);
            prop.setValue(value);
        }
    }

    private <T> void updateProperty(T config, String name, String from, String to, PropertyBiConsumer<T, String> setter) throws PropertyVetoException {
        if (to != null && !to.equals(from)) {
            this.report.appendMessage(this.serviceName + "." + name + " was " + from + " set to " + to + "\n");
            try {
                setter.accept(config, to.toString());
            }
            catch (RuntimeException ex) {
                if (ex.getCause() != null && PropertyVetoException.class.isAssignableFrom(ex.getCause().getClass())) {
                    throw (PropertyVetoException)ex.getCause();
                }
                throw ex;
            }
        }
    }

    @FunctionalInterface
    static interface PropertyBiConsumer<A, B>
    extends BiConsumer<A, B> {
        @Override
        default public void accept(A a, B b) {
            try {
                this.acceptChange(a, b);
            }
            catch (PropertyVetoException e) {
                throw new RuntimeException(e);
            }
        }

        public void acceptChange(A var1, B var2) throws PropertyVetoException;
    }
}

