/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.oauth2;

import fish.payara.security.annotations.OAuth2AuthenticationDefinition;
import fish.payara.security.oauth2.OAuth2AuthenticationMechanism;
import fish.payara.security.oauth2.OAuth2StateHolder;
import fish.payara.security.oauth2.api.OAuth2State;
import fish.payara.security.oauth2.api.OAuthIdentityStore;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.identitystore.IdentityStore;
import org.glassfish.soteria.cdi.CdiProducer;
import org.glassfish.soteria.cdi.CdiUtils;

public class OAuth2MechanismHandler
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(OAuth2MechanismHandler.class.getName());
    private final List<Bean<IdentityStore>> identityStoreBeans = new ArrayList<Bean<IdentityStore>>();
    private Bean<HttpAuthenticationMechanism> authenticationMechanismBean;

    public <T> void findOAuth2DefinitionAnnotation(@Observes ProcessBean<T> eventIn, BeanManager beanManager) {
        ProcessBean<T> event = eventIn;
        Class beanClass = event.getBean().getBeanClass();
        Optional optionalOAuthIdentityStore = CdiUtils.getAnnotation((BeanManager)beanManager, (Annotated)event.getAnnotated(), OAuth2AuthenticationDefinition.class);
        optionalOAuthIdentityStore.ifPresent(definition -> {
            this.validateDefinition((OAuth2AuthenticationDefinition)definition);
            LOGGER.log(Level.FINE, "Processing definition {0}", definition);
            this.logActivatedIdentityStore(OAuth2AuthenticationDefinition.class, beanClass);
            this.identityStoreBeans.add((Bean<IdentityStore>)new CdiProducer().scope(ApplicationScoped.class).beanClass(IdentityStore.class).types(new Type[]{Object.class, IdentityStore.class}).addToId(OAuthIdentityStore.class).create(e -> new OAuthIdentityStore()));
            this.logActivatedAuthenticationMechanism(OAuth2AuthenticationMechanism.class, beanClass);
            this.authenticationMechanismBean = new CdiProducer().scope(ApplicationScoped.class).beanClass(HttpAuthenticationMechanism.class).types(new Type[]{Object.class, HttpAuthenticationMechanism.class}).addToId(OAuth2AuthenticationMechanism.class).create(e -> {
                OAuth2AuthenticationMechanism mechanism = (OAuth2AuthenticationMechanism)CDI.current().select(OAuth2AuthenticationMechanism.class, new Annotation[0]).get();
                mechanism.setDefinition((OAuth2AuthenticationDefinition)definition);
                return mechanism;
            });
        });
    }

    private void validateDefinition(OAuth2AuthenticationDefinition definition) {
        for (String param : definition.extraParameters()) {
            if (param.split("=").length == 2) continue;
            throw new DefinitionException("Exception processing OAuth2AuthenticationDefinition: extraParameter on annotation " + definition.toString() + " is not of the format key=value");
        }
    }

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager manager) {
        LOGGER.log(Level.FINER, "OAuth2Handler - BeforeBeanDiscovery {0}", event.toString());
        event.addAnnotatedType(manager.createAnnotatedType(OAuth2AuthenticationMechanism.class), "OAuth2 Mechanism");
        event.addAnnotatedType(manager.createAnnotatedType(OAuth2StateHolder.class), "OAuth2Token");
        event.addAnnotatedType(manager.createAnnotatedType(OAuth2State.class), "OAuth2State");
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (!this.identityStoreBeans.isEmpty()) {
            this.identityStoreBeans.forEach(arg_0 -> ((AfterBeanDiscovery)afterBeanDiscovery).addBean(arg_0));
        }
        if (this.authenticationMechanismBean != null) {
            LOGGER.log(Level.FINE, "Creating OAuth2 Mechanism");
            afterBeanDiscovery.addBean(this.authenticationMechanismBean);
        }
    }

    private void logActivatedIdentityStore(Class<?> identityStoreClass, Class<?> beanClass) {
        LOGGER.log(Level.INFO, "Activating {0} identity store from {1} class", new String[]{identityStoreClass.getName(), beanClass.getName()});
    }

    private void logActivatedAuthenticationMechanism(Class<?> authenticationMechanismClass, Class<?> beanClass) {
        LOGGER.log(Level.INFO, "Activating {0} authentication mechanism from {1} class", new String[]{authenticationMechanismClass.getName(), beanClass.getName()});
    }
}

