/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.http.protocol.rs;

import fish.payara.ejb.http.protocol.InvokeMethodRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;

@Provider
@Consumes(value={"application/x-java-object"})
public class ObjectStreamInvokeMethodMessageBodyReader
implements MessageBodyReader<InvokeMethodRequest> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return InvokeMethodRequest.class.isAssignableFrom(type);
    }

    public InvokeMethodRequest readFrom(Class<InvokeMethodRequest> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            InvokeMethodRequest request = (InvokeMethodRequest)new ObjectInputStream(entityStream).readObject();
            request.argDeserializer = (args, method, types, classloader) -> {
                try (ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(classloader, (InputStream)new ByteArrayInputStream((byte[])args));){
                    Object[] objectArray = (Object[])ois.readObject();
                    return objectArray;
                }
                catch (Exception ex) {
                    throw new InternalServerErrorException("Failed to de-serialise method arguments from binary representation.", (Throwable)ex);
                }
            };
            return request;
        }
        catch (ClassNotFoundException ex) {
            throw new InternalServerErrorException("Class not found while de-serialising object stream as " + type.getSimpleName() + " : " + ex.getMessage(), (Throwable)ex);
        }
    }
}

