/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import fish.payara.monitoring.configuration.MonitoringConsoleConfiguration;
import java.beans.PropertyVetoException;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.autodeploy.AutoDeployer;
import org.glassfish.deployment.autodeploy.AutoDeploymentOperation;
import org.glassfish.deployment.autodeploy.AutoUndeploymentOperation;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-monitoring-console-configuration")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="set-monitoring-console-configuration", description="Set Monitoring Console Configuration")})
public class SetMonitoringConsoleConfigurationCommand
implements AdminCommand {
    private static final Logger LOGGER = Logger.getLogger(SetMonitoringConsoleConfigurationCommand.class.getName());
    private static final String MONITORING_CONSOLE_APP_NAME = "__monitoringconsole";
    private static final String GLASSFISH_LIB_INSTALL_APPLICATIONS = "glassfish/lib/install/applications";
    @Param(optional=true)
    private Boolean enabled;
    @Param(optional=true, alias="disable-watch")
    private String _disableWatch;
    @Param(optional=true, alias="enable-watch")
    private String _enableWatch;
    @Param(optional=true, alias="add-watch-name")
    private String _addWatchName;
    @Param(optional=true, alias="add-watch-json")
    private String _addWatchJson;
    @Param(optional=true, alias="remove-watch")
    private String _removeWatch;
    @Param(optional=true, alias="add-page-name")
    private String _addPageName;
    @Param(optional=true, alias="add-page-json")
    private String _addPageJson;
    @Param(optional=true, alias="remove-page")
    private String _removePage;
    @Inject
    protected CommandRunner commandRunner;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private Domain domain;

    public void execute(AdminCommandContext context) {
        MonitoringConsoleConfiguration config = (MonitoringConsoleConfiguration)this.domain.getExtensionByType(MonitoringConsoleConfiguration.class);
        if (config == null) {
            context.getActionReport().failure(LOGGER, "Monitoring Console configuration does not exist.");
            return;
        }
        if (this.enabled != null && Boolean.parseBoolean(config.getEnabled()) != this.enabled) {
            if (this.enabled.booleanValue()) {
                this.deployMonitoringConsole(context.getActionReport());
            } else {
                this.undeployMonitoringConsole(context.getActionReport());
            }
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MonitoringConsoleConfiguration>(){

                public Object run(MonitoringConsoleConfiguration configProxy) throws PropertyVetoException, TransactionFailure {
                    List<String> disabledWatchNames;
                    if (SetMonitoringConsoleConfigurationCommand.this.enabled != null) {
                        configProxy.setEnabled(SetMonitoringConsoleConfigurationCommand.this.enabled.toString());
                    }
                    if (SetMonitoringConsoleConfigurationCommand.isDefined(SetMonitoringConsoleConfigurationCommand.this._disableWatch) && !(disabledWatchNames = configProxy.getDisabledWatchNames()).contains(SetMonitoringConsoleConfigurationCommand.this._disableWatch)) {
                        disabledWatchNames.add(SetMonitoringConsoleConfigurationCommand.this._disableWatch);
                    }
                    if (SetMonitoringConsoleConfigurationCommand.isDefined(SetMonitoringConsoleConfigurationCommand.this._enableWatch)) {
                        configProxy.getDisabledWatchNames().remove(SetMonitoringConsoleConfigurationCommand.this._enableWatch);
                    }
                    if (SetMonitoringConsoleConfigurationCommand.isDefined(SetMonitoringConsoleConfigurationCommand.this._addWatchName) && SetMonitoringConsoleConfigurationCommand.isDefined(SetMonitoringConsoleConfigurationCommand.this._addWatchJson)) {
                        SetMonitoringConsoleConfigurationCommand.add(SetMonitoringConsoleConfigurationCommand.this._addWatchName, SetMonitoringConsoleConfigurationCommand.this._addWatchJson, configProxy.getCustomWatchNames(), configProxy.getCustomWatchValues());
                    }
                    if (SetMonitoringConsoleConfigurationCommand.isDefined(SetMonitoringConsoleConfigurationCommand.this._removeWatch)) {
                        SetMonitoringConsoleConfigurationCommand.remove(SetMonitoringConsoleConfigurationCommand.this._removeWatch, configProxy.getCustomWatchNames(), configProxy.getCustomWatchValues());
                        configProxy.getDisabledWatchNames().remove(SetMonitoringConsoleConfigurationCommand.this._removeWatch);
                    }
                    if (SetMonitoringConsoleConfigurationCommand.isDefined(SetMonitoringConsoleConfigurationCommand.this._addPageName) && SetMonitoringConsoleConfigurationCommand.isDefined(SetMonitoringConsoleConfigurationCommand.this._addPageJson)) {
                        SetMonitoringConsoleConfigurationCommand.add(SetMonitoringConsoleConfigurationCommand.this._addPageName, SetMonitoringConsoleConfigurationCommand.this._addPageJson, configProxy.getPageNames(), configProxy.getPageValues());
                    }
                    if (SetMonitoringConsoleConfigurationCommand.isDefined(SetMonitoringConsoleConfigurationCommand.this._removePage)) {
                        SetMonitoringConsoleConfigurationCommand.remove(SetMonitoringConsoleConfigurationCommand.this._removePage, configProxy.getPageNames(), configProxy.getPageValues());
                    }
                    return null;
                }
            }, (ConfigBeanProxy)config);
        }
        catch (TransactionFailure ex) {
            context.getActionReport().failure(LOGGER, "Failed to update Monitoring Console configuration", (Throwable)ex);
        }
    }

    static void add(String name, String value, List<String> names, List<String> values) {
        int index = names.indexOf(name);
        if (index >= 0) {
            names.remove(index);
            if (index < values.size()) {
                values.remove(index);
            }
        }
        names.add(name);
        values.add(value);
    }

    static void remove(String name, List<String> names, List<String> values) {
        int index = names.indexOf(name);
        if (index >= 0) {
            names.remove(index);
            if (index < values.size()) {
                values.remove(index);
            }
        }
    }

    static boolean isDefined(String value) {
        return value != null && !value.isEmpty();
    }

    private void undeployMonitoringConsole(ActionReport report) {
        Path applications = SetMonitoringConsoleConfigurationCommand.getApplicationsPath();
        Path app = applications.resolve(MONITORING_CONSOLE_APP_NAME);
        AutoUndeploymentOperation command = AutoUndeploymentOperation.newInstance((ServiceLocator)this.serviceLocator, (File)app.toFile(), (String)MONITORING_CONSOLE_APP_NAME, (String)"server");
        AutoDeployer.AutodeploymentStatus deploymentStatus = command.run();
        report.setActionExitCode(deploymentStatus.getExitCode());
        if (deploymentStatus.getExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
            if (this.domain.getApplications().getApplication(MONITORING_CONSOLE_APP_NAME) == null) {
                report.appendMessage("\nMonitoring Console is not enabled on any target");
            } else {
                report.appendMessage("\nFailed to disable Monitoring Console - was it enabled on the specified target?");
            }
        }
    }

    private void deployMonitoringConsole(ActionReport report) {
        Path applications = SetMonitoringConsoleConfigurationCommand.getApplicationsPath();
        Path app = applications.resolve(MONITORING_CONSOLE_APP_NAME);
        AutoDeploymentOperation command = AutoDeploymentOperation.newInstance((ServiceLocator)this.serviceLocator, (File)app.toFile(), null, (String)"server", (String)"monitoring-console");
        if (this.domain.getApplications().getApplication(MONITORING_CONSOLE_APP_NAME) == null) {
            AutoDeployer.AutodeploymentStatus deploymentStatus = command.run();
            report.setActionExitCode(deploymentStatus.getExitCode());
        } else {
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
            report.setMessage("Monitoring Console is already deployed on at least one target");
        }
    }

    private static Path getApplicationsPath() {
        return Paths.get(System.getProperty("com.sun.aas.productRoot"), new String[0]).resolve(GLASSFISH_LIB_INSTALL_APPLICATIONS);
    }
}

