/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.runtime;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.topic.ITopic;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import fish.payara.monitoring.adapt.GroupData;
import fish.payara.monitoring.adapt.GroupDataRepository;
import fish.payara.monitoring.adapt.MonitoringConsole;
import fish.payara.monitoring.adapt.MonitoringConsoleFactory;
import fish.payara.monitoring.adapt.MonitoringConsolePageConfig;
import fish.payara.monitoring.adapt.MonitoringConsoleRuntime;
import fish.payara.monitoring.adapt.MonitoringConsoleWatchConfig;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.monitoring.collect.MonitoringWatchSource;
import fish.payara.monitoring.configuration.MonitoringConsoleConfiguration;
import fish.payara.notification.requesttracing.RequestTrace;
import fish.payara.notification.requesttracing.RequestTraceSpan;
import fish.payara.nucleus.executorservice.PayaraExecutorService;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import io.opentracing.tag.Tag;
import java.beans.PropertyChangeEvent;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.InternalSystemAdministrator;
import org.glassfish.internal.deployment.ApplicationLifecycleInterceptor;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
public class MonitoringConsoleRuntimeImpl
implements ConfigListener,
ApplicationLifecycleInterceptor,
EventListener,
MonitoringConsoleRuntime,
MonitoringConsoleWatchConfig,
MonitoringConsolePageConfig,
GroupDataRepository {
    private static final Logger LOGGER = Logger.getLogger("monitoring-console-core");
    private static final String SET_MONITORING_CONSOLE_CONFIGURATION_COMMAND = "set-monitoring-console-configuration";
    private static final String MONITORING_DATA_TOPIC_NAME = "payara-monitoring-data";
    @Inject
    private PayaraExecutorService executor;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    @Named(value="default-instance-name")
    private Config serverConfig;
    @Inject
    private Domain domain;
    @Inject
    private CommandRunner commandRunner;
    @Inject
    private InternalSystemAdministrator kernelIdentity;
    @Inject
    private HazelcastCore hazelcastCore;
    @Inject
    private RequestTracingService requestTracingService;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private Events events;
    private final AtomicBoolean initialised = new AtomicBoolean();
    private ITopic<byte[]> exchange;
    private MonitoringConsoleConfiguration config;
    private MonitoringConsole console;

    @PostConstruct
    public void postConstruct() {
        this.events.register((EventListener)this);
    }

    public void event(EventListener.Event<?> event) {
        if (event.is(EventTypes.SERVER_READY)) {
            this.init();
        }
    }

    public void init() {
        if (!this.initialised.compareAndSet(false, true)) {
            return;
        }
        try {
            LOGGER.info("Bootstrapping Monitoring Console Runtime");
            boolean isDas = this.serverEnv.isDas();
            this.config = (MonitoringConsoleConfiguration)this.domain.getExtensionByType(MonitoringConsoleConfiguration.class);
            if (this.hazelcastCore.isEnabled()) {
                HazelcastInstance hz = this.hazelcastCore.getInstance();
                this.exchange = hz.getTopic(MONITORING_DATA_TOPIC_NAME);
            }
            Supplier<List> dataSources = () -> this.serviceLocator.getAllServices(MonitoringDataSource.class, new Annotation[0]);
            Supplier<List> watchSources = () -> this.serviceLocator.getAllServices(MonitoringWatchSource.class, new Annotation[0]);
            this.console = MonitoringConsoleFactory.getInstance().create(this.serverEnv.getInstanceName(), isDas, this, dataSources, watchSources);
            this.setEnabled(Boolean.parseBoolean(this.serverConfig.getMonitoringService().getMonitoringEnabled()));
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to init monitoring console runtime", ex);
        }
    }

    public final UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        for (PropertyChangeEvent e : events) {
            String property;
            Class source;
            if (!(e.getSource() instanceof ConfigBeanProxy) || (source = Dom.unwrap((ConfigBeanProxy)((ConfigBeanProxy)e.getSource())).getImplementationClass()) != MonitoringService.class || !"monitoring-enabled".equals(property = e.getPropertyName())) continue;
            this.setEnabled(Boolean.parseBoolean(e.getNewValue().toString()));
        }
        return null;
    }

    private void setEnabled(boolean enabled) {
        if (this.console != null) {
            this.console.setEnabled(enabled);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return this.executor.scheduleAtFixedRate(task, initialDelay, period, unit);
    }

    @Override
    public boolean send(byte[] snapshot) {
        if (this.exchange == null) {
            return false;
        }
        this.exchange.publish((Object)snapshot);
        return true;
    }

    @Override
    public boolean receive(Consumer<byte[]> receiver) {
        if (this.exchange == null) {
            return false;
        }
        this.exchange.addMessageListener(msg -> receiver.accept((byte[])msg.getMessageObject()));
        return true;
    }

    @Override
    public MonitoringConsoleWatchConfig getWatchConfig() {
        return this;
    }

    @Override
    public boolean isDisabled(String name) {
        return this.config.getDisabledWatchNames().contains(name);
    }

    @Override
    public void disable(String name) {
        this.runCommand(SET_MONITORING_CONSOLE_CONFIGURATION_COMMAND, "disable-watch", name);
    }

    @Override
    public void enable(String name) {
        this.runCommand(SET_MONITORING_CONSOLE_CONFIGURATION_COMMAND, "enable-watch", name);
    }

    @Override
    public void add(String name, String watchJson) {
        this.runCommand(SET_MONITORING_CONSOLE_CONFIGURATION_COMMAND, "add-watch-name", name, "add-watch-json", watchJson);
    }

    @Override
    public void remove(String name) {
        this.runCommand(SET_MONITORING_CONSOLE_CONFIGURATION_COMMAND, "remove-watch", name);
    }

    @Override
    public Iterable<String> list() {
        return Collections.unmodifiableList(this.config.getCustomWatchValues());
    }

    @Override
    public MonitoringConsolePageConfig getPageConfig() {
        return this;
    }

    @Override
    public String getPage(String name) {
        List<String> values = this.config.getPageValues();
        List<String> names = this.config.getPageNames();
        int index = names.indexOf(name);
        if (index < 0) {
            throw new NoSuchElementException("Page does not exist: " + name);
        }
        String page = values.get(index);
        MonitoringConsoleRuntimeImpl.checkPageId(name, page);
        return page;
    }

    @Override
    public void putPage(String name, String pageJson) {
        if (pageJson == null || pageJson.isEmpty() || "{}".equals(pageJson)) {
            this.runCommand(SET_MONITORING_CONSOLE_CONFIGURATION_COMMAND, "remove-page", name);
        } else {
            MonitoringConsoleRuntimeImpl.checkPageId(name, pageJson);
            this.runCommand(SET_MONITORING_CONSOLE_CONFIGURATION_COMMAND, "add-page-name", name, "add-page-json", pageJson);
        }
    }

    private static void checkPageId(String name, String pageJson) {
        if (pageJson.indexOf("\"id\":\"" + name + "\"") < 0) {
            throw new IllegalArgumentException("Page JSON id did not match given name.");
        }
    }

    @Override
    public Iterable<String> listPages() {
        return Collections.unmodifiableList(this.config.getPageNames());
    }

    private void runCommand(String name, String ... params) {
        try {
            ActionReport report = this.commandRunner.getActionReport("plain");
            CommandRunner.CommandInvocation cmd = this.commandRunner.getCommandInvocation(name, report, this.kernelIdentity.getSubject());
            ParameterMap paramsMap = new ParameterMap();
            for (int i = 0; i < params.length; i += 2) {
                paramsMap.add((Object)params[i], (Object)params[i + 1]);
            }
            cmd.parameters(paramsMap).execute();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to run command: " + name, ex);
        }
    }

    @Override
    public GroupDataRepository getGroupData() {
        return this;
    }

    @Override
    public Collection<GroupData> selectAll(String source, String group) {
        if (!"requesttracing".equals(source)) {
            return Collections.emptyList();
        }
        ArrayList<GroupData> matches = new ArrayList<GroupData>();
        for (RequestTrace trace : this.requestTracingService.getRequestTraceStore().getTraces()) {
            if (!RequestTracingService.metricGroupName((RequestTrace)trace).equals(group)) continue;
            GroupData data = new GroupData();
            data.addField("id", trace.getTraceId()).addField("startTime", trace.getStartTime().toEpochMilli()).addField("endTime", trace.getEndTime().toEpochMilli()).addField("elapsedTime", trace.getElapsedTime());
            for (RequestTraceSpan span : trace.getTraceSpans()) {
                GroupData tags = data.addChild(span.getId().toString()).addField("id", span.getId()).addField("operation", RequestTracingService.stripPackageName((String)span.getEventName())).addField("startTime", span.getTimeOccured()).addField("endTime", span.getTraceEndTime().toEpochMilli()).addField("duration", span.getSpanDuration()).addChild("tags");
                for (Map.Entry tag : span.getSpanTags().entrySet()) {
                    if (tag.getKey() instanceof Tag) {
                        tags.addField(((Tag)tag.getKey()).getKey(), (String)tag.getValue());
                        continue;
                    }
                    tags.addField(tag.getKey().toString(), (String)tag.getValue());
                }
            }
            matches.add(data);
        }
        return matches;
    }

    public void before(ExtendedDeploymentContext.Phase phase, ExtendedDeploymentContext context) {
    }

    public void after(ExtendedDeploymentContext.Phase phase, ExtendedDeploymentContext context) {
    }
}

