/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.SecurityConfigListener;
import com.sun.enterprise.security.cli.CLIUtil;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="create-auth-realm")
@PerLookup
@I18n(value="create.auth.realm")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateAuthRealm
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateAuthRealm.class);
    @Param(name="classname")
    private String className;
    @Param(name="authrealmname", primary=true)
    private String authRealmName;
    @Param(optional=true, name="property", separator=58)
    private Properties properties;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Param(name="login-module", optional=true)
    private String loginModule;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    @Inject
    private Domain domain;
    @Inject
    private Util util;
    @AccessRequired.NewChild(type=AuthRealm.class)
    private SecurityService securityService;

    public boolean preAuthorization(AdminCommandContext context) {
        this.config = CLIUtil.chooseConfig(this.domain, this.target, context.getActionReport());
        if (this.config == null) {
            return false;
        }
        this.securityService = this.config.getSecurityService();
        return this.ensureRealmIsNew(context.getActionReport());
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<SecurityService>(){

                public Object run(SecurityService param) throws PropertyVetoException, TransactionFailure {
                    AuthRealm newAuthRealm = (AuthRealm)param.createChild(AuthRealm.class);
                    CreateAuthRealm.this.populateAuthRealmElement(newAuthRealm);
                    param.getAuthRealm().add(newAuthRealm);
                    SecurityConfigListener.authRealmCreated(CreateAuthRealm.this.config, newAuthRealm);
                    return newAuthRealm;
                }
            }, (ConfigBeanProxy)this.securityService);
            if (this.loginModule != null) {
                this.appendLoginModule(report);
                if (report.hasFailures()) {
                    report.setActionExitCode(ActionReport.ExitCode.WARNING);
                    return;
                }
            }
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("create.auth.realm.fail", "Creation of Authrealm {0} failed", new Object[]{this.authRealmName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void appendLoginModule(ActionReport mainReport) {
        ActionReport report = mainReport.addSubActionsReport();
        report.setActionDescription("Updating login config");
        String loginConfLocation = System.getProperty("java.security.auth.login.config");
        if (loginConfLocation == null) {
            report.appendMessage(localStrings.getLocalString("create.auth.realm.loginconf.undefined", "JDK default login config is set. Cannot update"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String jaasContext = this.properties.getProperty("jaas-context");
        if (jaasContext == null || jaasContext.isEmpty()) {
            report.appendMessage(localStrings.getLocalString("create.auth.realm.loginconf.nojaasctx", "No JAAS context is defined for login module"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            new LoginContext(jaasContext);
            report.appendMessage(localStrings.getLocalString("create.auth.realm.loginconf.jaasctx.already.defined", "JAAS context {0} is already configured", new Object[]{jaasContext}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        catch (LoginException loginException) {
            try (FileWriter fw = new FileWriter(loginConfLocation, true);){
                fw.append("\n").append(jaasContext).append(" {\n").append("\t").append(this.loginModule).append(" required;\n").append("};");
            }
            catch (IOException e) {
                report.appendMessage(localStrings.getLocalString("create.auth.realm.loginconf.write_failed", "Failed to update login conf at {0}: {1}", new Object[]{loginConfLocation, e.getLocalizedMessage()}));
                report.setFailureCause((Throwable)e);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            Configuration.getConfiguration().refresh();
            return;
        }
    }

    private void populateAuthRealmElement(AuthRealm newAuthRealm) throws PropertyVetoException, TransactionFailure {
        newAuthRealm.setName(this.authRealmName);
        newAuthRealm.setClassname(this.className);
        if (this.properties != null) {
            for (Object propertyName : this.properties.keySet()) {
                Property newProperty = (Property)newAuthRealm.createChild(Property.class);
                newProperty.setName((String)propertyName);
                newProperty.setValue(this.properties.getProperty((String)propertyName));
                newAuthRealm.getProperty().add(newProperty);
            }
        }
    }

    private boolean ensureRealmIsNew(ActionReport report) {
        if (!CLIUtil.isRealmNew(this.securityService, this.authRealmName)) {
            report.setMessage(localStrings.getLocalString("create.auth.realm.duplicatefound", "Authrealm named {0} exists. Cannot add duplicate AuthRealm.", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }
}

