/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.lists;

import com.sun.messaging.jmq.util.lists.EventBroadcastHelper;
import com.sun.messaging.jmq.util.lists.EventBroadcaster;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.util.lists.FilterMap;
import com.sun.messaging.jmq.util.lists.Limitable;
import com.sun.messaging.jmq.util.lists.OutOfLimitsException;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.lists.Sized;
import com.sun.messaging.jmq.util.lists.WeakValueHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SimpleNFLHashMap
extends HashMap
implements EventBroadcaster,
Limitable {
    EventBroadcastHelper ebh = new EventBroadcastHelper();
    private boolean enforceLimits = true;
    private int highWaterCnt = 0;
    private long highWaterBytes = 0L;
    private long largestMessageHighWater = 0L;
    private float averageCount = 0.0f;
    private double averageBytes = 0.0;
    private double messageAverage = 0.0;
    private long numberSamples = 0L;
    protected int maxCapacity = -1;
    protected long maxByteCapacity = -1L;
    protected long bytes = 0L;
    protected long maxBytePerObject = -1L;
    Object limitLock = new Object();
    private NLMapEntry oldEntry = new NLMapEntry();
    private NLMapEntry newEntry = new NLMapEntry();
    Map comparatorSets = null;
    Map filterMaps = null;

    public void reset() {
        this.highWaterCnt = 0;
        this.highWaterBytes = 0L;
        this.largestMessageHighWater = 0L;
        this.averageCount = 0.0f;
        this.averageBytes = 0.0;
        this.messageAverage = 0.0;
        this.numberSamples = 0L;
    }

    public Set removeAll(Collection c) {
        return this.removeAll(c, null);
    }

    public Set removeAll(Collection c, Reason r) {
        Iterator itr = c.iterator();
        HashSet<Object> s = new HashSet<Object>();
        while (itr.hasNext()) {
            Object mine = itr.next();
            Object o = this.remove(mine, r);
            if (o == null) continue;
            s.add(o);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        HashSet m = null;
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            m = new HashSet(this.keySet());
        }
        this.removeAll(m, null);
    }

    public Map subMap(Filter f) {
        throw new RuntimeException("Implementation not complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set subSet(Comparator f) {
        TreeSet s = new TreeSet(f);
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            s.addAll(this.values());
            if (this.comparatorSets == null) {
                this.comparatorSets = Collections.synchronizedMap(new WeakValueHashMap("Comparator"));
            }
            this.comparatorSets.put(f, s);
        }
        return s;
    }

    @Override
    public void putAll(Map m) {
        this.putAll(m, null);
    }

    public void putAll(Map m, Reason r) {
        for (Map.Entry me : m.entrySet()) {
            this.put(me.getKey(), me.getValue(), r);
        }
    }

    @Override
    public Object put(Object key, Object value) {
        return this.put(key, value, null);
    }

    @Override
    public Object remove(Object key) {
        return this.remove(key, null);
    }

    public Object put(Object key, Object value, Reason reason) {
        return this.put(key, value, reason, true);
    }

    public Object put(Object key, Object value, Reason reason, boolean overwrite) {
        return this.put(key, value, reason, overwrite, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value, Reason reason, boolean overwrite, boolean checklimit) {
        Object s;
        Iterator itr;
        boolean myenforceLimits;
        boolean bl = myenforceLimits = this.enforceLimits && checklimit;
        if (this.hasListeners(EventType.SET_CHANGED_REQUEST)) {
            this.notifyChange(EventType.SET_CHANGED_REQUEST, null, value, reason);
        }
        if (key == null && value == null) {
            throw new NullPointerException("Unable to support null keys or values");
        }
        if (this.maxByteCapacity != -1L && !(value instanceof Sized)) {
            throw new ClassCastException("Unable to add object not of type Sized when byteCapacity has been set");
        }
        if (this.maxBytePerObject != -1L && !(value instanceof Sized)) {
            throw new ClassCastException("Unable to add object not of type Sized when maxByteSize has been set");
        }
        long objsize = 0L;
        if (value instanceof Sized) {
            objsize = ((Sized)value).byteSize();
        }
        long oldBytes = 0L;
        long newBytes = 0L;
        int oldSize = 0;
        int newSize = 0;
        boolean wasEmpty = false;
        boolean isEmpty = false;
        boolean wasFull = false;
        boolean isFull = false;
        Object ret = null;
        Object object = this;
        synchronized (object) {
            oldBytes = this.bytes;
            oldSize = this.size();
            newSize = oldSize + 1;
            wasEmpty = oldSize == 0;
            isEmpty = newSize == 0;
            newBytes = this.bytes + objsize;
            wasFull = this.isFull();
            boolean bl2 = isFull = this.maxCapacity > 0 && newSize >= this.maxCapacity || this.maxByteCapacity > 0L && newBytes >= this.maxByteCapacity;
            if (myenforceLimits && this.maxBytePerObject != -1L && objsize > this.maxBytePerObject) {
                throw new OutOfLimitsException(2, objsize, this.maxBytePerObject);
            }
            if (myenforceLimits && this.maxCapacity != -1 && this.maxCapacity - newSize < 0) {
                throw new OutOfLimitsException(0, newSize, this.maxCapacity);
            }
            if (myenforceLimits && this.maxByteCapacity != -1L && this.maxByteCapacity - newBytes < 0L) {
                throw new OutOfLimitsException(1, newBytes, this.maxByteCapacity);
            }
            this.bytes = newBytes;
            if (!overwrite && super.get(key) != null) {
                throw new IllegalStateException("Message exist in the store");
            }
            ret = super.put(key, value);
            if (ret != null && ret instanceof Sized) {
                this.bytes -= ((Sized)ret).byteSize();
            }
        }
        object = this.limitLock;
        synchronized (object) {
            if (newSize > this.highWaterCnt) {
                this.highWaterCnt = newSize;
            }
            if (objsize > this.largestMessageHighWater) {
                this.largestMessageHighWater = objsize;
            }
            if (this.bytes > this.highWaterBytes) {
                this.highWaterBytes = this.bytes;
            }
            this.averageCount = ((float)this.numberSamples * this.averageCount + (float)newSize) / ((float)this.numberSamples + 1.0f);
            this.averageBytes = ((double)this.numberSamples * this.averageBytes + (double)newBytes) / ((double)this.numberSamples + 1.0);
            this.messageAverage = ((double)this.numberSamples * this.messageAverage + (double)objsize) / ((double)this.numberSamples + 1.0);
            ++this.numberSamples;
        }
        if (this.comparatorSets != null && !this.comparatorSets.isEmpty()) {
            object = this.comparatorSets;
            synchronized (object) {
                itr = this.comparatorSets.values().iterator();
                while (itr.hasNext()) {
                    s = (Set)itr.next();
                    if (s != null) {
                        Set set = s;
                        synchronized (set) {
                            s.add(value);
                            continue;
                        }
                    }
                    itr.remove();
                }
            }
        }
        if (this.filterMaps != null && !this.filterMaps.isEmpty()) {
            object = this.filterMaps;
            synchronized (object) {
                itr = this.filterMaps.values().iterator();
                while (itr.hasNext()) {
                    s = (FilterMap)itr.next();
                    if (s != null && (((FilterMap)s).getFilter() == null || ((FilterMap)s).getFilter().matches(value))) {
                        ((HashMap)s).put(key, value);
                        continue;
                    }
                    if (s != null) continue;
                    itr.remove();
                }
            }
        }
        if (this.hasListeners(EventType.SIZE_CHANGED) && oldSize != newSize) {
            this.notifyChange(EventType.SIZE_CHANGED, oldSize, newSize, reason);
        }
        if (this.hasListeners(EventType.BYTES_CHANGED) && oldBytes != newBytes) {
            this.notifyChange(EventType.BYTES_CHANGED, oldBytes, newBytes, reason);
        }
        if (this.hasListeners(EventType.SET_CHANGED)) {
            NLMapEntry oldv = null;
            this.newEntry.update(key, value);
            if (ret != null) {
                this.oldEntry.update(key, ret);
                oldv = this.oldEntry;
            }
            this.notifyChange(EventType.SET_CHANGED, oldv, this.newEntry, reason);
        }
        if (this.hasListeners(EventType.EMPTY) && wasEmpty != isEmpty) {
            this.notifyChange(EventType.EMPTY, wasEmpty, isEmpty, reason);
        }
        if (this.hasListeners(EventType.FULL) && wasFull != isFull) {
            this.notifyChange(EventType.FULL, wasFull, isFull, reason);
        }
        return ret;
    }

    public void enforceLimits(boolean b) {
        this.enforceLimits = b;
    }

    public boolean getEnforceLimits() {
        return this.enforceLimits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            return super.get(key);
        }
    }

    public Object remove(Object key, Reason reason) {
        return this.removeWithValue(key, null, null, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeWithValue(Object key, Object expectedValue, Object errValue, Reason reason) {
        Set s;
        Iterator itr;
        Object value = null;
        long oldBytes = 0L;
        long newBytes = 0L;
        int oldSize = 0;
        int newSize = 0;
        boolean wasEmpty = false;
        boolean isEmpty = false;
        boolean wasFull = false;
        boolean isFull = false;
        long objsize = 0L;
        Object object = this;
        synchronized (object) {
            if (expectedValue != null && (value = super.get(key)) != null && value != expectedValue) {
                return errValue;
            }
            value = super.remove(key);
            if (value == null) {
                return null;
            }
            if (value instanceof Sized) {
                objsize = ((Sized)value).byteSize();
            }
            oldBytes = this.bytes;
            oldSize = this.size() + 1;
            newSize = oldSize - 1;
            wasEmpty = oldSize == 0;
            isEmpty = newSize == 0;
            newBytes = this.bytes - objsize;
            wasFull = this.maxCapacity > 0 && oldSize >= this.maxCapacity || this.maxByteCapacity > 0L && oldBytes >= this.maxByteCapacity;
            isFull = this.maxCapacity > 0 && newSize >= this.maxCapacity || this.maxByteCapacity > 0L && newBytes >= this.maxByteCapacity;
            this.bytes = newBytes;
        }
        if (this.hasListeners(EventType.SET_CHANGED_REQUEST)) {
            this.notifyChange(EventType.SET_CHANGED_REQUEST, value, null, reason);
        }
        object = this.limitLock;
        synchronized (object) {
            this.averageCount = ((float)this.numberSamples * this.averageCount + (float)newSize) / ((float)this.numberSamples + 1.0f);
            this.averageBytes = ((double)this.numberSamples * this.averageBytes + (double)newBytes) / ((double)this.numberSamples + 1.0);
            this.messageAverage = ((double)this.numberSamples * this.messageAverage + (double)objsize) / ((double)this.numberSamples + 1.0);
            ++this.numberSamples;
        }
        if (this.comparatorSets != null && !this.comparatorSets.isEmpty()) {
            object = this.comparatorSets;
            synchronized (object) {
                itr = this.comparatorSets.values().iterator();
                while (itr.hasNext()) {
                    s = (Set)itr.next();
                    if (s != null) {
                        Set set = s;
                        synchronized (set) {
                            s.remove(value);
                            continue;
                        }
                    }
                    itr.remove();
                }
            }
        }
        if (this.filterMaps != null && !this.filterMaps.isEmpty()) {
            object = this.filterMaps;
            synchronized (object) {
                itr = this.filterMaps.values().iterator();
                while (itr.hasNext()) {
                    s = (Set)itr.next();
                    if (s != null) {
                        s.remove(key);
                        continue;
                    }
                    itr.remove();
                }
            }
        }
        if (this.hasListeners(EventType.SIZE_CHANGED) && oldSize != newSize) {
            this.notifyChange(EventType.SIZE_CHANGED, oldSize, newSize, reason);
        }
        if (this.hasListeners(EventType.BYTES_CHANGED) && oldBytes != newBytes) {
            this.notifyChange(EventType.BYTES_CHANGED, oldBytes, newBytes, reason);
        }
        if (this.hasListeners(EventType.SET_CHANGED)) {
            NLMapEntry oldv = this.oldEntry;
            this.oldEntry.update(key, value);
            Object newv = null;
            this.notifyChange(EventType.SET_CHANGED, oldv, newv, reason);
        }
        if (this.hasListeners(EventType.EMPTY) && wasEmpty != isEmpty) {
            this.notifyChange(EventType.EMPTY, wasEmpty, isEmpty, reason);
        }
        if (this.hasListeners(EventType.FULL) && wasFull != isFull) {
            this.notifyChange(EventType.FULL, wasFull, isFull, reason);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAll(Filter f) {
        HashMap m = new HashMap();
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            Set entrySet = this.entrySet();
            for (Map.Entry e : entrySet) {
                Object o = e.getValue();
                if (f != null && !f.matches(o)) continue;
                m.put(e.getKey(), o);
            }
            return m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllKeys() {
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            return new ArrayList(this.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFirstKeys(int count) {
        ArrayList l = new ArrayList(count);
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            Set entrySet = this.entrySet();
            Iterator itr = entrySet.iterator();
            for (int cnt = 0; cnt < count && itr.hasNext(); ++cnt) {
                Map.Entry e = itr.next();
                l.add(e.getKey());
            }
        }
        return l;
    }

    @Override
    public Object addEventListener(EventListener listener, EventType type, Object user_data) {
        return this.ebh.addEventListener(listener, type, user_data);
    }

    @Override
    public Object addEventListener(EventListener listener, EventType type, Reason reason, Object userData) {
        return this.ebh.addEventListener(listener, type, reason, userData);
    }

    @Override
    public Object removeEventListener(Object id) {
        return this.ebh.removeEventListener(id);
    }

    protected boolean hasListeners(EventType e) {
        return this.ebh.hasListeners(e);
    }

    protected void notifyChange(EventType e, Object oldval, Object newval, Reason r) {
        this.ebh.notifyChange(e, r, this, oldval, newval);
    }

    @Override
    public void setMaxByteSize(long bytes) {
        if (bytes < -1L) {
            bytes = -1L;
        }
        this.maxBytePerObject = bytes;
    }

    @Override
    public long maxByteSize() {
        return this.maxBytePerObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCapacity(int cnt) {
        if (cnt < -1) {
            cnt = -1;
        }
        if (!this.hasListeners(EventType.FULL)) {
            this.maxCapacity = cnt;
            return;
        }
        boolean wasFull = false;
        boolean isFull = false;
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            wasFull = this.isFull();
            this.maxCapacity = cnt;
            isFull = this.isFull();
        }
        if (wasFull != isFull) {
            this.notifyChange(EventType.FULL, wasFull, isFull, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setByteCapacity(long size) {
        if (size < -1L) {
            size = -1L;
        }
        if (!this.hasListeners(EventType.FULL)) {
            this.maxByteCapacity = size;
            return;
        }
        boolean wasFull = false;
        boolean isFull = false;
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            wasFull = this.isFull();
            this.maxByteCapacity = size;
            isFull = this.isFull();
        }
        if (wasFull != isFull) {
            this.notifyChange(EventType.FULL, wasFull, isFull, null);
        }
    }

    @Override
    public int capacity() {
        return this.maxCapacity;
    }

    @Override
    public long byteCapacity() {
        return this.maxByteCapacity;
    }

    @Override
    public boolean isFull() {
        return this.maxCapacity > 0 && this.size() >= this.maxCapacity || this.maxByteCapacity > 0L && this.bytes >= this.maxByteCapacity;
    }

    @Override
    public int freeSpace() {
        if (this.maxCapacity == -1) {
            return -1;
        }
        int val = this.maxCapacity - this.size();
        if (val < 0) {
            return 0;
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long freeBytes() {
        if (this.maxByteCapacity == -1L) {
            return -1L;
        }
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            long val = this.maxByteCapacity - this.bytes;
            if (val < 0L) {
                return 0L;
            }
            return val;
        }
    }

    @Override
    public long byteSize() {
        return this.bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            return super.size();
        }
    }

    @Override
    public int highWaterCount() {
        return this.highWaterCnt;
    }

    @Override
    public long highWaterBytes() {
        return this.highWaterBytes;
    }

    @Override
    public long highWaterLargestMessageBytes() {
        return this.largestMessageHighWater;
    }

    @Override
    public float averageCount() {
        return this.averageCount;
    }

    @Override
    public double averageBytes() {
        return this.averageBytes;
    }

    @Override
    public double averageMessageBytes() {
        return this.messageAverage;
    }

    static class NLMapEntry
    implements Map.Entry {
        Object key = null;
        Object value = null;

        public void update(Object k, Object v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry me = (Map.Entry)o;
                return (me.getKey() == this.key || this.key != null && this.key.equals(me.getKey())) && (me.getValue() == this.value || this.value != null && this.value.equals(me.getValue()));
            }
            return false;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }

        public Object setValue(Object o) {
            throw new UnsupportedOperationException("Can not set values on the entry");
        }
    }
}

