/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.sql.impl.client.SqlClientService;
import java.security.Permission;

public class NoSuchMessageTask
extends AbstractMessageTask<ClientMessage> {
    public NoSuchMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected ClientMessage decodeClientMessage(ClientMessage clientMessage) {
        return clientMessage;
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return null;
    }

    @Override
    protected void processMessage() {
        String message = this.createMessage();
        this.logger.finest(message);
        throw new UnsupportedOperationException(message);
    }

    @Override
    protected boolean requiresAuthentication() {
        return false;
    }

    @Override
    public String getServiceName() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    private String createMessage() {
        int messageType = ((ClientMessage)this.parameters).getMessageType();
        if (SqlClientService.isSqlMessage(messageType)) {
            String memberVersion = this.nodeEngine.getVersion().toString();
            String clientVersion = this.endpoint.getClientVersion();
            return "Cannot process SQL client operation due to version mismatch (please ensure that the client and the member have the same version) [memberVersion=" + memberVersion + ", clientVersion=" + clientVersion + ']';
        }
        return "Unrecognized client message received with type: 0x" + Integer.toHexString(messageType);
    }
}

