/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.MemberAddressProvider;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;

public final class MemberAddressProviderConfig {
    private boolean enabled;
    private String className;
    private Properties properties = new Properties();
    private MemberAddressProvider implementation;

    public boolean isEnabled() {
        return this.enabled;
    }

    public MemberAddressProviderConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public MemberAddressProviderConfig setClassName(@Nonnull String className) {
        this.className = Preconditions.checkHasText(className, "Member address provider class name must contain text");
        this.implementation = null;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public MemberAddressProviderConfig setProperties(Properties properties) {
        Preconditions.checkNotNull(properties, "MemberAddressProvider properties cannot be null");
        this.properties = properties;
        return this;
    }

    public MemberAddressProvider getImplementation() {
        return this.implementation;
    }

    public MemberAddressProviderConfig setImplementation(@Nonnull MemberAddressProvider implementation) {
        this.implementation = Preconditions.checkNotNull(implementation, "Member address provider cannot be null!");
        this.className = null;
        return this;
    }

    public String toString() {
        return "MemberAddressProviderConfig{enabled=" + this.enabled + ", className='" + this.className + '\'' + ", properties=" + this.properties + ", implementation=" + this.implementation + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberAddressProviderConfig that = (MemberAddressProviderConfig)o;
        return this.isEnabled() == that.isEnabled() && this.getProperties().equals(that.getProperties()) && Objects.equals(this.className, that.className) && Objects.equals(this.implementation, that.implementation);
    }

    public int hashCode() {
        return Objects.hash(this.isEnabled(), this.getProperties(), this.className, this.implementation);
    }
}

