/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl;

import com.sun.enterprise.admin.servermgmt.stringsubs.impl.ArchiveEntryWrapper;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.ArchiveMember;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.FileSubstitutionHandler;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.LargeFileSubstitutionHandler;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.SmallFileSubstitutionHandler;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.SubstitutionFileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.Writer;

public class ArchiveMemberHandler
implements ArchiveMember {
    private final ArchiveEntryWrapper archiveWrapper;
    private final FileSubstitutionHandler handler;

    public ArchiveMemberHandler(File file, ArchiveEntryWrapper wrapper) throws FileNotFoundException {
        this.handler = file.length() > (long)SubstitutionFileUtil.getInMemorySubstitutionFileSizeInBytes() ? new LargeFileSubstitutionHandler(file) : new SmallFileSubstitutionHandler(file);
        this.archiveWrapper = wrapper;
    }

    @Override
    public void finish() {
        this.handler.finish();
        this.getParent().notifyCompletion();
    }

    @Override
    public ArchiveEntryWrapper getParent() {
        return this.archiveWrapper;
    }

    @Override
    public String getName() {
        return this.handler.getName();
    }

    @Override
    public Reader getReader() {
        return this.handler.getReader();
    }

    @Override
    public Writer getWriter() {
        return this.handler.getWriter();
    }
}

