/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.jaspic;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.config.ServerAuthContext;
import javax.security.auth.message.module.ServerAuthModule;

class SimpleSAMAuthContext
implements ServerAuthContext {
    ServerAuthModule sam;
    CallbackHandler handler;
    Map<String, String> options;

    SimpleSAMAuthContext(String authContextID, Subject serviceSubject, Map<String, String> properties, CallbackHandler handler, ServerAuthModule sam) throws AuthException {
        this.sam = sam;
        this.handler = handler;
        this.options = properties;
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        MessagePolicy requestPolicy = new MessagePolicy(new MessagePolicy.TargetPolicy[]{new MessagePolicy.TargetPolicy((MessagePolicy.Target[])null, new MessagePolicy.ProtectionPolicy(){

            public String getID() {
                return "#authenticateSender";
            }
        })}, true);
        this.sam.initialize(requestPolicy, null, this.handler, this.options);
        return this.sam.validateRequest(messageInfo, clientSubject, serviceSubject);
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        return this.sam.secureResponse(messageInfo, serviceSubject);
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        this.sam.cleanSubject(messageInfo, subject);
    }
}

