/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.uri.UriComponent;
import org.glassfish.jersey.uri.internal.JerseyUriBuilder;

public class RestClientUriBuilder
extends JerseyUriBuilder {
    private QueryParamStyle queryParamStyle = null;

    public RestClientUriBuilder() {
    }

    protected RestClientUriBuilder(RestClientUriBuilder that) {
        super((JerseyUriBuilder)that);
    }

    public static UriBuilder fromUri(URI uri) {
        return new RestClientUriBuilder().uri(uri);
    }

    public QueryParamStyle getQueryParamStyle() {
        return this.queryParamStyle;
    }

    public void setQueryParamStyle(QueryParamStyle queryParamStyle) {
        this.queryParamStyle = queryParamStyle;
    }

    public JerseyUriBuilder queryParam(String name, Object ... values) {
        this.checkSsp();
        if (name == null) {
            throw new IllegalArgumentException(LocalizationMessages.PARAM_NULL((Object)"name"));
        }
        if (values == null) {
            throw new IllegalArgumentException(LocalizationMessages.PARAM_NULL((Object)"values"));
        }
        if (values.length == 0) {
            return this;
        }
        name = this.encode(name, UriComponent.Type.QUERY_PARAM);
        if (this.queryParamStyle == QueryParamStyle.ARRAY_PAIRS) {
            this.clientQueryParamArrayPairs(name, values);
        } else if (this.queryParamStyle == QueryParamStyle.COMMA_SEPARATED) {
            this.clientQueryParamCommaSeparated(name, values);
        } else {
            this.clientQueryParamMultiPairs(name, values);
        }
        return this;
    }

    private void clientQueryParamMultiPairs(String name, Object ... values) {
        if (this.queryParams == null) {
            for (Object value : values) {
                if (this.query.length() > 0) {
                    this.query.append('&');
                }
                this.query.append(name);
                if (value == null) {
                    throw new IllegalArgumentException(LocalizationMessages.QUERY_PARAM_NULL());
                }
                this.query.append('=').append(this.encode(value.toString(), UriComponent.Type.QUERY_PARAM));
            }
        } else {
            for (Object value : values) {
                if (value == null) {
                    throw new IllegalArgumentException(LocalizationMessages.QUERY_PARAM_NULL());
                }
                this.queryParams.add((Object)name, (Object)this.encode(value.toString(), UriComponent.Type.QUERY_PARAM));
            }
        }
    }

    private void clientQueryParamCommaSeparated(String name, Object ... values) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder();
        if (this.queryParams == null) {
            if (this.query.length() > 0) {
                this.query.append('&');
            }
            this.query.append(name);
            int valuesCount = values.length - 1;
            for (Object value : values) {
                if (value == null) {
                    throw new IllegalArgumentException(LocalizationMessages.QUERY_PARAM_NULL());
                }
                sb.append(this.encode(value.toString(), UriComponent.Type.QUERY_PARAM));
                if (valuesCount <= 0) continue;
                sb.append(",");
                --valuesCount;
            }
            this.query.append('=').append(sb.toString());
        } else {
            int valuesCount = values.length - 1;
            for (Object value : values) {
                if (value == null) {
                    throw new IllegalArgumentException(LocalizationMessages.QUERY_PARAM_NULL());
                }
                sb.append(this.encode(value.toString(), UriComponent.Type.QUERY_PARAM));
                if (valuesCount <= 0) continue;
                sb.append(",");
                --valuesCount;
            }
            this.queryParams.add((Object)name, (Object)sb.toString());
        }
    }

    private void clientQueryParamArrayPairs(String name, Object ... values) throws IllegalArgumentException {
        if (this.queryParams == null) {
            for (Object value : values) {
                if (this.query.length() > 0) {
                    this.query.append('&');
                }
                this.query.append(name).append("[]");
                if (value == null) {
                    throw new IllegalArgumentException(LocalizationMessages.QUERY_PARAM_NULL());
                }
                this.query.append('=').append(this.encode(value.toString(), UriComponent.Type.QUERY_PARAM));
            }
        } else {
            for (Object value : values) {
                if (value == null) {
                    throw new IllegalArgumentException(LocalizationMessages.QUERY_PARAM_NULL());
                }
                this.queryParams.add((Object)(name + "[]"), (Object)this.encode(value.toString(), UriComponent.Type.QUERY_PARAM));
            }
        }
    }

    public RestClientUriBuilder clone() {
        return new RestClientUriBuilder(this);
    }
}

