/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.docker.node.admin;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="delete-node-docker")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@CommandLock(value=CommandLock.LockType.NONE)
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Nodes.class, opType=RestEndpoint.OpType.DELETE, path="delete-node-docker", description="Deletes a Docker Node")})
public class DeleteNodeDockerCommand
implements AdminCommand {
    @Param(name="name", primary=true)
    private String name;
    @Inject
    private Nodes nodes;
    @Inject
    private CommandRunner commandRunner;

    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        Node node = this.nodes.getNode(this.name);
        if (node == null) {
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            actionReport.setMessage("No node found with given name: " + this.name);
            return;
        }
        if (!node.getType().equals("DOCKER")) {
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            actionReport.setMessage("Node with given name is not a docker node: " + this.name);
            return;
        }
        CommandRunner.CommandInvocation commandInvocation = this.commandRunner.getCommandInvocation("_delete-node", actionReport, context.getSubject());
        ParameterMap commandParameters = new ParameterMap();
        commandParameters.add((Object)"DEFAULT", (Object)this.name);
        commandInvocation.parameters(commandParameters);
        commandInvocation.execute();
    }
}

