/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.docker.node.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.util.ColumnFormatter;
import javax.inject.Inject;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-nodes-docker")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-nodes-docker", description="Lists information about all Docker nodes registered to this domain")})
public class ListNodesDockerCommand
implements AdminCommand {
    private static final String[] OUTPUT_HEADERS = new String[]{"Name", "Host", "Image", "Port", "TLS Enabled"};
    @Inject
    private Nodes nodes;

    public void execute(AdminCommandContext adminCommandContext) {
        ColumnFormatter columnFormatter = new ColumnFormatter(OUTPUT_HEADERS);
        for (Node node : this.nodes.getNode()) {
            if (!node.getType().equals("DOCKER")) continue;
            Object[] nodeInfo = new Object[]{node.getName(), node.getNodeHost(), node.getDockerImage(), node.getDockerPort(), node.getUseTls()};
            columnFormatter.addRow(nodeInfo);
        }
        adminCommandContext.getActionReport().setMessage(columnFormatter.toString());
    }
}

