/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.admin;

import com.sun.enterprise.config.serverbeans.Config;
import fish.payara.nucleus.microprofile.config.admin.SetConfigOrdinal;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.validation.constraints.Min;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-config-cache")
@PerLookup
@ExecuteOn
@TargetType
@RestEndpoints(value={@RestEndpoint(configBean=MicroprofileConfigConfiguration.class, opType=RestEndpoint.OpType.POST, path="set-config-cache", description="Sets the cache duration for values in the MP Config")})
public class SetConfigCacheDuration
implements AdminCommand {
    @Min(value=0L)
    @Param(alias="duration")
    @Min(value=0L) int durationInSeconds;
    @Param(optional=true, defaultValue="server")
    String target;
    @Inject
    Target targetUtil;

    public void execute(AdminCommandContext context) {
        Config configVal = this.targetUtil.getConfig(this.target);
        MicroprofileConfigConfiguration serviceConfig = (MicroprofileConfigConfiguration)configVal.getExtensionByType(MicroprofileConfigConfiguration.class);
        if (serviceConfig != null) {
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MicroprofileConfigConfiguration>(){

                    public Object run(MicroprofileConfigConfiguration config) {
                        config.setCacheDurationSeconds(Integer.toString(SetConfigCacheDuration.this.durationInSeconds));
                        return null;
                    }
                }, (ConfigBeanProxy)serviceConfig);
            }
            catch (TransactionFailure ex) {
                context.getActionReport().failure(Logger.getLogger(SetConfigOrdinal.class.getName()), "Failed to update message", (Throwable)ex);
            }
        } else {
            context.getActionReport().failure(Logger.getLogger(SetConfigOrdinal.class.getName()), "No configuration with name " + this.target);
        }
    }
}

