/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.source;

import com.sun.enterprise.config.serverbeans.Resources;
import fish.payara.nucleus.microprofile.config.source.PayaraConfigSource;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.internal.api.Globals;
import org.glassfish.resourcebase.resources.admin.cli.ResourceUtil;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resources.admin.cli.CustomResourceManager;
import org.glassfish.resources.config.CustomResource;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

public class JNDIConfigSource
extends PayaraConfigSource {
    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    public int getOrdinal() {
        String storedOrdinal = this.getValue("config_ordinal");
        if (storedOrdinal != null) {
            return Integer.parseInt(storedOrdinal);
        }
        return Integer.parseInt(this.configService.getMPConfig().getJndiOrdinality());
    }

    public String getValue(String propertyName) {
        String result = null;
        try {
            InitialContext ctx = new InitialContext();
            Object jndiObj = ctx.lookup(propertyName);
            result = jndiObj.toString();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return result;
    }

    public String getName() {
        return "JNDI";
    }

    public boolean setValue(String propertyName, String propertyValue, String target) {
        boolean result = false;
        HashMap<String, String> attrList = new HashMap<String, String>();
        attrList.put("factory-class", "org.glassfish.resources.custom.factory.PrimitivesAndStringFactory");
        attrList.put("res-type", "java.lang.String");
        attrList.put("enabled", Boolean.TRUE.toString());
        attrList.put("jndi-name", propertyName);
        attrList.put("description", "MicroProfile Config property for " + propertyName);
        Properties props = new Properties();
        props.put("value", propertyValue);
        try {
            CustomResourceManager customResMgr = Globals.getDefaultHabitat().getService(CustomResourceManager.class, new Annotation[0]);
            ResourceStatus status = customResMgr.create(this.domainConfiguration.getResources(), attrList, props, target);
            if (status.getStatus() == 0) {
                result = true;
            } else if (status.isAlreadyExists()) {
                Logger.getLogger(JNDIConfigSource.class.getName()).log(Level.WARNING, "Unable to set MicroProfile JNDI Config property as it already exists please delete it using delete-config-property --source jndi --propertyname {0}", propertyName);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(JNDIConfigSource.class.getName()).log(Level.WARNING, "Unable to set MicroProfile JNDI Config property " + propertyName, ex);
        }
        return result;
    }

    public void deleteValue(final String propertyName, String target) throws TransactionFailure {
        ResourceUtil resourceUtil = Globals.getDefaultHabitat().getService(ResourceUtil.class, new Annotation[0]);
        resourceUtil.deleteResourceRef(propertyName, target);
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

            public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                CustomResource resource = (CustomResource)JNDIConfigSource.this.domainConfiguration.getResources().getResourceByName(CustomResource.class, propertyName);
                if (resource != null && resource.getJndiName().equals(propertyName)) {
                    return param.getResources().remove(resource);
                }
                return null;
            }
        }, (ConfigBeanProxy)this.domainConfiguration.getResources());
    }
}

