/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.cluster.SynchronizeInstanceCommand;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.servermgmt.cli.StartServerCommand;
import com.sun.enterprise.admin.servermgmt.cli.StartServerHelper;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.ObjectAnalyzer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.validation.constraints.Min;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="start-local-instance")
@ExecuteOn(value={RuntimeType.DAS})
@PerLookup
public class StartLocalInstanceCommand
extends SynchronizeInstanceCommand
implements StartServerCommand {
    @Param(optional=true, shortName="v", defaultValue="false")
    private boolean verbose;
    @Param(optional=true, shortName="w", defaultValue="false")
    private boolean watchdog;
    @Param(optional=true, shortName="d", defaultValue="false")
    private boolean debug;
    @Param(name="dry-run", shortName="n", optional=true, defaultValue="false")
    private boolean dryRun;
    @Min(message="Timeout must be at least 1 second long.", value=1L)
    @Param(optional=true, defaultValue="600")
    private @Min(message="Timeout must be at least 1 second long.", value=1L) int timeout;
    private StartServerHelper startServerHelper;
    private GFLauncherInfo launcherInfo;
    private GFLauncher launcher;

    public RuntimeType getType() {
        return RuntimeType.INSTANCE;
    }

    public void createLauncher() throws GFLauncherException, MiniXmlParserException {
        this.setLauncher(GFLauncherFactory.getInstance((RuntimeType)this.getType()));
        this.setInfo(this.getLauncher().getInfo());
        this.getInfo().setInstanceName(this.instanceName);
        this.getInfo().setInstanceRootDir(this.instanceDir);
        this.getInfo().setVerbose(this.verbose);
        this.getInfo().setWatchdog(this.watchdog);
        this.getInfo().setDebug(this.debug);
        this.getInfo().setRespawnInfo(this.programOpts.getClassName(), this.programOpts.getClassPath(), this.respawnArgs());
        this.getLauncher().setup();
    }

    public List<String> getLauncherArgs() {
        return this.getLauncher().getCommandLine();
    }

    @Override
    protected boolean mkdirs(File f) {
        return false;
    }

    @Override
    protected void validate() throws CommandException {
        super.validate();
        if (!this.getServerDirs().getServerDir().isDirectory()) {
            throw new CommandException(Strings.get("Instance.noSuchInstance"));
        }
        if (this.timeout < 1) {
            throw new CommandException("Timeout must be at least 1 second long.");
        }
    }

    @Override
    protected int executeCommand() throws CommandException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString());
        }
        if (this.sync.equals("none")) {
            logger.info(Strings.get("Instance.nosync"));
        } else if (!this.synchronizeInstance()) {
            File domainXml = new File(new File(this.instanceDir, "config"), "domain.xml");
            if (!domainXml.exists()) {
                logger.info(Strings.get("Instance.nodomainxml"));
                return 1;
            }
            logger.info(Strings.get("Instance.syncFailed"));
        }
        try {
            this.createLauncher();
            this.startServerHelper = new StartServerHelper(logger, this.programOpts.isTerse(), this.getServerDirs(), this.launcher, this.getMasterPassword());
            if (!this.startServerHelper.prepareForLaunch()) {
                return 1;
            }
            if (this.dryRun) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(Strings.get("dry_run_msg"));
                }
                List cmd = this.getLauncher().getCommandLine();
                StringBuilder sb = new StringBuilder();
                for (String s : cmd) {
                    sb.append(s);
                    sb.append('\n');
                }
                logger.info(sb.toString());
                return 0;
            }
            this.getLauncher().launch();
            if (this.verbose || this.watchdog) {
                while (true) {
                    int returnValue = this.getLauncher().getExitValue();
                    switch (returnValue) {
                        case 10: {
                            logger.info(Strings.get("restart"));
                            break;
                        }
                        case 11: {
                            logger.info(Strings.get("restartChangeDebug", "on"));
                            this.getInfo().setDebug(true);
                            break;
                        }
                        case 12: {
                            logger.info(Strings.get("restartChangeDebug", "off"));
                            this.getInfo().setDebug(false);
                            break;
                        }
                        default: {
                            return returnValue;
                        }
                    }
                    if (this.env.debug()) {
                        System.setProperty("WALL_CLOCK_START", Long.toString(System.currentTimeMillis()));
                    }
                    this.getLauncher().relaunch();
                }
            }
            this.startServerHelper.waitForServer((long)this.timeout, TimeUnit.SECONDS);
            this.startServerHelper.report();
            return 0;
        }
        catch (GFLauncherException gfle) {
            throw new CommandException(gfle.getMessage());
        }
        catch (MiniXmlParserException me) {
            throw new CommandException((Throwable)me);
        }
    }

    private String[] respawnArgs() {
        ArrayList<String> args = new ArrayList<String>(15);
        args.addAll(Arrays.asList(this.programOpts.getProgramArguments()));
        args.add(this.getName());
        args.add("--verbose=" + this.verbose);
        args.add("--watchdog=" + this.watchdog);
        args.add("--debug=" + this.debug);
        if (StartLocalInstanceCommand.ok((String)this.nodeDir)) {
            args.add("--nodedir");
            args.add(this.nodeDir);
        }
        if (StartLocalInstanceCommand.ok((String)this.node)) {
            args.add("--node");
            args.add(this.node);
        }
        if (StartLocalInstanceCommand.ok((String)this.instanceName)) {
            args.add(this.instanceName);
        }
        logger.finer(() -> "Respawn args: " + args);
        String[] a = new String[args.size()];
        args.toArray(a);
        return a;
    }

    private GFLauncher getLauncher() {
        if (this.launcher == null) {
            throw new RuntimeException(Strings.get("internal.error", "GFLauncher was not initialized"));
        }
        return this.launcher;
    }

    private void setLauncher(GFLauncher gfl) {
        this.launcher = gfl;
    }

    private GFLauncherInfo getInfo() {
        if (this.launcherInfo == null) {
            throw new RuntimeException(Strings.get("internal.error", "GFLauncherInfo was not initialized"));
        }
        return this.launcherInfo;
    }

    private void setInfo(GFLauncherInfo inf) {
        this.launcherInfo = inf;
    }

    public String toString() {
        return ObjectAnalyzer.toStringWithSuper((Object)((Object)this));
    }
}

