/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.server.logging.GFFileHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.INSTANCE}, ifOffline=FailurePolicy.Error, ifNeverStarted=FailurePolicy.Error)
@Service(name="rotate-log")
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.DEPLOYMENT_GROUP})
@PerLookup
@I18n(value="rotate.log")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="rotate-log", description="Rotate Log")})
public class RotateLog
implements AdminCommand {
    @Inject
    GFFileHandler gf;
    @Inject
    Domain domain;
    @Inject
    ServerEnvironment env;
    @Param(optional=true)
    String target = "server";
    private static final LocalStringManagerImpl LOCAL_STRINGS = new LocalStringManagerImpl(RotateLog.class);

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.gf.rotate();
        String msg = LOCAL_STRINGS.getLocalString("rotated.log.message", "Rotated log for server instance {0}.", new Object[]{this.env.getInstanceName()});
        report.setMessage(msg);
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

