/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebConnector;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.WebModuleContextConfig;
import com.sun.enterprise.web.WebModuleDecorator;
import com.sun.enterprise.web.WebModuleListener;
import com.sun.enterprise.web.logger.FileLoggerHandlerFactory;
import com.sun.enterprise.web.pluggable.WebContainerFeatureFactory;
import com.sun.web.server.WebContainerListener;
import java.io.File;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.catalina.Connector;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Embedded;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.NamedNamingObjectProxy;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.web.LogFacade;
import org.jvnet.hk2.annotations.Service;

@Service(name="com.sun.enterprise.web.EmbeddedWebContainer")
@Singleton
public final class EmbeddedWebContainer
extends Embedded
implements PostConstruct {
    public static final Logger logger = LogFacade.getLogger();
    @Inject
    private ServiceLocator services;
    @Inject
    private ServerContext serverContext;
    private WebContainerFeatureFactory webContainerFeatureFactory;
    private WebContainer webContainer;
    private InvocationManager invocationManager;
    private InjectionManager injectionManager;
    private NamedNamingObjectProxy validationNamingProxy;
    private String logServiceFile;
    private String logLevel;
    private FileLoggerHandlerFactory fileLoggerHandlerFactory;

    void setWebContainer(WebContainer webContainer) {
        this.webContainer = webContainer;
    }

    void setLogServiceFile(String logServiceFile) {
        this.logServiceFile = logServiceFile;
    }

    void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    void setFileLoggerHandlerFactory(FileLoggerHandlerFactory fileLoggerHandlerFactory) {
        this.fileLoggerHandlerFactory = fileLoggerHandlerFactory;
    }

    void setWebContainerFeatureFactory(WebContainerFeatureFactory webContainerFeatureFactory) {
        this.webContainerFeatureFactory = webContainerFeatureFactory;
    }

    public void postConstruct() {
        this.invocationManager = (InvocationManager)this.services.getService(InvocationManager.class, new Annotation[0]);
        this.injectionManager = (InjectionManager)this.services.getService(InjectionManager.class, new Annotation[0]);
        this.validationNamingProxy = (NamedNamingObjectProxy)this.services.getService(NamedNamingObjectProxy.class, "ValidationNamingProxy", new Annotation[0]);
    }

    public Host createHost(String vsID, com.sun.enterprise.config.serverbeans.VirtualServer vsBean, String vsDocroot, String vsLogFile, MimeMap vsMimeMap) {
        VirtualServer vs = new VirtualServer();
        vs.setFileLoggerHandlerFactory(this.fileLoggerHandlerFactory);
        vs.configure(vsID, vsBean, vsDocroot, vsLogFile, vsMimeMap, this.logServiceFile, this.logLevel);
        ContainerListener listener = this.loadListener("com.sun.enterprise.web.connector.extension.CatalinaListener");
        if (listener != null) {
            vs.addContainerListener(listener);
        }
        return vs;
    }

    public Context createContext(String id, String ctxPath, File location, String defaultContextXmlLocation, String defaultWebXmlLocation, boolean useDOLforDeployment, WebModuleConfig wmInfo) {
        File configFile = null;
        configFile = ctxPath.equals("") ? new File(this.getCatalinaHome() + "/config", "ROOT.xml") : new File(this.getCatalinaHome() + "/config", ctxPath + ".xml");
        if (!configFile.exists()) {
            configFile = new File(location, "META-INF/context.xml");
        }
        WebModule context = new WebModule(this.services);
        context.setID(id);
        context.setWebContainer(this.webContainer);
        context.setDebug(this.debug);
        context.setPath(ctxPath);
        context.setDocBase(location.getAbsolutePath());
        context.setCrossContext(true);
        context.setUseNaming(this.isUseNaming());
        context.setHasWebXml(wmInfo.getDescriptor() != null);
        context.setWebBundleDescriptor(wmInfo.getDescriptor());
        context.setManagerChecksFrequency(1);
        context.setServerContext(this.serverContext);
        context.setWebModuleConfig(wmInfo);
        context.setDefaultWebXml(defaultWebXmlLocation);
        if (this.embeddedDirectoryListing) {
            context.setDirectoryListing(this.embeddedDirectoryListing);
        }
        if (configFile.exists()) {
            context.setConfigFile(configFile.getAbsolutePath());
        }
        this.addLifecycleListeners(context, defaultContextXmlLocation, defaultWebXmlLocation, useDOLforDeployment, wmInfo);
        context.addContainerListener(new WebContainerListener(this.invocationManager, this.injectionManager, this.validationNamingProxy));
        for (WebModuleDecorator d : this.services.getAllServices(WebModuleDecorator.class, new Annotation[0])) {
            d.decorate(context);
        }
        return context;
    }

    public void updateContext(WebModule context, String defaultContextXmlLocation, String defaultWebXmlLocation, boolean useDOLforDeployment, WebModuleConfig wmInfo) {
        context.setWebModuleConfig(wmInfo);
        context.setWebBundleDescriptor(wmInfo.getDescriptor());
        context.removeLifecycleListeners();
        this.addLifecycleListeners(context, defaultContextXmlLocation, defaultWebXmlLocation, useDOLforDeployment, wmInfo);
    }

    private void addLifecycleListeners(WebModule context, String defaultContextXmlLocation, String defaultWebXmlLocation, boolean useDOLforDeployment, WebModuleConfig wmInfo) {
        ContextConfig config;
        if (useDOLforDeployment) {
            config = new WebModuleContextConfig(this.services);
            ((WebModuleContextConfig)config).setDescriptor(wmInfo.getDescriptor());
        } else {
            config = new ContextConfig();
        }
        config.setDefaultContextXml(defaultContextXmlLocation);
        config.setDefaultWebXml(defaultWebXmlLocation);
        context.addLifecycleListener((LifecycleListener)config);
        context.addLifecycleListener(new WebModuleListener(this.webContainer, wmInfo.getDescriptor()));
    }

    private ContainerListener loadListener(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (ContainerListener)clazz.newInstance();
        }
        catch (Throwable ex) {
            String msg = logger.getResourceBundle().getString("AS-WEB-GLUE-00091");
            msg = MessageFormat.format(msg, className);
            logger.log(Level.SEVERE, msg, ex);
            return null;
        }
    }

    public Engine[] getEngines() {
        return this.engines;
    }

    public Connector[] getConnectors() {
        return this.connectors;
    }

    public Connector createConnector(String address, int port, String protocol) {
        int index;
        if (address != null && (index = address.indexOf(47)) != -1) {
            address = address.substring(index + 1);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "AS-WEB-GLUE-00092", new Object[]{address == null ? "ALL" : address, port, protocol});
        }
        WebConnector connector = new WebConnector(this.webContainer);
        if (address != null) {
            connector.setAddress(address);
        }
        connector.setPort(port);
        if (protocol.equals("ajp")) {
            connector.setProtocolHandlerClassName("org.apache.jk.server.JkCoyoteHandler");
        } else if (protocol.equals("memory")) {
            connector.setProtocolHandlerClassName("org.apache.coyote.memory.MemoryProtocolHandler");
        } else if (protocol.equals("https")) {
            connector.setScheme("https");
            connector.setSecure(true);
        }
        return connector;
    }

    public Engine createEngine() {
        StandardEngine engine = new StandardEngine();
        engine.setDebug(this.debug);
        engine.setLogger(super.getLogger());
        engine.setRealm(null);
        return engine;
    }
}

