/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.descriptor;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.deployment.web.MultipartConfig;
import com.sun.enterprise.deployment.web.SecurityRoleReference;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.web.deployment.descriptor.MultipartConfigDescriptor;

public class WebComponentDescriptorImpl
extends WebComponentDescriptor {
    private static final long serialVersionUID = -426082855000062548L;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebComponentDescriptor.class);
    public static final String BASIC_AUTHENTICATION = "basic";
    public static final String FORM_AUTHENTICATION = "form";
    public static final String SSL_AUTHENTICATION = "ssl";
    public static final String GET = "GET";
    public static final String PUT = "PUT";
    public static final String POST = "POST";
    public static final String DELETE = "DELETE";
    private Set<InitializationParameter> initializationParameters;
    private Set<String> urlPatterns;
    private String canonicalName;
    private Integer loadOnStartUp;
    private Set<SecurityRoleReference> securityRoleReferences;
    private RunAsIdentityDescriptor runAs;
    private WebBundleDescriptor webBundleDescriptor;
    private boolean enabled = true;
    private Boolean asyncSupported;
    private MultipartConfig multipartConfig;
    private transient List<Method> httpMethods;
    private boolean conflict;
    private Set<String> conflictedInitParameterNames;
    private String implFile = "";
    private boolean isServlet;

    public WebComponentDescriptorImpl() {
    }

    public WebComponentDescriptorImpl(WebComponentDescriptor other) {
        this.setCanonicalName(other.getCanonicalName());
        this.setServlet(other.isServlet());
        this.setWebComponentImplementation(other.getWebComponentImplementation());
        this.getInitializationParameterSet().addAll(other.getInitializationParameterSet());
        this.getUrlPatternsSet().addAll(other.getUrlPatternsSet());
        this.setLoadOnStartUp(other.getLoadOnStartUp());
        this.getSecurityRoleReferenceSet().addAll(other.getSecurityRoleReferenceSet());
        this.setRunAsIdentity(other.getRunAsIdentity());
        this.setAsyncSupported(other.isAsyncSupported());
        this.setMultipartConfig(other.getMultipartConfig());
        this.setWebBundleDescriptor(other.getWebBundleDescriptor());
        this.conflictedInitParameterNames = other.getConflictedInitParameterNames();
        this.setConflict(other.isConflict());
    }

    public Set<InitializationParameter> getInitializationParameterSet() {
        if (this.initializationParameters == null) {
            this.initializationParameters = new OrderedSet();
        }
        return this.initializationParameters;
    }

    public Enumeration<InitializationParameter> getInitializationParameters() {
        return Collections.enumeration(new ArrayList<InitializationParameter>(this.getInitializationParameterSet()));
    }

    public InitializationParameter getInitializationParameterByName(String name) {
        for (InitializationParameter next : this.getInitializationParameterSet()) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        return null;
    }

    public void addInitializationParameter(InitializationParameter initializationParameter) {
        this.getInitializationParameterSet().add(initializationParameter);
    }

    public void removeInitializationParameter(InitializationParameter initializationParameter) {
        this.getInitializationParameterSet().remove(initializationParameter);
    }

    public Set<String> getConflictedInitParameterNames() {
        if (this.conflictedInitParameterNames == null) {
            this.conflictedInitParameterNames = new HashSet<String>();
        }
        return this.conflictedInitParameterNames;
    }

    public Set<String> getUrlPatternsSet() {
        if (this.urlPatterns == null) {
            this.urlPatterns = new OrderedSet<String>(){
                private static final long serialVersionUID = -43840281980324986L;

                public boolean add(String s) {
                    Map<String, String> up2sname = this.getUrlPatternToServletNameMap();
                    if (up2sname != null) {
                        String name = WebComponentDescriptorImpl.this.getCanonicalName();
                        String oldName = up2sname.put(s, WebComponentDescriptorImpl.this.getCanonicalName());
                        if (oldName != null && !oldName.equals(name)) {
                            throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionsameurlpattern", "Servlet [{0}] and Servlet [{1}] have the same url pattern: [{2}]", new Object[]{oldName, name, s}));
                        }
                    }
                    return super.add((Object)s);
                }

                public boolean remove(Object o) {
                    boolean result = super.remove(o);
                    if (WebComponentDescriptorImpl.this.getWebBundleDescriptor() != null) {
                        WebComponentDescriptorImpl.this.getWebBundleDescriptor().resetUrlPatternToServletNameMap();
                    }
                    return result;
                }

                private Map<String, String> getUrlPatternToServletNameMap() {
                    return WebComponentDescriptorImpl.this.getWebBundleDescriptor() != null ? WebComponentDescriptorImpl.this.getWebBundleDescriptor().getUrlPatternToServletNameMap() : null;
                }
            };
        }
        return this.urlPatterns;
    }

    public Enumeration<String> getUrlPatterns() {
        return Collections.enumeration(new ArrayList<String>(this.getUrlPatternsSet()));
    }

    public void addUrlPattern(String urlPattern) {
        this.getUrlPatternsSet().add(urlPattern);
    }

    public void removeUrlPattern(String urlPattern) {
        this.getUrlPatternsSet().remove(urlPattern);
    }

    public void setWebBundleDescriptor(WebBundleDescriptor webBundleDescriptor) {
        this.webBundleDescriptor = webBundleDescriptor;
    }

    public WebBundleDescriptor getWebBundleDescriptor() {
        return this.webBundleDescriptor;
    }

    public String getCanonicalName() {
        if (this.canonicalName == null) {
            this.canonicalName = this.getName();
        }
        return this.canonicalName;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    public Integer getLoadOnStartUp() {
        return this.loadOnStartUp;
    }

    public void setLoadOnStartUp(Integer loadOnStartUp) {
        this.loadOnStartUp = loadOnStartUp;
    }

    public void setLoadOnStartUp(String loadOnStartUp) throws NumberFormatException {
        this.loadOnStartUp = Integer.decode(loadOnStartUp);
    }

    public Set<SecurityRoleReference> getSecurityRoleReferenceSet() {
        if (this.securityRoleReferences == null) {
            this.securityRoleReferences = new OrderedSet();
        }
        return this.securityRoleReferences;
    }

    public Enumeration<SecurityRoleReference> getSecurityRoleReferences() {
        return Collections.enumeration(new ArrayList<SecurityRoleReference>(this.getSecurityRoleReferenceSet()));
    }

    public SecurityRoleReference getSecurityRoleReferenceByName(String roleReferenceName) {
        for (SecurityRoleReference scurityRoleReference : this.getSecurityRoleReferenceSet()) {
            if (!scurityRoleReference.getRoleName().equals(roleReferenceName)) continue;
            return scurityRoleReference;
        }
        return null;
    }

    public void addSecurityRoleReference(SecurityRoleReference securityRoleReference) {
        this.getSecurityRoleReferenceSet().add(securityRoleReference);
    }

    public void removeSecurityRoleReference(SecurityRoleReference securityRoleReference) {
        this.getSecurityRoleReferenceSet().remove(securityRoleReference);
    }

    public void setRunAsIdentity(RunAsIdentityDescriptor runAs) {
        if (this.runAs == null) {
            this.runAs = runAs;
        }
    }

    public RunAsIdentityDescriptor getRunAsIdentity() {
        return this.runAs;
    }

    public boolean getUsesCallerIdentity() {
        return this.runAs == null;
    }

    public void setUsesCallerIdentity(boolean isCallerID) {
        this.runAs = isCallerID ? null : new RunAsIdentityDescriptor("");
    }

    public MultipartConfig getMultipartConfig() {
        return this.multipartConfig;
    }

    public void setMultipartConfig(MultipartConfig multipartConfig) {
        this.multipartConfig = multipartConfig;
    }

    public void setMultipartConfig(MultipartConfigDescriptor multipartConfigDesc) {
        this.multipartConfig = multipartConfigDesc;
    }

    public Application getApplication() {
        if (this.getWebBundleDescriptor() != null) {
            return this.getWebBundleDescriptor().getApplication();
        }
        return null;
    }

    public void setWebComponentImplementation(String implFile) {
        if (!this.isServlet && !implFile.startsWith("/")) {
            implFile = "/" + implFile;
        }
        this.implFile = implFile;
    }

    public String getWebComponentImplementation() {
        return this.implFile;
    }

    public boolean isServlet() {
        return this.isServlet;
    }

    public void setServlet(boolean isServlet) {
        this.isServlet = isServlet;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setAsyncSupported(Boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    public Boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public void setConflict(boolean conflict) {
        this.conflict = conflict;
    }

    public boolean isConflict() {
        return this.conflict;
    }

    public Method[] getUserDefinedHttpMethods() {
        if (this.httpMethods == null) {
            this.httpMethods = new ArrayList<Method>();
            if (this.isServlet) {
                String[] httpMString;
                ArrayList<String> searchingMethods = new ArrayList<String>();
                for (String s : httpMString = new String[]{"doDelete", "doGet", "doHead", "doOptions", "doPost", "doPut", "doTrace"}) {
                    searchingMethods.add(s);
                }
                try {
                    Class<?> implClass;
                    Class<?> clazz = implClass = Class.forName(this.implFile, true, Thread.currentThread().getContextClassLoader());
                    String packageName = null;
                    Package clazzPackage = implClass.getPackage();
                    if (clazzPackage != null) {
                        packageName = clazzPackage.getName();
                    }
                    while (clazz != null && !clazz.getName().startsWith("javax.servlet.") && searchingMethods.size() > 0) {
                        Method[] methods;
                        Package p = clazz.getPackage();
                        for (Method m : methods = clazz.getDeclaredMethods()) {
                            String methodName = m.getName();
                            if (!searchingMethods.contains(methodName)) continue;
                            Class<?> returnType = m.getReturnType();
                            Class<?>[] parameterTypes = m.getParameterTypes();
                            int modifiers = m.getModifiers();
                            boolean isSamePackage = p == null && clazzPackage == null || p != null && clazzPackage != null && packageName.equals(p.getName());
                            boolean valid = Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers) || !Modifier.isPrivate(modifiers) && isSamePackage;
                            boolean bl = valid = valid && Void.TYPE.equals(returnType) && parameterTypes.length == 2 && parameterTypes[0].equals(HttpServletRequest.class) && parameterTypes[1].equals(HttpServletResponse.class);
                            if (valid) {
                                this.httpMethods.add(m);
                                searchingMethods.remove(methodName);
                            }
                            if (searchingMethods.size() == 0) break;
                        }
                        clazz = clazz.getSuperclass();
                    }
                }
                catch (Throwable t) {
                    throw new IllegalStateException(t);
                }
            }
        }
        return this.httpMethods.toArray(new Method[this.httpMethods.size()]);
    }

    public void print(StringBuilder toStringBuilder) {
        super.print(toStringBuilder);
        toStringBuilder.append("WebComponentDescriptor\n");
        toStringBuilder.append("\n initializationParameters ").append(this.initializationParameters);
        toStringBuilder.append("\n urlPatterns ").append(this.urlPatterns);
        toStringBuilder.append("\n canonicalName ").append(this.canonicalName);
        toStringBuilder.append("\n loadOnStartUp ").append(this.loadOnStartUp);
        toStringBuilder.append("\n enabled ").append(this.enabled);
        toStringBuilder.append("\n asyncSupported ").append(this.asyncSupported);
        toStringBuilder.append("\n securityRoleReferences ").append(this.securityRoleReferences);
        toStringBuilder.append("\n multipartConfig ").append(this.multipartConfig);
        if (this.isServlet()) {
            toStringBuilder.append("\n servlet className ").append(this.getWebComponentImplementation());
        } else {
            toStringBuilder.append("\n jspFileName ").append(this.getWebComponentImplementation());
        }
    }

    public boolean equals(Object other) {
        return other instanceof WebComponentDescriptor && this.getCanonicalName().equals(((WebComponentDescriptor)other).getCanonicalName());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getCanonicalName().hashCode();
        return result;
    }

    public void add(WebComponentDescriptor other) {
        this.add(other, true, false);
    }

    public void add(WebComponentDescriptor other, boolean combineUrlPatterns, boolean combineConflict) {
        if (!this.getCanonicalName().equals(other.getCanonicalName())) {
            return;
        }
        if (this.isServlet() && !other.isServlet() || !this.isServlet() && other.isServlet()) {
            return;
        }
        if (combineUrlPatterns || this.getUrlPatternsSet().size() == 0) {
            this.getUrlPatternsSet().addAll(other.getUrlPatternsSet());
        }
        if (this.conflictedInitParameterNames == null) {
            this.conflictedInitParameterNames = other.getConflictedInitParameterNames();
        } else {
            this.conflictedInitParameterNames.addAll(other.getConflictedInitParameterNames());
        }
        if (!combineConflict) {
            for (InitializationParameter initParam : this.getInitializationParameterSet()) {
                this.conflictedInitParameterNames.remove(initParam.getName());
            }
        }
        for (InitializationParameter initParam : other.getInitializationParameterSet()) {
            InitializationParameter origInitParam = this.getInitializationParameterByName(initParam.getName());
            if (origInitParam == null) {
                this.getInitializationParameterSet().add(initParam);
                continue;
            }
            if (!combineConflict || origInitParam.getValue().equals(initParam.getValue())) continue;
            this.getConflictedInitParameterNames().add(initParam.getName());
        }
        for (SecurityRoleReference secRoleRef : other.getSecurityRoleReferenceSet()) {
            if (this.getSecurityRoleReferenceByName(secRoleRef.getRoleName()) != null) continue;
            this.getSecurityRoleReferenceSet().add(secRoleRef);
        }
        if (this.getLoadOnStartUp() == null) {
            this.setLoadOnStartUp(other.getLoadOnStartUp());
        }
        if (this.isAsyncSupported() == null) {
            this.setAsyncSupported(other.isAsyncSupported());
        }
        if (this.getRunAsIdentity() == null) {
            this.setRunAsIdentity(other.getRunAsIdentity());
        }
        if (this.getMultipartConfig() == null) {
            this.setMultipartConfig(other.getMultipartConfig());
        }
        if (this.getWebComponentImplementation() == null) {
            this.setWebComponentImplementation(other.getWebComponentImplementation());
        }
    }

    public boolean isConflict(WebComponentDescriptor other, boolean allowNullImplNameOverride) {
        if (this.conflict || other.isConflict()) {
            return true;
        }
        if (!this.getCanonicalName().equals(other.getCanonicalName())) {
            return false;
        }
        String otherImplFile = other.getWebComponentImplementation();
        boolean matchImplName = allowNullImplNameOverride ? this.implFile == null || this.implFile.length() == 0 || otherImplFile == null || otherImplFile.length() == 0 || this.implFile.equals(otherImplFile) : (this.implFile == null || this.implFile.length() == 0) && (otherImplFile == null || otherImplFile.length() == 0) || this.implFile != null && this.implFile.equals(otherImplFile);
        boolean otherAsyncSupported = other.isAsyncSupported() != null ? other.isAsyncSupported() : false;
        boolean thisAsyncSupported = this.asyncSupported != null ? this.asyncSupported : false;
        boolean matchAsyncSupported = thisAsyncSupported == otherAsyncSupported;
        return !matchImplName || !matchAsyncSupported;
    }
}

