/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.Serializable;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.core.JISession;

final class JIStringBinding
implements Serializable {
    private static final long serialVersionUID = -5797400235890434880L;
    private int towerId = -1;
    private String networkAddress = null;
    private int length = -1;

    private JIStringBinding() {
    }

    public int getLength() {
        return this.length;
    }

    JIStringBinding(int port, boolean hostname) {
        String hostaddress = null;
        hostaddress = !hostname ? JISession.getLocalhostAddressAsIPString() : JISession.getLocalhostCanonicalAddressAsString();
        this.networkAddress = port == -1 ? hostaddress : String.valueOf(hostaddress) + "[" + Integer.toString(port) + "]";
        this.length = 2 + this.networkAddress.length() * 2 + 2;
        this.towerId = 7;
    }

    JIStringBinding(int port) {
        this(port, false);
    }

    static JIStringBinding decode(NetworkDataRepresentation ndr) {
        JIStringBinding stringBinding = new JIStringBinding();
        stringBinding.towerId = ndr.readUnsignedShort();
        if (stringBinding.towerId == 0) {
            return null;
        }
        int retVal = -1;
        StringBuffer buffer = new StringBuffer();
        while ((retVal = ndr.readUnsignedShort()) != 0) {
            buffer.append(new String(new byte[]{(byte)retVal}));
        }
        stringBinding.networkAddress = buffer.toString();
        stringBinding.length = 2 + stringBinding.networkAddress.length() * 2 + 2;
        return stringBinding;
    }

    public int getTowerId() {
        return this.towerId;
    }

    public String getNetworkAddress() {
        return this.networkAddress;
    }

    public void encode(NetworkDataRepresentation ndr) {
        ndr.writeUnsignedShort(this.towerId);
        int i = 0;
        while (i < this.networkAddress.length()) {
            ndr.writeUnsignedShort(this.networkAddress.charAt(i));
            ++i;
        }
        ndr.writeUnsignedShort(0);
    }
}

