/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.log;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.util.log.FormatterDelegate;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractsProvided(value={Formatter.class})
@PerLookup
public class UniformLogFormatter
extends Formatter {
    private HashMap loggerResourceBundleTable;
    private LogManager logManager;
    private Date date = new Date();
    private static String PRODUCTID_CONTEXTID;
    private static Version version;
    private static final String PRODUCT_VERSION;
    private static final int FINE_LEVEL_INT_VALUE;
    private static boolean LOG_SOURCE_IN_KEY_VALUE;
    private static boolean RECORD_NUMBER_IN_KEY_VALUE;
    private FormatterDelegate _delegate = null;
    private long recordNumber = 0L;
    private static final String LINE_SEPARATOR;
    private String recordBeginMarker;
    private String recordEndMarker;
    private String recordFieldSeparator;
    private String recordDateFormat;
    private static final String RECORD_BEGIN_MARKER = "[#|";
    private static final String RECORD_END_MARKER;
    private static final char FIELD_SEPARATOR = '|';
    public static final char NVPAIR_SEPARATOR = ';';
    public static final char NV_SEPARATOR = '=';
    private static final String RFC_3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    public UniformLogFormatter() {
        this.loggerResourceBundleTable = new HashMap();
        this.logManager = LogManager.getLogManager();
    }

    public UniformLogFormatter(FormatterDelegate delegate) {
        this();
        this._delegate = delegate;
    }

    public void setDelegate(FormatterDelegate delegate) {
        this._delegate = delegate;
    }

    @Override
    public String format(LogRecord record) {
        return this.uniformLogFormat(record);
    }

    @Override
    public String formatMessage(LogRecord record) {
        return this.uniformLogFormat(record);
    }

    protected String getProductId() {
        return version.getProductVersion();
    }

    protected void getNameValuePairs(StringBuilder buf, LogRecord record) {
        Object[] parameters = record.getParameters();
        if (parameters == null || parameters.length == 0) {
            return;
        }
        try {
            for (Object obj : parameters) {
                if (obj == null) continue;
                if (obj instanceof Map) {
                    for (Map.Entry entry : ((Map)obj).entrySet()) {
                        if (entry.getKey() != null) {
                            buf.append(entry.getKey().toString());
                        } else {
                            buf.append("null");
                        }
                        buf.append('=');
                        if (entry.getValue() != null) {
                            buf.append(entry.getValue().toString());
                        } else {
                            buf.append("null");
                        }
                        buf.append(';');
                    }
                    continue;
                }
                if (!(obj instanceof Collection)) continue;
                for (Map.Entry entry : (Collection)obj) {
                    if (entry != null) {
                        buf.append(entry.toString());
                    } else {
                        buf.append("null");
                    }
                    buf.append(';');
                }
            }
        }
        catch (Exception e) {
            new ErrorManager().error("Error in extracting Name Value Pairs", e, 5);
        }
    }

    private String uniformLogFormat(LogRecord record) {
        try {
            SimpleDateFormat dateFormatter = new SimpleDateFormat(this.getRecordDateFormat() != null ? this.getRecordDateFormat() : RFC_3339_DATE_FORMAT);
            StringBuilder recordBuffer = new StringBuilder(this.getRecordBeginMarker() != null ? this.getRecordBeginMarker() : RECORD_BEGIN_MARKER);
            this.date.setTime(record.getMillis());
            recordBuffer.append(dateFormatter.format(this.date));
            recordBuffer.append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf('|'));
            recordBuffer.append(record.getLevel()).append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf('|'));
            recordBuffer.append(this.getProductId()).append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf('|'));
            recordBuffer.append(record.getLoggerName()).append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf('|'));
            recordBuffer.append("_ThreadID").append('=');
            recordBuffer.append(record.getThreadID()).append(';');
            recordBuffer.append("_ThreadName").append('=');
            recordBuffer.append(Thread.currentThread().getName());
            recordBuffer.append(';');
            Level level = record.getLevel();
            if (LOG_SOURCE_IN_KEY_VALUE || level.intValue() <= Level.FINE.intValue()) {
                recordBuffer.append("ClassName").append('=');
                recordBuffer.append(record.getSourceClassName());
                recordBuffer.append(';');
                recordBuffer.append("MethodName").append('=');
                recordBuffer.append(record.getSourceMethodName());
                recordBuffer.append(';');
            }
            if (RECORD_NUMBER_IN_KEY_VALUE) {
                recordBuffer.append("RecordNumber").append('=');
                recordBuffer.append(this.recordNumber++).append(';');
            }
            if (this._delegate != null) {
                this._delegate.format(recordBuffer, level);
            }
            recordBuffer.append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf('|'));
            String logMessage = record.getMessage();
            if (logMessage == null || logMessage.trim().equals("")) {
                if (record.getThrown() != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    recordBuffer.append(sw.toString());
                    sw.close();
                } else {
                    logMessage = "The log message is empty or null. Please log an issue against the component in the logger field.";
                    recordBuffer.append(logMessage);
                }
            } else {
                if (logMessage.indexOf("{0") >= 0 && logMessage.contains("}") && record.getParameters() != null) {
                    logMessage = MessageFormat.format(logMessage, record.getParameters());
                } else {
                    ResourceBundle rb = this.getResourceBundle(record.getLoggerName());
                    if (rb != null) {
                        try {
                            logMessage = MessageFormat.format(rb.getString(logMessage), record.getParameters());
                        }
                        catch (MissingResourceException pw) {
                            // empty catch block
                        }
                    }
                }
                recordBuffer.append(logMessage);
                if (record.getThrown() != null) {
                    recordBuffer.append(LINE_SEPARATOR);
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    recordBuffer.append(sw.toString());
                    sw.close();
                }
            }
            recordBuffer.append(this.getRecordEndMarker() != null ? this.getRecordEndMarker() : RECORD_END_MARKER).append(LINE_SEPARATOR).append(LINE_SEPARATOR);
            return recordBuffer.toString();
        }
        catch (Exception ex) {
            new ErrorManager().error("Error in formatting Logrecord", ex, 5);
            return "";
        }
    }

    private synchronized ResourceBundle getResourceBundle(String loggerName) {
        if (loggerName == null) {
            return null;
        }
        ResourceBundle rb = (ResourceBundle)this.loggerResourceBundleTable.get(loggerName);
        if (rb == null && this.logManager.getLogger(loggerName) != null) {
            rb = this.logManager.getLogger(loggerName).getResourceBundle();
            this.loggerResourceBundleTable.put(loggerName, rb);
        }
        return rb;
    }

    public String getRecordBeginMarker() {
        return this.recordBeginMarker;
    }

    public void setRecordBeginMarker(String recordBeginMarker) {
        this.recordBeginMarker = recordBeginMarker;
    }

    public String getRecordEndMarker() {
        return this.recordEndMarker;
    }

    public void setRecordEndMarker(String recordEndMarker) {
        this.recordEndMarker = recordEndMarker;
    }

    public String getRecordFieldSeparator() {
        return this.recordFieldSeparator;
    }

    public void setRecordFieldSeparator(String recordFieldSeparator) {
        this.recordFieldSeparator = recordFieldSeparator;
    }

    public String getRecordDateFormat() {
        return this.recordDateFormat;
    }

    public void setRecordDateFormat(String recordDateFormat) {
        this.recordDateFormat = recordDateFormat;
    }

    static {
        String recordCount;
        PRODUCTID_CONTEXTID = null;
        version = new Version(false);
        PRODUCT_VERSION = version.getVersion();
        FINE_LEVEL_INT_VALUE = Level.FINE.intValue();
        LOG_SOURCE_IN_KEY_VALUE = false;
        RECORD_NUMBER_IN_KEY_VALUE = false;
        String logSource = System.getProperty("com.sun.aas.logging.keyvalue.logsource");
        if (logSource != null && logSource.equals("true")) {
            LOG_SOURCE_IN_KEY_VALUE = true;
        }
        if ((recordCount = System.getProperty("com.sun.aas.logging.keyvalue.recordnumber")) != null && recordCount.equals("true")) {
            RECORD_NUMBER_IN_KEY_VALUE = true;
        }
        LINE_SEPARATOR = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("line.separator");
            }
        });
        RECORD_END_MARKER = "|#]" + LINE_SEPARATOR;
    }
}

