/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ssl;

import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.integration.AppClientSSL;
import com.sun.enterprise.security.ssl.J2EEKeyManager;
import com.sun.enterprise.server.pluggable.SecuritySupport;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.PropertyPermission;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public final class SSLUtils
implements PostConstruct {
    private static final Logger LOGGER = SecurityLoggerInfo.getLogger();
    public static final String HTTPS_OUTBOUND_KEY_ALIAS = "com.sun.enterprise.security.httpsOutboundKeyAlias";
    private static final String DEFAULT_SSL_PROTOCOL = "TLS";
    @Inject
    private SecuritySupport securitySupport;
    private boolean hasKey;
    private KeyStore mergedTrustStore;
    private AppClientSSL appclientSsl;
    private SSLContext sslContext;

    public void postConstruct() {
        try {
            KeyStore[] keyStores;
            if (this.securitySupport == null) {
                this.securitySupport = SecuritySupport.getDefaultInstance();
            }
            if ((keyStores = this.getKeyStores()) != null) {
                for (KeyStore keyStore : keyStores) {
                    Enumeration<String> aliases = keyStore.aliases();
                    while (aliases.hasMoreElements()) {
                        if (!keyStore.isKeyEntry(aliases.nextElement())) continue;
                        this.hasKey = true;
                        break;
                    }
                    if (this.hasKey) break;
                }
            }
            this.mergedTrustStore = this.mergingTrustStores(this.securitySupport.getTrustStores());
            this.getSSLContext(null, null, null);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "SSLUtils static init fails.", ex);
            throw new IllegalStateException(ex);
        }
    }

    SSLContext getSSLContext(String protocol, String algorithm, String trustAlgorithm) {
        try {
            if (protocol == null) {
                protocol = DEFAULT_SSL_PROTOCOL;
            }
            this.sslContext = SSLContext.getInstance(protocol);
            String keyAlias = System.getProperty(HTTPS_OUTBOUND_KEY_ALIAS);
            KeyManager[] keyManagers = this.getKeyManagers(algorithm);
            if (keyAlias != null && keyAlias.length() > 0 && keyManagers != null) {
                for (int i = 0; i < keyManagers.length; ++i) {
                    keyManagers[i] = new J2EEKeyManager((X509KeyManager)keyManagers[i], keyAlias);
                }
            }
            this.sslContext.init(keyManagers, this.getTrustManagers(trustAlgorithm), null);
            HttpsURLConnection.setDefaultSSLSocketFactory(this.sslContext.getSocketFactory());
            SSLContext.setDefault(this.sslContext);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        return this.sslContext;
    }

    public boolean verifyMasterPassword(char[] masterPass) {
        return this.securitySupport.verifyMasterPassword(masterPass);
    }

    public KeyStore[] getKeyStores() throws IOException {
        return this.securitySupport.getKeyStores();
    }

    public KeyStore getKeyStore() throws IOException {
        return this.getKeyStores()[0];
    }

    public KeyStore[] getTrustStores() throws IOException {
        return this.securitySupport.getTrustStores();
    }

    public KeyStore[] getTrustStore() throws IOException {
        return this.getTrustStores();
    }

    public KeyStore getMergedTrustStore() {
        return this.mergedTrustStore;
    }

    public KeyManager[] getKeyManagers() throws Exception {
        return this.getKeyManagers(null);
    }

    public KeyManager[] getKeyManagers(String algorithm) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.securitySupport.getKeyManagers(algorithm);
    }

    public TrustManager[] getTrustManagers() throws Exception {
        return this.getTrustManagers(null);
    }

    public TrustManager[] getTrustManagers(String algorithm) throws IOException, KeyStoreException, NoSuchAlgorithmException {
        return this.securitySupport.getTrustManagers(algorithm);
    }

    public void setAppclientSsl(AppClientSSL ssl) {
        this.appclientSsl = ssl;
    }

    public AppClientSSL getAppclientSsl() {
        return this.appclientSsl;
    }

    public static String getKeyStoreType() {
        return System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
    }

    public static String getTrustStoreType() {
        return System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
    }

    public boolean isKeyAvailable() {
        return this.hasKey;
    }

    public boolean isTokenKeyAlias(String certNickname) throws Exception {
        boolean isTokenKeyAlias = false;
        if (certNickname != null) {
            int ind = certNickname.indexOf(58);
            KeyStore[] kstores = this.getKeyStores();
            int count = -1;
            String aliasName = null;
            if (ind != -1) {
                String[] tokens = this.securitySupport.getTokenNames();
                String tokenName = certNickname.substring(0, ind);
                aliasName = certNickname.substring(ind + 1);
                for (int i = 0; i < tokens.length; ++i) {
                    if (!tokenName.equals(tokens[i])) continue;
                    count = i;
                }
            }
            if (count != -1) {
                isTokenKeyAlias = kstores[count].isKeyEntry(aliasName);
            } else {
                for (KeyStore kstore : kstores) {
                    if (!kstore.isKeyEntry(certNickname)) continue;
                    isTokenKeyAlias = true;
                    break;
                }
            }
        }
        return isTokenKeyAlias;
    }

    public KeyStore.PrivateKeyEntry getPrivateKeyEntryFromTokenAlias(String certNickname) throws Exception {
        KeyStore.PrivateKeyEntry privKeyEntry;
        block3: {
            String aliasName;
            KeyStore[] kstores;
            block4: {
                SSLUtils.checkPermission("javax.net.ssl.keyStorePassword");
                privKeyEntry = null;
                if (certNickname == null) break block3;
                int ind = certNickname.indexOf(58);
                kstores = this.getKeyStores();
                int count = -1;
                aliasName = certNickname;
                if (ind != -1) {
                    String[] tokens = this.securitySupport.getTokenNames();
                    String tokenName = certNickname.substring(0, ind);
                    aliasName = certNickname.substring(ind + 1);
                    for (int i = 0; i < tokens.length; ++i) {
                        if (!tokenName.equals(tokens[i])) continue;
                        count = i;
                    }
                }
                if (count == -1 || kstores.length < count) break block4;
                PrivateKey privKey = this.securitySupport.getPrivateKeyForAlias(aliasName, count);
                if (privKey == null) break block3;
                Certificate[] certs = kstores[count].getCertificateChain(aliasName);
                privKeyEntry = new KeyStore.PrivateKeyEntry(privKey, certs);
                break block3;
            }
            for (int i = 0; i < kstores.length; ++i) {
                PrivateKey privKey = this.securitySupport.getPrivateKeyForAlias(aliasName, i);
                if (privKey == null) continue;
                Certificate[] certs = kstores[i].getCertificateChain(aliasName);
                privKeyEntry = new KeyStore.PrivateKeyEntry(privKey, certs);
                break;
            }
        }
        return privKeyEntry;
    }

    public static void checkPermission(String key) {
        try {
            if (Util.isEmbeddedServer() || Globals.getDefaultHabitat() == null || Util.getInstance().isACC() || Util.getInstance().isNotServerOrACC()) {
                return;
            }
            AccessController.checkPermission(new RuntimePermission("SSLPassword"));
        }
        catch (AccessControlException e) {
            String message = e.getMessage();
            PropertyPermission permission = new PropertyPermission(key, "read");
            if (message != null) {
                message = message.replace(e.getPermission().toString(), permission.toString());
            }
            throw new AccessControlException(message, permission);
        }
    }

    public String[] getSupportedCipherSuites() {
        return HttpsURLConnection.getDefaultSSLSocketFactory().getSupportedCipherSuites();
    }

    private KeyStore mergingTrustStores(KeyStore[] trustStores) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore mergedStore;
        try {
            mergedStore = this.securitySupport.loadNullStore("CaseExactJKS", 0);
        }
        catch (KeyStoreException ex) {
            mergedStore = this.securitySupport.loadNullStore("JKS", 0);
        }
        String[] tokens = this.securitySupport.getTokenNames();
        for (int i = 0; i < trustStores.length; ++i) {
            Enumeration<String> aliases = trustStores[i].aliases();
            while (aliases.hasMoreElements()) {
                Certificate aCert;
                String alias2;
                String alias = aliases.nextElement();
                Certificate cert = trustStores[i].getCertificate(alias);
                String alias3 = alias2 = i < tokens.length - 1 ? tokens[i] + ":" + alias : alias;
                boolean alreadyInStore = false;
                int count = 1;
                while ((aCert = mergedStore.getCertificate(alias3)) != null) {
                    if (aCert.equals(cert)) {
                        alreadyInStore = true;
                        break;
                    }
                    alias3 = alias2 + "__" + count++;
                }
                if (alreadyInStore) continue;
                mergedStore.setCertificateEntry(alias3, cert);
            }
        }
        return mergedStore;
    }

    public SSLSocketFactory getAdminSocketFactory(String alias, String protocol) {
        return this.getAdminSSLContext(alias, protocol).getSocketFactory();
    }

    public SSLContext getAdminSSLContext(String alias, String protocol) {
        try {
            if (protocol == null) {
                protocol = DEFAULT_SSL_PROTOCOL;
            }
            SSLContext adminSSLContextxt = SSLContext.getInstance(protocol);
            KeyManager[] keyManagers = this.getKeyManagers();
            if (alias != null && alias.length() > 0 && keyManagers != null) {
                for (int i = 0; i < keyManagers.length; ++i) {
                    keyManagers[i] = new J2EEKeyManager((X509KeyManager)keyManagers[i], alias);
                }
            }
            adminSSLContextxt.init(keyManagers, this.getTrustManagers(), null);
            return adminSSLContextxt;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

