/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.concurrent;

import java.util.AbstractQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.enterprise.concurrent.ManagedExecutorService;
import org.glassfish.enterprise.concurrent.AbstractManagedExecutorService;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedExecutorServiceAdapter;
import org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl;
import org.glassfish.enterprise.concurrent.internal.ManagedExecutor;
import org.glassfish.enterprise.concurrent.internal.ManagedForkJoinPool;
import org.glassfish.enterprise.concurrent.internal.ManagedFutureTask;
import org.glassfish.enterprise.concurrent.internal.ManagedThreadPoolExecutor;

public class ManagedExecutorServiceImpl
extends AbstractManagedExecutorService {
    protected final ManagedExecutor executor;
    protected final ManagedExecutorServiceAdapter adapter;

    public ManagedExecutorServiceImpl(String name, ManagedThreadFactoryImpl managedThreadFactory, long hungTaskThreshold, boolean longRunningTasks, boolean useForkJoinPool, int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, long threadLifeTime, ContextServiceImpl contextService, AbstractManagedExecutorService.RejectPolicy rejectPolicy, BlockingQueue<Runnable> queue) {
        super(name, managedThreadFactory, hungTaskThreshold, longRunningTasks, contextService, contextService != null ? contextService.getContextSetupProvider() : null, rejectPolicy);
        if (useForkJoinPool) {
            this.executor = new ManagedForkJoinPool();
        } else {
            this.executor = new ManagedThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, keepAliveTimeUnit, queue, (ThreadFactory)((Object)this.managedThreadFactory));
            ((ManagedThreadPoolExecutor)this.executor).setThreadLifeTime(threadLifeTime);
        }
        this.adapter = new ManagedExecutorServiceAdapter(this);
    }

    public ManagedExecutorServiceImpl(String name, ManagedThreadFactoryImpl managedThreadFactory, long hungTaskThreshold, boolean longRunningTasks, boolean useForkJoinPool, int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, long threadLifeTime, int queueCapacity, ContextServiceImpl contextService, AbstractManagedExecutorService.RejectPolicy rejectPolicy) {
        this(name, managedThreadFactory, hungTaskThreshold, longRunningTasks, useForkJoinPool, corePoolSize, maxPoolSize, keepAliveTime, keepAliveTimeUnit, threadLifeTime, contextService, rejectPolicy, ManagedExecutorServiceImpl.createQueue(queueCapacity, corePoolSize));
    }

    private static BlockingQueue<Runnable> createQueue(int queueCapacity, int corePoolSize) {
        if (queueCapacity < 0) {
            throw new IllegalArgumentException();
        }
        AbstractQueue queue = queueCapacity == Integer.MAX_VALUE ? (corePoolSize == 0 ? new SynchronousQueue() : new LinkedBlockingQueue()) : (queueCapacity == 0 ? new SynchronousQueue() : new ArrayBlockingQueue(queueCapacity));
        return queue;
    }

    @Override
    public void execute(Runnable command) {
        ManagedFutureTask<Object> task = this.getNewTaskFor(command, null);
        task.submitted();
        ((ExecutorService)((Object)this.executor)).execute(task);
    }

    public ManagedExecutorServiceAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    protected ExecutorService getExecutor() {
        return (ExecutorService)((Object)this.executor);
    }

    @Override
    public ManagedExecutorService getExecutorForTaskListener() {
        return this.adapter;
    }

    @Override
    protected <V> ManagedFutureTask<V> getNewTaskFor(Runnable r, V result) {
        return new ManagedFutureTask<V>(this, r, result);
    }

    protected ManagedFutureTask getNewTaskFor(Callable callable) {
        return new ManagedFutureTask(this, callable);
    }

    @Override
    public long getTaskCount() {
        return this.executor.getTaskCount();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.executor.getCompletedTaskCount();
    }

    @Override
    public int getCorePoolSize() {
        return this.executor.getCorePoolSize();
    }

    @Override
    public int getActiveCount() {
        return this.executor.getActiveCount();
    }

    @Override
    public long getKeepAliveTime() {
        return this.executor.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    @Override
    public int getLargestPoolSize() {
        return this.executor.getLargestPoolSize();
    }

    @Override
    public int getMaximumPoolSize() {
        return this.executor.getMaximumPoolSize();
    }

    @Override
    public int getPoolSize() {
        return this.executor.getPoolSize();
    }

    @Override
    public BlockingQueue getBlockingQueue() {
        return this.executor.getQueue();
    }

    @Override
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.executor.getRejectedExecutionHandler();
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.executor.getThreadFactory();
    }
}

