/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer;

import com.sun.enterprise.util.JDK;
import com.sun.jdo.api.persistence.enhancer.Resource;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessControlContext;

public class URLClassPath {
    private static final String URL_CLASSPATH_CLASS_NAME = JDK.getMajor() > 8 ? "jdk.internal.loader.URLClassPath" : "sun.misc.URLClassPath";
    private static Constructor constructor;
    private static final String GET_RESOURCE_METHOD_NAME = "getResource";
    private static Method getResource;
    private Object instance;

    public URLClassPath(URL[] urls, AccessControlContext acc) {
        try {
            if (constructor == null) {
                Class<?> clazz = Class.forName(URL_CLASSPATH_CLASS_NAME);
                constructor = clazz.getConstructor(URL[].class, AccessControlContext.class);
            }
            this.instance = constructor.newInstance(urls, acc);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    Resource getResource(String name, boolean check) {
        if (getResource == null) {
            getResource = URLClassPath.getMethod(this.instance, GET_RESOURCE_METHOD_NAME, String.class, Boolean.TYPE);
        }
        return new Resource(URLClassPath.invoke(this.instance, getResource, name, check));
    }

    static Method getMethod(Object instance, String name, Class<?> ... parameterTypes) {
        try {
            return instance.getClass().getMethod(name, parameterTypes);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static Object invoke(Object instance, Method method, Object ... args) {
        try {
            return method.invoke(instance, args);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

