/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.opentracing;

import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.opentracing.tracer.Tracer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.interceptor.InvocationContext;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Service;

@Service(name="opentracing-service")
public class OpenTracingService
implements EventListener {
    private static final Map<String, io.opentracing.Tracer> tracers = new ConcurrentHashMap<String, io.opentracing.Tracer>();
    public static final String PAYARA_CORBA_RMI_TRACER_NAME = "__PAYARA_CORBA_RMI";
    private static final Logger logger = Logger.getLogger(OpenTracingService.class.getName());
    private RequestTracingService requestTracingService;

    @PostConstruct
    void postConstruct() {
        Events events = this.getFromServiceHandle(Globals.getDefaultBaseServiceLocator(), Events.class);
        if (events != null) {
            events.register((EventListener)this);
        } else {
            logger.log(Level.WARNING, "OpenTracing service not registered to Payara Events: The Tracer for an application won't be removed upon undeployment");
        }
        this.getRequestTracingService();
    }

    public void event(EventListener.Event<?> event) {
        ApplicationInfo info;
        if (event.is(Deployment.APPLICATION_LOADED) && this.getRequestTracingService() != null && this.requestTracingService.isRequestTracingEnabled()) {
            info = (ApplicationInfo)event.hook();
            this.createTracer(info.getName());
        }
        if (event.is(Deployment.APPLICATION_UNLOADED)) {
            info = (ApplicationInfo)event.hook();
            tracers.remove(info.getName());
        }
    }

    public io.opentracing.Tracer getTracer(String applicationName) {
        if (applicationName == null) {
            return null;
        }
        io.opentracing.Tracer tracer = tracers.get(applicationName);
        if (tracer == null) {
            tracer = this.createTracer(applicationName);
        }
        return tracer;
    }

    private synchronized io.opentracing.Tracer createTracer(String applicationName) {
        io.opentracing.Tracer tracer = tracers.computeIfAbsent(applicationName, appName -> {
            io.opentracing.Tracer newTracer = null;
            try {
                ServiceLoader<io.opentracing.Tracer> tracerLoader = ServiceLoader.load(io.opentracing.Tracer.class);
                Iterator<io.opentracing.Tracer> loadedTracer = tracerLoader.iterator();
                if (loadedTracer.hasNext()) {
                    newTracer = loadedTracer.next();
                }
            }
            catch (NoClassDefFoundError ex) {
                logger.log(Level.SEVERE, "Unable to find Tracer implementation", ex);
            }
            if (newTracer == null) {
                newTracer = new Tracer((String)appName, this.getRequestTracingService());
            }
            return newTracer;
        });
        return tracer;
    }

    public boolean isEnabled() {
        if (this.getRequestTracingService() != null) {
            return this.requestTracingService.isRequestTracingEnabled();
        }
        return false;
    }

    private RequestTracingService getRequestTracingService() {
        if (this.requestTracingService == null) {
            this.requestTracingService = this.getFromServiceHandle(Globals.getDefaultBaseServiceLocator(), RequestTracingService.class);
        }
        return this.requestTracingService;
    }

    public String getApplicationName(InvocationManager invocationManager) {
        ApplicationRegistry applicationRegistry;
        ComponentInvocation invocation = invocationManager.getCurrentInvocation();
        if (invocation == null) {
            return null;
        }
        String appName = invocation.getAppName();
        if (appName == null && (appName = invocation.getModuleName()) == null && (appName = invocation.getComponentId()) != null && (applicationRegistry = (ApplicationRegistry)Globals.getDefaultBaseServiceLocator().getService(ApplicationRegistry.class, new Annotation[0])).get(appName) == null) {
            String[] componentIds = appName.split("_/");
            appName = componentIds[0];
        }
        return appName;
    }

    public String getApplicationName(InvocationManager invocationManager, InvocationContext invocationContext) {
        String appName = invocationManager.getCurrentInvocation().getAppName();
        if (appName == null && (appName = invocationManager.getCurrentInvocation().getModuleName()) == null && (appName = invocationManager.getCurrentInvocation().getComponentId()) == null && invocationContext != null) {
            appName = this.getFullMethodSignature(invocationContext.getMethod());
        }
        return appName;
    }

    private String getFullMethodSignature(Method annotatedMethod) {
        return annotatedMethod.getDeclaringClass().getCanonicalName() + "#" + annotatedMethod.getName() + "(" + Arrays.toString(annotatedMethod.getParameterTypes()) + ")>" + annotatedMethod.getReturnType().getSimpleName();
    }

    private <T> T getFromServiceHandle(ServiceLocator serviceLocator, Class<T> serviceClass) {
        ServiceHandle serviceHandle;
        if (serviceLocator != null && (serviceHandle = serviceLocator.getServiceHandle(serviceClass, new Annotation[0])) != null && serviceHandle.isActive()) {
            return (T)serviceHandle.getService();
        }
        return null;
    }
}

