/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.gf.ejb.internal;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import java.io.Externalizable;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Singleton;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.jersey.gf.ejb.internal.EjbComponentInterceptor;
import org.glassfish.jersey.gf.ejb.internal.EjbExceptionMapper;
import org.glassfish.jersey.gf.ejb.internal.LocalizationMessages;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.Bindings;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.spi.ComponentProvider;
import org.glassfish.jersey.server.spi.internal.ResourceMethodInvocationHandlerProvider;

@Priority(value=300)
public final class EjbComponentProvider
implements ComponentProvider,
ResourceMethodInvocationHandlerProvider {
    private static final Logger LOGGER = Logger.getLogger(EjbComponentProvider.class.getName());
    private InitialContext initialContext;
    private final List<String> libNames = new CopyOnWriteArrayList<String>();
    private boolean ejbInterceptorRegistered = false;
    private static final Set<String> EjbComponentAnnotations = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("javax.ejb.Stateful");
            this.add("javax.ejb.Stateless");
            this.add("javax.ejb.Singleton");
        }
    });
    private InjectionManager injectionManager = null;

    public void initialize(InjectionManager injectionManager) {
        this.injectionManager = injectionManager;
        InstanceBinding descriptor = (InstanceBinding)Bindings.service((Object)this).to(ResourceMethodInvocationHandlerProvider.class);
        this.injectionManager.register((Binding)descriptor);
    }

    private ApplicationInfo getApplicationInfo(EjbContainerUtil ejbUtil) throws NamingException {
        ApplicationRegistry appRegistry = (ApplicationRegistry)ejbUtil.getServices().getService(ApplicationRegistry.class, new Annotation[0]);
        Applications applications = (Applications)ejbUtil.getServices().getService(Applications.class, new Annotation[0]);
        String appNamePrefix = (String)this.initialContext.lookup("java:app/AppName");
        Set appNames = appRegistry.getAllApplicationNames();
        TreeSet<String> disabledApps = new TreeSet<String>();
        for (String appName : appNames) {
            if (!appName.startsWith(appNamePrefix)) continue;
            Application appDesc = applications.getApplication(appName);
            if (appDesc != null && !ejbUtil.getDeployment().isAppEnabled(appDesc)) {
                disabledApps.add(appName);
                continue;
            }
            return ejbUtil.getDeployment().get(appName);
        }
        Iterator it = disabledApps.iterator();
        String lastDisabledApp = null;
        while (it.hasNext()) {
            lastDisabledApp = (String)it.next();
        }
        if (lastDisabledApp != null) {
            return ejbUtil.getDeployment().get(lastDisabledApp);
        }
        throw new NamingException("Application Information Not Found");
    }

    private void registerEjbInterceptor(Class<?> component) {
        try {
            final EjbComponentInterceptor interceptor = new EjbComponentInterceptor(this.injectionManager);
            this.initialContext = EjbComponentProvider.getInitialContext();
            EjbContainerUtil ejbUtil = EjbContainerUtilImpl.getInstance();
            ApplicationInfo appInfo = this.getApplicationInfo(ejbUtil);
            for (ModuleInfo moduleInfo : appInfo.getModuleInfos()) {
                String jarName = moduleInfo.getName();
                if (!jarName.endsWith(".jar") && !jarName.endsWith(".war")) continue;
                String moduleName = jarName.substring(0, jarName.length() - 4);
                Object bundleDescriptor = moduleInfo.getMetaData(EjbBundleDescriptorImpl.class.getName());
                if (!(bundleDescriptor instanceof EjbBundleDescriptorImpl)) continue;
                Set ejbs = ((EjbBundleDescriptorImpl)bundleDescriptor).getEjbs();
                for (EjbDescriptor ejb : ejbs) {
                    final BaseContainer ejbContainer = EjbContainerUtilImpl.getInstance().getContainer(ejb.getUniqueId());
                    if (ejbContainer.getEJBClass() != component) continue;
                    this.libNames.add(moduleName);
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                Method registerInterceptorMethod = BaseContainer.class.getDeclaredMethod("registerSystemInterceptor", Object.class);
                                registerInterceptorMethod.setAccessible(true);
                                registerInterceptorMethod.invoke((Object)ejbContainer, interceptor);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        Throwable cause = pae.getCause();
                        LOGGER.log(Level.WARNING, LocalizationMessages.EJB_INTERCEPTOR_BINDING_WARNING(ejb.getEjbClassName()), cause);
                    }
                }
            }
            final Object interceptorBinder = this.initialContext.lookup("java:org.glassfish.ejb.container.interceptor_binding_spi");
            if (interceptorBinder == null) {
                throw new IllegalStateException(LocalizationMessages.EJB_INTERCEPTOR_BIND_API_NOT_AVAILABLE());
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Method interceptorBinderMethod = interceptorBinder.getClass().getMethod("registerInterceptor", Object.class);
                        interceptorBinderMethod.invoke(interceptorBinder, interceptor);
                        EjbComponentProvider.this.ejbInterceptorRegistered = true;
                        LOGGER.log(Level.CONFIG, LocalizationMessages.EJB_INTERCEPTOR_BOUND());
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw new IllegalStateException(LocalizationMessages.EJB_INTERCEPTOR_CONFIG_ERROR(), pae.getCause());
            }
        }
        catch (NamingException ex) {
            throw new IllegalStateException(LocalizationMessages.EJB_INTERCEPTOR_BIND_API_NOT_AVAILABLE(), ex);
        }
        catch (LinkageError ex) {
            throw new IllegalStateException(LocalizationMessages.EJB_INTERCEPTOR_CONFIG_LINKAGE_ERROR(), ex);
        }
    }

    public boolean bind(Class<?> component, Set<Class<?>> providerContracts) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(LocalizationMessages.EJB_CLASS_BEING_CHECKED(component));
        }
        if (this.injectionManager == null) {
            throw new IllegalStateException(LocalizationMessages.EJB_COMPONENT_PROVIDER_NOT_INITIALIZED_PROPERLY());
        }
        if (!this.isEjbComponent(component)) {
            return false;
        }
        if (!this.ejbInterceptorRegistered) {
            this.registerEjbInterceptor(component);
        }
        Binding binding = Bindings.supplier(new EjbFactory(component, this.initialContext, this)).to(component).to(providerContracts);
        this.injectionManager.register(binding);
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config(LocalizationMessages.EJB_CLASS_BOUND_WITH_CDI(component));
        }
        return true;
    }

    public void done() {
        this.registerEjbExceptionMapper();
    }

    private void registerEjbExceptionMapper() {
        this.injectionManager.register((Binder)new AbstractBinder(){

            protected void configure() {
                ((ClassBinding)this.bind(EjbExceptionMapper.class).to(ExceptionMapper.class)).in(javax.inject.Singleton.class);
            }
        });
    }

    private boolean isEjbComponent(Class<?> component) {
        for (Annotation a : component.getAnnotations()) {
            if (!EjbComponentAnnotations.contains(a.annotationType().getName())) continue;
            return true;
        }
        return false;
    }

    public InvocationHandler create(Invocable method) {
        Class resourceClass = method.getHandler().getHandlerClass();
        if (resourceClass == null || !this.isEjbComponent(resourceClass)) {
            return null;
        }
        Method handlingMethod = method.getDefinitionMethod();
        for (Class iFace : EjbComponentProvider.remoteAndLocalIfaces(resourceClass)) {
            try {
                final Method iFaceMethod = iFace.getDeclaredMethod(handlingMethod.getName(), handlingMethod.getParameterTypes());
                if (iFaceMethod == null) continue;
                return new InvocationHandler(){

                    @Override
                    public Object invoke(Object target, Method ignored, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                        return iFaceMethod.invoke(target, args);
                    }
                };
            }
            catch (NoSuchMethodException | SecurityException ex) {
                this.logLookupException(handlingMethod, resourceClass, iFace, ex);
            }
        }
        return null;
    }

    private void logLookupException(Method method, Class<?> component, Class<?> iFace, Exception ex) {
        LOGGER.log(Level.WARNING, LocalizationMessages.EJB_INTERFACE_HANDLING_METHOD_LOOKUP_EXCEPTION(method, component, iFace), ex);
    }

    private static List<Class> remoteAndLocalIfaces(Class<?> resourceClass) {
        LinkedList<Class> allLocalOrRemoteIfaces = new LinkedList<Class>();
        if (resourceClass.isAnnotationPresent(Remote.class)) {
            allLocalOrRemoteIfaces.addAll(Arrays.asList(resourceClass.getAnnotation(Remote.class).value()));
        }
        if (resourceClass.isAnnotationPresent(Local.class)) {
            allLocalOrRemoteIfaces.addAll(Arrays.asList(resourceClass.getAnnotation(Local.class).value()));
        }
        for (Class<?> i : resourceClass.getInterfaces()) {
            if (!i.isAnnotationPresent(Remote.class) && !i.isAnnotationPresent(Local.class)) continue;
            allLocalOrRemoteIfaces.add(i);
        }
        if (allLocalOrRemoteIfaces.isEmpty()) {
            for (Class<?> i : resourceClass.getInterfaces()) {
                if (!EjbComponentProvider.isAcceptableLocalInterface(i)) continue;
                allLocalOrRemoteIfaces.add(i);
            }
        }
        return allLocalOrRemoteIfaces;
    }

    private static boolean isAcceptableLocalInterface(Class<?> iface) {
        if ("javax.ejb".equals(iface.getPackage().getName())) {
            return false;
        }
        return !Serializable.class.equals(iface) && !Externalizable.class.equals(iface);
    }

    private static InitialContext getInitialContext() {
        try {
            return new InitialContext();
        }
        catch (Exception ex) {
            throw new IllegalStateException(LocalizationMessages.INITIAL_CONTEXT_NOT_AVAILABLE(), ex);
        }
    }

    private static Object lookup(InitialContext ic, Class<?> rawType, String name, EjbComponentProvider provider) throws NamingException {
        try {
            return EjbComponentProvider.lookupSimpleForm(ic, rawType, name, provider);
        }
        catch (NamingException ex) {
            LOGGER.log(Level.WARNING, LocalizationMessages.EJB_CLASS_SIMPLE_LOOKUP_FAILED(rawType.getName()), ex);
            return EjbComponentProvider.lookupFullyQualifiedForm(ic, rawType, name, provider);
        }
    }

    private static Object lookupSimpleForm(InitialContext ic, Class<?> rawType, String name, EjbComponentProvider provider) throws NamingException {
        if (provider.libNames.isEmpty()) {
            String jndiName = "java:module/" + name;
            return ic.lookup(jndiName);
        }
        NamingException ne = null;
        for (String moduleName : provider.libNames) {
            String jndiName = "java:app/" + moduleName + "/" + name;
            try {
                Object result = ic.lookup(jndiName);
                if (result == null || !EjbComponentProvider.isLookupInstanceValid(rawType, result)) continue;
                return result;
            }
            catch (NamingException e) {
                ne = e;
            }
        }
        throw ne != null ? ne : new NamingException();
    }

    private static Object lookupFullyQualifiedForm(InitialContext ic, Class<?> rawType, String name, EjbComponentProvider provider) throws NamingException {
        if (provider.libNames.isEmpty()) {
            String jndiName = "java:module/" + name + "!" + rawType.getName();
            return ic.lookup(jndiName);
        }
        NamingException ne = null;
        for (String moduleName : provider.libNames) {
            String jndiName = "java:app/" + moduleName + "/" + name + "!" + rawType.getName();
            try {
                Object result = ic.lookup(jndiName);
                if (result == null || !EjbComponentProvider.isLookupInstanceValid(rawType, result)) continue;
                return result;
            }
            catch (NamingException e) {
                ne = e;
            }
        }
        throw ne != null ? ne : new NamingException();
    }

    private static boolean isLookupInstanceValid(Class<?> rawType, Object result) {
        return rawType.isInstance(result) || EjbComponentProvider.remoteAndLocalIfaces(rawType).stream().filter(iface -> iface.isInstance(result)).findAny().isPresent();
    }

    private static class EjbFactory<T>
    implements Supplier<T> {
        final InitialContext ctx;
        final Class<T> clazz;
        final String beanName;
        final EjbComponentProvider ejbProvider;

        @Override
        public T get() {
            try {
                return (T)EjbComponentProvider.lookup(this.ctx, this.clazz, this.beanName, this.ejbProvider);
            }
            catch (NamingException ex) {
                Logger.getLogger(ApplicationHandler.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }

        private static <T> String getBeanName(Class<T> clazz) {
            Stateless stateless = clazz.getAnnotation(Stateless.class);
            if (stateless != null) {
                if (stateless.name().isEmpty()) {
                    return clazz.getSimpleName();
                }
                return stateless.name();
            }
            Singleton singleton = clazz.getAnnotation(Singleton.class);
            if (singleton != null) {
                if (singleton.name().isEmpty()) {
                    return clazz.getSimpleName();
                }
                return singleton.name();
            }
            return clazz.getSimpleName();
        }

        public EjbFactory(Class<T> rawType, InitialContext ctx, EjbComponentProvider ejbProvider) {
            this.clazz = rawType;
            this.ctx = ctx;
            this.ejbProvider = ejbProvider;
            this.beanName = EjbFactory.getBeanName(rawType);
        }
    }
}

