/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.scan.index;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.exec.scan.KeyValueIterator;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.schema.map.MapTableUtils;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Iterator;
import java.util.List;

public class MapIndexScanExecIterator
implements KeyValueIterator {
    private final Iterator<QueryableEntry> iterator;
    private Object currentKey;
    private Data currentKeyData;
    private Object currentValue;
    private Data currentValueData;
    private Object nextKey;
    private Data nextKeyData;
    private Object nextValue;
    private Data nextValueData;

    public MapIndexScanExecIterator(String mapName, InternalIndex index, int expectedComponentCount, IndexFilter indexFilter, List<Boolean> ascs, List<QueryDataType> expectedConverterTypes, ExpressionEvalContext evalContext) {
        this.iterator = this.getIndexEntries(mapName, index, indexFilter, ascs, evalContext, expectedComponentCount, expectedConverterTypes);
        this.advance0();
    }

    @Override
    public boolean tryAdvance() {
        if (!this.done()) {
            this.currentKey = this.nextKey;
            this.currentKeyData = this.nextKeyData;
            this.currentValue = this.nextValue;
            this.currentValueData = this.nextValueData;
            this.advance0();
            return true;
        }
        return false;
    }

    @Override
    public boolean done() {
        return this.nextKeyData == null;
    }

    @Override
    public Object getKey() {
        return this.currentKey;
    }

    @Override
    public Data getKeyData() {
        return this.currentKeyData;
    }

    @Override
    public Object getValue() {
        return this.currentValue;
    }

    @Override
    public Data getValueData() {
        return this.currentValueData;
    }

    private void advance0() {
        if (this.iterator.hasNext()) {
            QueryableEntry entry = this.iterator.next();
            this.nextKey = entry.getKeyIfPresent();
            this.nextKeyData = entry.getKeyDataIfPresent();
            this.nextValue = entry.getValueIfPresent();
            this.nextValueData = entry.getValueDataIfPresent();
        } else {
            this.nextKey = null;
            this.nextKeyData = null;
            this.nextValue = null;
            this.nextValueData = null;
        }
    }

    private Iterator<QueryableEntry> getIndexEntries(String mapName, InternalIndex index, IndexFilter indexFilter, List<Boolean> ascs, ExpressionEvalContext evalContext, int expectedComponentCount, List<QueryDataType> expectedConverterTypes) {
        boolean descending;
        assert (ascs != null);
        boolean bl = descending = ascs.size() > 0 && ascs.get(0) == false;
        if (indexFilter == null) {
            return index.getSqlRecordIterator(descending);
        }
        int actualComponentCount = index.getComponents().length;
        if (actualComponentCount != expectedComponentCount) {
            throw QueryException.error(1009, "Cannot use the index \"" + index.getName() + "\" of the IMap \"" + mapName + "\" because it has " + actualComponentCount + " component(s), but " + expectedComponentCount + " expected").markInvalidate();
        }
        List<QueryDataType> currentConverterTypes = MapTableUtils.indexConverterToSqlTypes(index.getConverter());
        this.validateConverterTypes(index, mapName, expectedConverterTypes, currentConverterTypes);
        return indexFilter.getEntries(index, descending, evalContext);
    }

    private void validateConverterTypes(InternalIndex index, String mapName, List<QueryDataType> expectedConverterTypes, List<QueryDataType> actualConverterTypes) {
        for (int i = 0; i < Math.min(expectedConverterTypes.size(), actualConverterTypes.size()); ++i) {
            QueryDataType actual;
            QueryDataType expected = expectedConverterTypes.get(i);
            if (expected.equals(actual = actualConverterTypes.get(i))) continue;
            String component = index.getComponents()[i];
            throw QueryException.error(1009, "Cannot use the index \"" + index.getName() + "\" of the IMap \"" + mapName + "\" because it has component \"" + component + "\" of type " + (Object)((Object)actual.getTypeFamily()) + ", but " + (Object)((Object)expected.getTypeFamily()) + " was expected").markInvalidate();
        }
        if (expectedConverterTypes.size() > actualConverterTypes.size()) {
            QueryDataType expected = expectedConverterTypes.get(actualConverterTypes.size());
            String component = index.getComponents()[actualConverterTypes.size()];
            throw QueryException.error(1009, "Cannot use the index \"" + index.getName() + "\" of the IMap \"" + mapName + "\" because it does not have suitable converter for component \"" + component + "\" (expected " + (Object)((Object)expected.getTypeFamily()) + ")").markInvalidate();
        }
    }
}

