/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.CloseReason;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.ICloseType;
import org.glassfish.grizzly.OutputSink;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http2.DefaultInputBuffer;
import org.glassfish.grizzly.http2.DefaultOutputSink;
import org.glassfish.grizzly.http2.Http2Session;
import org.glassfish.grizzly.http2.Http2SessionException;
import org.glassfish.grizzly.http2.Http2StreamException;
import org.glassfish.grizzly.http2.StreamInputBuffer;
import org.glassfish.grizzly.http2.StreamOutputSink;
import org.glassfish.grizzly.http2.Termination;
import org.glassfish.grizzly.http2.UpgradeInputBuffer;
import org.glassfish.grizzly.http2.UpgradeOutputSink;
import org.glassfish.grizzly.http2.frames.ErrorCode;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.utils.Futures;

public class Http2Stream
implements AttributeStorage,
OutputSink,
Closeable {
    private static final Logger LOGGER = Grizzly.logger(Http2Stream.class);
    public static final String HTTP2_STREAM_ATTRIBUTE = "@RoA." + Http2Stream.class.getName();
    public static final String HTTP2_PARENT_STREAM_ATTRIBUTE = "@RoA.parent." + Http2Stream.class.getName();
    static final int UPGRADE_STREAM_ID = 1;
    private static final Attribute<Http2Stream> HTTP_RQST_HTTP2_STREAM_ATTR = AttributeBuilder.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("http2.request.stream");
    State state = State.IDLE;
    private final HttpRequestPacket request;
    private final int streamId;
    private final int parentStreamId;
    private final int priority;
    private final boolean exclusive;
    private final Http2Session http2Session;
    private final AttributeHolder attributes = AttributeBuilder.DEFAULT_ATTRIBUTE_BUILDER.createSafeAttributeHolder();
    final StreamInputBuffer inputBuffer;
    final StreamOutputSink outputSink;
    static final AtomicIntegerFieldUpdater<Http2Stream> unackedReadBytesUpdater = AtomicIntegerFieldUpdater.newUpdater(Http2Stream.class, "unackedReadBytes");
    private volatile int unackedReadBytes;
    private static final AtomicReferenceFieldUpdater<Http2Stream, CloseReason> closeReasonUpdater = AtomicReferenceFieldUpdater.newUpdater(Http2Stream.class, CloseReason.class, "closeReason");
    private volatile CloseReason closeReason;
    private volatile GrizzlyFuture<CloseReason> closeFuture;
    private final Queue<CloseListener> closeListeners = new ConcurrentLinkedQueue<CloseListener>();
    private static final AtomicIntegerFieldUpdater<Http2Stream> completeFinalizationCounterUpdater = AtomicIntegerFieldUpdater.newUpdater(Http2Stream.class, "completeFinalizationCounter");
    private volatile int completeFinalizationCounter;
    volatile boolean isProcessingComplete;
    private int inboundHeaderFramesCounter;
    private Buffer cachedInputBuffer;
    private boolean cachedIsLast;

    public static Http2Stream getStreamFor(HttpHeader httpHeader) {
        HttpRequestPacket request;
        if (httpHeader.isRequest()) {
            assert (httpHeader instanceof HttpRequestPacket);
            request = (HttpRequestPacket)httpHeader;
        } else {
            assert (httpHeader instanceof HttpResponsePacket);
            request = ((HttpResponsePacket)httpHeader).getRequest();
        }
        if (request != null) {
            return HTTP_RQST_HTTP2_STREAM_ATTR.get(request);
        }
        return null;
    }

    protected Http2Stream(Http2Session http2Session, HttpRequestPacket request, int streamId, int parentStreamId, boolean exclusive, int priority) {
        this.http2Session = http2Session;
        this.request = request;
        this.streamId = streamId;
        this.parentStreamId = parentStreamId;
        this.exclusive = exclusive;
        this.priority = priority;
        this.state = State.IDLE;
        this.inputBuffer = new DefaultInputBuffer(this);
        this.outputSink = new DefaultOutputSink(this);
        HTTP_RQST_HTTP2_STREAM_ATTR.set(request, this);
    }

    protected Http2Stream(Http2Session http2Session, HttpRequestPacket request, int priority) {
        this.http2Session = http2Session;
        this.request = request;
        this.streamId = 1;
        this.parentStreamId = 0;
        this.priority = priority;
        this.exclusive = false;
        this.inputBuffer = http2Session.isServer() ? new UpgradeInputBuffer(this) : new DefaultInputBuffer(this);
        this.outputSink = http2Session.isServer() ? new DefaultOutputSink(this) : new UpgradeOutputSink(http2Session);
        HTTP_RQST_HTTP2_STREAM_ATTR.set(request, this);
    }

    Http2Session getHttp2Session() {
        return this.http2Session;
    }

    public int getPeerWindowSize() {
        return this.http2Session.getPeerStreamWindowSize();
    }

    public int getLocalWindowSize() {
        return this.http2Session.getLocalStreamWindowSize();
    }

    public int getUnflushedWritesCount() {
        return this.outputSink.getUnflushedWritesCount();
    }

    public HttpRequestPacket getRequest() {
        return this.request;
    }

    public HttpResponsePacket getResponse() {
        return this.request.getResponse();
    }

    public boolean isPushEnabled() {
        return this.http2Session.isPushEnabled();
    }

    public int getId() {
        return this.streamId;
    }

    public int getParentStreamId() {
        return this.parentStreamId;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isPushStream() {
        return (this.streamId & 1) == 0;
    }

    public boolean isLocallyInitiatedStream() {
        return this.http2Session.isLocallyInitiatedStream(this.streamId);
    }

    @Override
    public boolean isOpen() {
        return this.completeFinalizationCounter < 2;
    }

    @Override
    public void assertOpen() throws IOException {
        if (!this.isOpen()) {
            CloseReason cr = this.closeReason;
            assert (cr != null);
            throw new IOException("closed", cr.getCause());
        }
    }

    @Override
    public AttributeHolder getAttributes() {
        return this.attributes;
    }

    @Override
    @Deprecated
    public boolean canWrite(int length) {
        return this.canWrite();
    }

    @Override
    public boolean canWrite() {
        return this.outputSink.canWrite();
    }

    @Override
    @Deprecated
    public void notifyCanWrite(WriteHandler handler, int length) {
        this.notifyCanWrite(handler);
    }

    @Override
    public void notifyCanWrite(WriteHandler writeHandler) {
        this.outputSink.notifyWritePossible(writeHandler);
    }

    StreamOutputSink getOutputSink() {
        return this.outputSink;
    }

    @Override
    public GrizzlyFuture<Closeable> terminate() {
        FutureImpl<Closeable> future = Futures.createSafeFuture();
        this.close0(Futures.toCompletionHandler(future), CloseType.LOCALLY, null, false);
        return future;
    }

    @Override
    public void terminateSilently() {
        this.close0(null, CloseType.LOCALLY, null, false);
    }

    @Override
    public void terminateWithReason(IOException cause) {
        this.close0(null, CloseType.LOCALLY, cause, false);
    }

    @Override
    public GrizzlyFuture<Closeable> close() {
        FutureImpl<Closeable> future = Futures.createSafeFuture();
        this.close0(Futures.toCompletionHandler(future), CloseType.LOCALLY, null, true);
        return future;
    }

    @Override
    public void closeSilently() {
        this.close0(null, CloseType.LOCALLY, null, true);
    }

    @Override
    @Deprecated
    public void close(CompletionHandler<Closeable> completionHandler) {
        this.close0(completionHandler, CloseType.LOCALLY, null, true);
    }

    @Override
    public void closeWithReason(IOException cause) {
        this.close0(null, CloseType.LOCALLY, cause, false);
    }

    void close0(CompletionHandler<Closeable> completionHandler, CloseType closeType, IOException cause, boolean isCloseOutputGracefully) {
        if (closeReasonUpdater.compareAndSet(this, null, new CloseReason(closeType, cause))) {
            Termination termination = closeType == CloseType.LOCALLY ? Termination.LOCAL_CLOSE_TERMINATION : Termination.PEER_CLOSE_TERMINATION;
            this.inputBuffer.terminate(termination);
            if (isCloseOutputGracefully) {
                this.outputSink.close();
            } else {
                this.outputSink.terminate(termination);
            }
            this.notifyCloseListeners();
            if (completionHandler != null) {
                completionHandler.completed(this);
            }
        }
    }

    void closedRemotely() {
        this.inputBuffer.terminate(new Termination(Termination.TerminationType.PEER_CLOSE, "Closed by peer", true){

            @Override
            public void doTask() {
                Http2Stream.this.close0(null, CloseType.REMOTELY, null, false);
            }
        });
    }

    void resetRemotely() {
        if (closeReasonUpdater.compareAndSet(this, null, new CloseReason(CloseType.REMOTELY, null))) {
            this.onReset();
            this.inputBuffer.terminate(Termination.RESET_TERMINATION);
            this.outputSink.terminate(Termination.RESET_TERMINATION);
        }
    }

    void onProcessingComplete() {
        this.isProcessingComplete = true;
        this.close();
    }

    @Override
    public void addCloseListener(CloseListener closeListener) {
        CloseReason cr = this.closeReason;
        if (cr == null) {
            this.closeListeners.add(closeListener);
            cr = this.closeReason;
            if (cr != null && this.closeListeners.remove(closeListener)) {
                try {
                    closeListener.onClosed(this, cr.getType());
                }
                catch (IOException iOException) {}
            }
        } else {
            try {
                closeListener.onClosed(this, cr.getType());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean removeCloseListener(CloseListener closeListener) {
        return this.closeListeners.remove(closeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GrizzlyFuture<CloseReason> closeFuture() {
        if (this.closeFuture == null) {
            Http2Stream http2Stream = this;
            synchronized (http2Stream) {
                if (this.closeFuture == null) {
                    CloseReason cr = this.closeReason;
                    if (cr == null) {
                        final FutureImpl<CloseReason> f = Futures.createSafeFuture();
                        this.addCloseListener(new CloseListener(){

                            public void onClosed(Closeable closeable, ICloseType type) throws IOException {
                                CloseReason cr = Http2Stream.this.closeReason;
                                assert (cr != null);
                                f.result(cr);
                            }
                        });
                        this.closeFuture = f;
                    } else {
                        this.closeFuture = Futures.createReadyFuture(cr);
                    }
                }
            }
        }
        return this.closeFuture;
    }

    void onInputClosed() {
        if (completeFinalizationCounterUpdater.incrementAndGet(this) == 2) {
            this.closeStream();
        }
    }

    void onOutputClosed() {
        if (completeFinalizationCounterUpdater.incrementAndGet(this) == 2) {
            this.closeStream();
        }
    }

    int getInboundHeaderFramesCounter() {
        return this.inboundHeaderFramesCounter;
    }

    void onRcvHeaders(boolean isEOS) throws Http2StreamException {
        ++this.inboundHeaderFramesCounter;
        switch (this.inboundHeaderFramesCounter) {
            case 1: {
                this.onReceiveHeaders();
                if (!isEOS) break;
                this.onReceiveEndOfStream();
                break;
            }
            case 2: {
                if (isEOS) break;
            }
            default: {
                this.inputBuffer.close(Termination.UNEXPECTED_FRAME_TERMINATION);
                throw new Http2StreamException(this.getId(), ErrorCode.PROTOCOL_ERROR, "Unexpected headers frame");
            }
        }
    }

    void onSndHeaders(boolean isEOS) {
        this.onSendHeaders();
        if (isEOS) {
            this.onSendEndOfStream();
        }
    }

    private IOException assertCanAcceptData(boolean fin) {
        if (this.isPushStream() && this.isLocallyInitiatedStream()) {
            return new Http2StreamException(this.getId(), ErrorCode.PROTOCOL_ERROR, "Data frame received on a push-stream");
        }
        State state = this.getState();
        if (state == State.HALF_CLOSED_REMOTE || this.getState() == State.CLOSED) {
            this.close0(null, CloseType.LOCALLY, new IOException("Received DATA frame on " + (Object)((Object)state) + " stream."), false);
            return fin ? new Http2SessionException(ErrorCode.STREAM_CLOSED) : new Http2StreamException(this.getId(), ErrorCode.STREAM_CLOSED, "Received DATA frame on " + (Object)((Object)state) + " stream.");
        }
        if (this.inboundHeaderFramesCounter != 1) {
            this.close0(null, CloseType.LOCALLY, new IOException("DATA frame came before HEADERS frame."), false);
            return new Http2StreamException(this.getId(), ErrorCode.PROTOCOL_ERROR, "DATA frame came before HEADERS frame.");
        }
        return null;
    }

    IOException assertCanAcceptHeader(boolean fin) {
        State state = this.getState();
        if (state == State.HALF_CLOSED_REMOTE || this.getState() == State.CLOSED) {
            this.close0(null, CloseType.LOCALLY, new IOException("Received HEADER frame on " + (Object)((Object)state) + " stream."), false);
            return fin ? new Http2SessionException(ErrorCode.STREAM_CLOSED) : new Http2StreamException(this.getId(), ErrorCode.STREAM_CLOSED, "Received HEADER frame on " + (Object)((Object)state) + " stream.");
        }
        return null;
    }

    void offerInputData(Buffer data, boolean fin) throws IOException {
        IOException ex = this.assertCanAcceptData(fin);
        if (ex != null) {
            throw ex;
        }
        boolean isFirstBufferCached = this.cachedInputBuffer == null;
        this.cachedIsLast |= fin;
        this.cachedInputBuffer = Buffers.appendBuffers(this.http2Session.getMemoryManager(), this.cachedInputBuffer, data);
        if (isFirstBufferCached) {
            this.http2Session.streamsToFlushInput.add(this);
        }
    }

    void flushInputData() throws Http2SessionException {
        Buffer cachedInputBufferLocal = this.cachedInputBuffer;
        boolean cachedIsLastLocal = this.cachedIsLast;
        this.cachedInputBuffer = null;
        this.cachedIsLast = false;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "{0} streamId={1}: flushInputData cachedInputBufferLocal={2}", new Object[]{Thread.currentThread().getName(), this.getId(), cachedInputBufferLocal != null ? cachedInputBufferLocal.toString() : null});
        }
        if (cachedInputBufferLocal != null) {
            if (cachedInputBufferLocal.isComposite()) {
                ((CompositeBuffer)cachedInputBufferLocal).allowInternalBuffersDispose(true);
                cachedInputBufferLocal.allowBufferDispose(true);
                ((CompositeBuffer)cachedInputBufferLocal).disposeOrder(CompositeBuffer.DisposeOrder.LAST_TO_FIRST);
            }
            int size = cachedInputBufferLocal.remaining();
            try {
                if (!this.inputBuffer.offer(cachedInputBufferLocal, cachedIsLastLocal)) {
                    this.http2Session.ackConsumedData(size);
                }
            }
            catch (RuntimeException e) {
                throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR, e.getMessage());
            }
        }
    }

    HttpContent pollInputData() throws IOException {
        return this.inputBuffer.poll();
    }

    private void closeStream() {
        this.http2Session.deregisterStream();
    }

    HttpHeader getInputHttpHeader() {
        return this.isLocallyInitiatedStream() ^ this.isPushStream() ? this.request.getResponse() : this.request;
    }

    HttpHeader getOutputHttpHeader() {
        return !this.isLocallyInitiatedStream() ^ this.isPushStream() ? this.request.getResponse() : this.request;
    }

    private void notifyCloseListeners() {
        CloseListener closeListener;
        CloseReason cr = this.closeReason;
        while ((closeListener = this.closeListeners.poll()) != null) {
            try {
                closeListener.onClosed(this, cr.getType());
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    State getState() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isClosed() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            return this.state == State.CLOSED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isIdle() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            return this.state == State.IDLE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canSendFrames() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            return this.state != State.CLOSED && this.state != State.HALF_CLOSED_LOCAL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canReceiveFrames() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            return this.state != State.CLOSED && this.state != State.HALF_CLOSED_REMOTE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSendPushPromise() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            if (this.state == State.IDLE) {
                this.state = State.RESERVED_LOCAL;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onReceivePushPromise() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            if (this.state == State.IDLE) {
                this.state = State.RESERVED_REMOTE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSendHeaders() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            switch (this.state) {
                case IDLE: {
                    this.state = State.OPEN;
                    break;
                }
                case RESERVED_LOCAL: {
                    this.state = State.HALF_CLOSED_REMOTE;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReceiveHeaders() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            switch (this.state) {
                case IDLE: {
                    this.state = State.OPEN;
                    break;
                }
                case RESERVED_REMOTE: {
                    this.state = State.HALF_CLOSED_LOCAL;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSendEndOfStream() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            switch (this.state) {
                case OPEN: {
                    this.state = State.HALF_CLOSED_LOCAL;
                    break;
                }
                case HALF_CLOSED_REMOTE: {
                    this.state = State.CLOSED;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReceiveEndOfStream() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            switch (this.state) {
                case OPEN: {
                    this.state = State.HALF_CLOSED_REMOTE;
                    break;
                }
                case HALF_CLOSED_LOCAL: {
                    this.state = State.CLOSED;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReset() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            switch (this.state) {
                case RESERVED_LOCAL: 
                case RESERVED_REMOTE: 
                case OPEN: 
                case HALF_CLOSED_REMOTE: 
                case HALF_CLOSED_LOCAL: {
                    this.state = State.CLOSED;
                }
            }
        }
    }

    public static enum State {
        IDLE,
        OPEN,
        RESERVED_LOCAL,
        RESERVED_REMOTE,
        HALF_CLOSED_LOCAL,
        HALF_CLOSED_REMOTE,
        CLOSED;

    }
}

