/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.api;

import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.nio.channels.SelectableChannel;
import java.rmi.Remote;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.enterprise.iiop.api.GlassFishORBFactory;
import org.glassfish.enterprise.iiop.api.ProtocolManager;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ORBLocator;
import org.jvnet.hk2.annotations.Service;
import org.omg.CORBA.ORB;
import org.omg.PortableInterceptor.ServerRequestInfo;

@Service
public class GlassFishORBHelper
implements PostConstruct,
ORBLocator {
    @Inject
    private ServiceLocator services;
    @Inject
    private ProcessEnvironment processEnv;
    private static final Logger _logger = LogDomains.getLogger(GlassFishORBHelper.class, (String)"javax.enterprise.resource.corba", (boolean)false);
    private volatile ORB orb;
    private ProtocolManager protocolManager;
    private SelectableChannelDelegate selectableChannelDelegate;
    @Inject
    Provider<ProtocolManager> protocolManagerProvider;
    @Inject
    Provider<GlassfishNamingManager> glassfishNamingManagerProvider;
    @Inject
    private Provider<Events> eventsProvider;
    private GlassFishORBFactory orbFactory;

    public void postConstruct() {
        this.orbFactory = (GlassFishORBFactory)this.services.getService(GlassFishORBFactory.class, new Annotation[0]);
        if (this.orbFactory == null) {
            _logger.log(Level.FINE, "GlassFishORBFactory service not found.");
        } else {
            _logger.log(Level.INFO, "GlassFishORBFactory service initialized.");
        }
    }

    public void onShutdown() {
        _logger.log(Level.FINE, "ORB Shutdown started");
        this.orb.destroy();
    }

    public synchronized void setORB(ORB orb) {
        this.orb = orb;
        if (orb != null) {
            EventListener glassfishEventListener = new EventListener(){

                public void event(EventListener.Event event) {
                    if (event.is(EventTypes.SERVER_SHUTDOWN)) {
                        GlassFishORBHelper.this.onShutdown();
                    }
                }
            };
            ((Events)this.eventsProvider.get()).register(glassfishEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORB getORB() {
        if (this.orb == null) {
            GlassFishORBHelper glassFishORBHelper = this;
            synchronized (glassFishORBHelper) {
                if (this.orb == null) {
                    try {
                        boolean isServer = this.processEnv.getProcessType().isServer();
                        Properties props = new Properties();
                        props.setProperty("com.sun.corba.ee.ORBEnvironmentIsGlassFishServer", Boolean.valueOf(isServer).toString());
                        this.orb = this.getORBFactory().createORB(props);
                        if (isServer && this.protocolManager == null) {
                            ProtocolManager tempProtocolManager = (ProtocolManager)this.protocolManagerProvider.get();
                            tempProtocolManager.initialize(this.orb);
                            tempProtocolManager.initializePOAs();
                            this.protocolManager = tempProtocolManager;
                            GlassfishNamingManager namingManager = (GlassfishNamingManager)this.glassfishNamingManagerProvider.get();
                            Remote remoteSerialProvider = namingManager.initializeRemoteNamingSupport(this.orb);
                            this.protocolManager.initializeRemoteNaming(remoteSerialProvider);
                        }
                    }
                    catch (Exception e) {
                        this.orb = null;
                        this.protocolManager = null;
                        throw new RuntimeException("Orb initialization erorr", e);
                    }
                }
            }
        }
        return this.orb;
    }

    public void setSelectableChannelDelegate(SelectableChannelDelegate d) {
        this.selectableChannelDelegate = d;
    }

    public SelectableChannelDelegate getSelectableChannelDelegate() {
        return this.selectableChannelDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolManager getProtocolManager() {
        if (!this.processEnv.getProcessType().isServer()) {
            return null;
        }
        GlassFishORBHelper glassFishORBHelper = this;
        synchronized (glassFishORBHelper) {
            if (this.protocolManager == null) {
                this.getORB();
            }
            return this.protocolManager;
        }
    }

    private GlassFishORBFactory getORBFactory() {
        return Objects.requireNonNull(this.orbFactory, "GlassFishORBFactory is not initialized!");
    }

    public boolean isORBInitialized() {
        return this.orb != null;
    }

    public int getOTSPolicyType() {
        return this.getORBFactory().getOTSPolicyType();
    }

    public int getCSIv2PolicyType() {
        return this.getORBFactory().getCSIv2PolicyType();
    }

    public Properties getCSIv2Props() {
        return this.getORBFactory().getCSIv2Props();
    }

    public void setCSIv2Prop(String name, String value) {
        this.getORBFactory().setCSIv2Prop(name, value);
    }

    public int getORBInitialPort() {
        return this.getORBFactory().getORBInitialPort();
    }

    public String getORBHost(ORB orb) {
        return this.getORBFactory().getORBHost(orb);
    }

    public int getORBPort(ORB orb) {
        return this.getORBFactory().getORBPort(orb);
    }

    public boolean isEjbCall(ServerRequestInfo sri) {
        return this.getORBFactory().isEjbCall(sri);
    }

    public static interface SelectableChannelDelegate {
        public void handleRequest(SelectableChannel var1);
    }
}

