/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.hk2;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.cdi.hk2.CDIHK2Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.JustInTimeInjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;

@Singleton
public class CDISecondChanceResolver
implements JustInTimeInjectionResolver {
    private final ServiceLocator locator;

    @Inject
    private CDISecondChanceResolver(ServiceLocator locator) {
        this.locator = locator;
    }

    private BeanManager getCurrentBeanManager() {
        try {
            InitialContext jndiContext = new InitialContext();
            return (BeanManager)jndiContext.lookup("java:comp/BeanManager");
        }
        catch (NamingException ne) {
            return null;
        }
    }

    public boolean justInTimeResolution(Injectee failedInjectionPoint) {
        Type requiredType = failedInjectionPoint.getRequiredType();
        Set setQualifiers = failedInjectionPoint.getRequiredQualifiers();
        Annotation[] qualifiers = setQualifiers.toArray(new Annotation[setQualifiers.size()]);
        BeanManager manager = this.getCurrentBeanManager();
        if (manager == null) {
            return false;
        }
        Set beans = manager.getBeans(requiredType, qualifiers);
        if (beans == null || beans.isEmpty()) {
            return false;
        }
        DynamicConfiguration config = ServiceLocatorUtilities.createDynamicConfiguration((ServiceLocator)this.locator);
        for (Bean bean : beans) {
            CDIHK2Descriptor descriptor = new CDIHK2Descriptor(manager, bean, requiredType);
            config.addActiveDescriptor(descriptor);
        }
        config.commit();
        return true;
    }
}

