/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.catalina.realm.JAASRealm;

public class JAASCallbackHandler
implements CallbackHandler {
    protected char[] password = null;
    protected JAASRealm realm = null;
    protected String username = null;

    public JAASCallbackHandler(JAASRealm realm, String username, char[] password) {
        this.realm = realm;
        this.username = username;
        this.password = password != null ? (char[])password.clone() : null;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                if (this.realm.getDebug() >= 3) {
                    this.realm.log("Returning username " + this.username);
                }
                ((NameCallback)callback).setName(this.username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                char[] passwordcontents = this.password != null ? (char[])this.password.clone() : new char[]{};
                ((PasswordCallback)callback).setPassword(passwordcontents);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

