/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.valves.ValveBase;

public final class AccessLogValve
extends ValveBase {
    private String dateStamp = "";
    private String directory = "logs";
    private static final String info = "org.apache.catalina.valves.AccessLogValve/1.0";
    private static final String REQUEST_START_TIME_NOTE = "org.apache.catalina.valves.AccessLogValve.requestStartTime";
    private static final String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private boolean common = false;
    private boolean combined = false;
    private String pattern = null;
    private String prefix = "access_log.";
    private boolean rotatable = true;
    private String suffix = "";
    private PrintWriter writer = null;
    private volatile ThreadLocal<SimpleDateFormat> dateFormatter = null;
    private static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getDefault();
    private static final ThreadLocal<SimpleDateFormat> dayFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat f = new SimpleDateFormat("dd");
            f.setTimeZone(DEFAULT_TIME_ZONE);
            return f;
        }
    };
    private static final ThreadLocal<SimpleDateFormat> monthFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat f = new SimpleDateFormat("MM");
            f.setTimeZone(DEFAULT_TIME_ZONE);
            return f;
        }
    };
    private static final ThreadLocal<DecimalFormat> timeTakenFormatter = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("0.000");
        }
    };
    private ThreadLocal<SimpleDateFormat> yearFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat f = new SimpleDateFormat("yyyy");
            f.setTimeZone(DEFAULT_TIME_ZONE);
            return f;
        }
    };
    private final ThreadLocal<SimpleDateFormat> timeFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat f = new SimpleDateFormat("HH:mm:ss");
            f.setTimeZone(DEFAULT_TIME_ZONE);
            return f;
        }
    };
    private String timeZone = null;
    private Date currentDate = null;
    private final String space = " ";
    private boolean resolveHosts = false;
    private volatile long rotationLastChecked = 0L;
    private String condition = null;
    private String fileDateFormat = null;

    public AccessLogValve() {
        this.setPattern("common");
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        if (pattern == null) {
            pattern = "";
        }
        if (pattern.equals("common")) {
            pattern = "%h %l %u %t \"%r\" %s %b";
        }
        if (pattern.equals("combined")) {
            pattern = "%h %l %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-Agent}i\"";
        }
        this.pattern = pattern;
        this.common = this.pattern.equals("%h %l %u %t \"%r\" %s %b");
        this.combined = this.pattern.equals("%h %l %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-Agent}i\"");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setResolveHosts(boolean resolveHosts) {
        this.resolveHosts = resolveHosts;
    }

    public boolean isResolveHosts() {
        return this.resolveHosts;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getFileDateFormat() {
        return this.fileDateFormat;
    }

    public void setFileDateFormat(String fileDateFormat) {
        this.fileDateFormat = fileDateFormat;
    }

    @Override
    public int invoke(Request request, Response response) throws IOException, ServletException {
        request.setNote(REQUEST_START_TIME_NOTE, System.currentTimeMillis());
        return 1;
    }

    @Override
    public void postInvoke(Request request, Response response) {
        long t2 = System.currentTimeMillis();
        Object startTimeObj = request.getNote(REQUEST_START_TIME_NOTE);
        if (!(startTimeObj instanceof Long)) {
            return;
        }
        long time = t2 - (Long)startTimeObj;
        if (this.condition != null && null != request.getRequest().getAttribute(this.condition)) {
            return;
        }
        Date date = this.getDate();
        StringBuilder result = new StringBuilder();
        if (this.common || this.combined) {
            String value = null;
            ServletRequest req = request.getRequest();
            HttpServletRequest hreq = (HttpServletRequest)req;
            if (this.isResolveHosts()) {
                result.append(req.getRemoteHost());
            } else {
                result.append(req.getRemoteAddr());
            }
            result.append(" - ");
            value = hreq.getRemoteUser();
            if (value == null) {
                result.append("- ");
            } else {
                result.append(value);
                result.append(" ");
            }
            result.append("[");
            result.append(dayFormatter.get().format(date));
            result.append('/');
            result.append(this.lookup(monthFormatter.get().format(date)));
            result.append('/');
            result.append(this.yearFormatter.get().format(date));
            result.append(':');
            result.append(this.timeFormatter.get().format(date));
            result.append(" ");
            result.append(this.timeZone);
            result.append("] \"");
            result.append(hreq.getMethod());
            result.append(" ");
            result.append(hreq.getRequestURI());
            if (hreq.getQueryString() != null) {
                result.append('?');
                result.append(hreq.getQueryString());
            }
            result.append(" ");
            result.append(hreq.getProtocol());
            result.append("\" ");
            result.append(((HttpResponse)response).getStatus());
            result.append(" ");
            int length = response.getContentCount();
            value = length <= 0 ? "-" : "" + length;
            result.append(value);
            if (this.combined) {
                result.append(" ");
                result.append("\"");
                String referer = hreq.getHeader("referer");
                if (referer != null) {
                    result.append(referer);
                } else {
                    result.append("-");
                }
                result.append("\"");
                result.append(" ");
                result.append("\"");
                String ua = hreq.getHeader("user-agent");
                if (ua != null) {
                    result.append(ua);
                } else {
                    result.append("-");
                }
                result.append("\"");
            }
        } else {
            boolean replace = false;
            for (int i = 0; i < this.pattern.length(); ++i) {
                char ch = this.pattern.charAt(i);
                if (replace) {
                    if ('{' == ch) {
                        int j;
                        StringBuilder name = new StringBuilder();
                        for (j = i + 1; j < this.pattern.length() && '}' != this.pattern.charAt(j); ++j) {
                            name.append(this.pattern.charAt(j));
                        }
                        if (j + 1 < this.pattern.length()) {
                            result.append(this.replace(name.toString(), this.pattern.charAt(++j), request, response));
                            i = j;
                        } else {
                            result.append(this.replace(ch, date, request, response, time));
                        }
                    } else {
                        result.append(this.replace(ch, date, request, response, time));
                    }
                    replace = false;
                    continue;
                }
                if (ch == '%') {
                    replace = true;
                    continue;
                }
                result.append(ch);
            }
        }
        this.log(result.toString(), date);
    }

    private synchronized void close() {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.writer.close();
        this.writer = null;
        this.dateStamp = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String message, Date date) {
        long systime;
        if (this.rotatable && (systime = System.currentTimeMillis()) - this.rotationLastChecked > 1000L) {
            this.currentDate = new Date(systime);
            this.rotationLastChecked = systime;
            String tsDate = this.dateFormatter.get().format(this.currentDate);
            if (!this.dateStamp.equals(tsDate)) {
                AccessLogValve accessLogValve = this;
                synchronized (accessLogValve) {
                    if (!this.dateStamp.equals(tsDate)) {
                        this.close();
                        this.dateStamp = tsDate;
                        this.open();
                    }
                }
            }
        }
        if (this.writer != null) {
            this.writer.println(message);
        }
    }

    private String lookup(String month) {
        int index;
        try {
            index = Integer.parseInt(month) - 1;
        }
        catch (Throwable t) {
            index = 0;
        }
        return months[index];
    }

    private synchronized void open() {
        File dir = new File(this.directory);
        if (!dir.isAbsolute()) {
            dir = new File(System.getProperty("catalina.base"), this.directory);
        }
        if (!dir.mkdirs() && !dir.isDirectory()) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00491", dir);
        }
        try {
            String pathname = this.rotatable ? dir.getAbsolutePath() + File.separator + this.prefix + this.dateStamp + this.suffix : dir.getAbsolutePath() + File.separator + this.prefix + this.suffix;
            this.writer = new PrintWriter((Writer)new FileWriter(pathname, true), true);
        }
        catch (IOException e) {
            this.writer = null;
        }
    }

    private String replace(char pattern, Date date, Request request, Response response, long time) {
        String value = null;
        ServletRequest req = request.getRequest();
        HttpServletRequest hreq = (HttpServletRequest)req;
        ServletResponse res = response.getResponse();
        HttpServletResponse hres = (HttpServletResponse)res;
        switch (pattern) {
            case 'a': {
                value = req.getRemoteAddr();
                break;
            }
            case 'A': {
                try {
                    value = InetAddress.getLocalHost().getHostAddress();
                }
                catch (Throwable e) {
                    value = "127.0.0.1";
                }
                break;
            }
            case 'b': {
                int length = response.getContentCount();
                if (length <= 0) {
                    value = "-";
                    break;
                }
                value = "" + length;
                break;
            }
            case 'B': {
                value = "" + response.getContentLength();
                break;
            }
            case 'h': {
                value = req.getRemoteHost();
                break;
            }
            case 'H': {
                value = req.getProtocol();
                break;
            }
            case 'l': {
                value = "-";
                break;
            }
            case 'm': {
                if (hreq != null) {
                    value = hreq.getMethod();
                    break;
                }
                value = "";
                break;
            }
            case 'p': {
                value = "" + req.getServerPort();
                break;
            }
            case 'D': {
                value = "" + time;
                break;
            }
            case 'q': {
                String query = null;
                if (hreq != null) {
                    query = hreq.getQueryString();
                }
                if (query != null) {
                    value = "?" + query;
                    break;
                }
                value = "";
                break;
            }
            case 'r': {
                if (hreq != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(hreq.getMethod());
                    sb.append(" ");
                    sb.append(hreq.getRequestURI());
                    if (hreq.getQueryString() != null) {
                        sb.append('?');
                        sb.append(hreq.getQueryString());
                    }
                    sb.append(" ");
                    sb.append(hreq.getProtocol());
                    value = sb.toString();
                    break;
                }
                value = "- - -";
                break;
            }
            case 'S': {
                if (request instanceof org.apache.catalina.connector.Request) {
                    Session sess = ((org.apache.catalina.connector.Request)request).getSessionInternal(false);
                    if (sess != null) {
                        value = sess.getIdInternal();
                        break;
                    }
                    value = "-";
                    break;
                }
                if (hreq != null) {
                    if (hreq.getSession(false) != null) {
                        value = hreq.getSession(false).getId();
                        break;
                    }
                    value = "-";
                    break;
                }
                value = "-";
                break;
            }
            case 's': {
                if (hres != null) {
                    value = "" + ((HttpResponse)response).getStatus();
                    break;
                }
                value = "-";
                break;
            }
            case 't': {
                StringBuilder temp = new StringBuilder("[");
                temp.append(dayFormatter.get().format(date));
                temp.append('/');
                temp.append(this.lookup(monthFormatter.get().format(date)));
                temp.append('/');
                temp.append(this.yearFormatter.get().format(date));
                temp.append(':');
                temp.append(this.timeFormatter.get().format(date));
                temp.append(' ');
                temp.append(this.timeZone);
                temp.append(']');
                value = temp.toString();
                break;
            }
            case 'T': {
                value = timeTakenFormatter.get().format((double)time / 1000.0);
                break;
            }
            case 'u': {
                if (hreq != null) {
                    value = hreq.getRemoteUser();
                }
                if (value != null) break;
                value = "-";
                break;
            }
            case 'U': {
                if (hreq != null) {
                    value = hreq.getRequestURI();
                    break;
                }
                value = "-";
                break;
            }
            case 'v': {
                value = req.getServerName();
                break;
            }
            default: {
                value = "???" + pattern + "???";
            }
        }
        if (value == null) {
            return "";
        }
        return value;
    }

    private String replace(String header, char type, Request request, Response response) {
        Object value = null;
        ServletRequest req = request.getRequest();
        HttpServletRequest hreq = (HttpServletRequest)req;
        block1 : switch (type) {
            case 'i': {
                if (null != hreq) {
                    value = hreq.getHeader(header);
                    break;
                }
                value = "??";
                break;
            }
            case 'c': {
                Cookie[] c = hreq.getCookies();
                for (int i = 0; c != null && i < c.length; ++i) {
                    if (!header.equals(c[i].getName())) continue;
                    value = c[i].getValue();
                    break block1;
                }
                break;
            }
            case 'r': {
                if (null != hreq) {
                    value = hreq.getAttribute(header);
                    break;
                }
                value = "??";
                break;
            }
            case 's': {
                HttpSession sess;
                if (null == hreq || null == (sess = hreq.getSession(false))) break;
                value = sess.getAttribute(header);
                break;
            }
            default: {
                value = "???";
            }
        }
        try {
            if (value != null) {
                if (value instanceof String) {
                    return (String)value;
                }
                return value.toString();
            }
            return "-";
        }
        catch (Throwable e) {
            return "-";
        }
    }

    private Date getDate() {
        long systime = System.currentTimeMillis();
        if (systime - this.currentDate.getTime() > 1000L) {
            this.currentDate = new Date(systime);
        }
        return this.currentDate;
    }

    private String calculateTimeZoneOffset(long offset) {
        StringBuilder tz = new StringBuilder();
        if (offset < 0L) {
            tz.append("-");
            offset = -offset;
        } else {
            tz.append("+");
        }
        long hourOffset = offset / 3600000L;
        long minuteOffset = offset / 60000L % 60L;
        if (hourOffset < 10L) {
            tz.append("0");
        }
        tz.append(hourOffset);
        if (minuteOffset < 10L) {
            tz.append("0");
        }
        tz.append(minuteOffset);
        return tz.toString();
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        super.start();
        this.timeZone = this.calculateTimeZoneOffset(DEFAULT_TIME_ZONE.getRawOffset());
        if (this.fileDateFormat == null || this.fileDateFormat.length() == 0) {
            this.fileDateFormat = "yyyy-MM-dd";
        }
        this.dateFormatter = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat f = new SimpleDateFormat(AccessLogValve.this.fileDateFormat);
                f.setTimeZone(DEFAULT_TIME_ZONE);
                return f;
            }
        };
        this.currentDate = new Date();
        this.dateStamp = this.dateFormatter.get().format(this.currentDate);
        this.open();
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.close();
        super.stop();
    }
}

