/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;

public class ClusterNewMasterBrokerInfo {
    private Long xid = null;
    private String uuid = null;
    private BrokerAddress newmaster = null;
    private BrokerAddress oldmaster = null;
    Cluster c = null;
    private GPacket pkt = null;

    private ClusterNewMasterBrokerInfo(BrokerAddress newmaster, BrokerAddress oldmaster, String uuid, Long xid, Cluster c) {
        this.xid = xid;
        this.uuid = uuid;
        this.c = c;
        this.newmaster = newmaster;
        this.oldmaster = oldmaster;
    }

    private ClusterNewMasterBrokerInfo(GPacket pkt, Cluster c) {
        this.pkt = pkt;
        this.c = c;
    }

    public static ClusterNewMasterBrokerInfo newInstance(BrokerAddress newmaster, BrokerAddress oldmaster, String uuid, Long xid, Cluster c) {
        return new ClusterNewMasterBrokerInfo(newmaster, oldmaster, uuid, xid, c);
    }

    public static ClusterNewMasterBrokerInfo newInstance(GPacket pkt, Cluster c) {
        return new ClusterNewMasterBrokerInfo(pkt, c);
    }

    public GPacket getGPacket() throws Exception {
        GPacket gp = GPacket.getInstance();
        gp.setType((short)53);
        gp.putProp((Object)"TS", (Object)System.currentTimeMillis());
        gp.putProp((Object)"X", (Object)this.xid);
        gp.putProp((Object)"UUID", (Object)this.uuid);
        gp.putProp((Object)"oldMasterBroker", (Object)this.oldmaster.toProtocolString());
        this.c.marshalBrokerAddress(this.newmaster, gp);
        gp.setBit(1, true);
        return gp;
    }

    public BrokerAddress getNewMasterBroker() throws Exception {
        assert (this.pkt != null);
        this.newmaster = this.c.unmarshalBrokerAddress(this.pkt);
        return this.newmaster;
    }

    public BrokerAddress getOldMasterBroker() throws Exception {
        assert (this.pkt != null);
        String oldm = (String)this.pkt.getProp((Object)"oldMasterBroker");
        this.oldmaster = Globals.getMyAddress().fromProtocolString(oldm);
        return this.oldmaster;
    }

    public String getUUID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"UUID");
    }

    public Long getXid() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"X");
    }

    public Long getTimestamp() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"TS");
    }

    public GPacket getReplyGPacket(int status, String reason) {
        assert (this.pkt != null);
        GPacket gp = GPacket.getInstance();
        gp.setType((short)54);
        gp.putProp((Object)"X", this.pkt.getProp((Object)"X"));
        gp.putProp((Object)"UUID", this.pkt.getProp((Object)"UUID"));
        gp.putProp((Object)"S", (Object)status);
        if (reason != null) {
            gp.putProp((Object)"reason", (Object)reason);
        }
        return gp;
    }

    public String toString() {
        if (this.pkt == null) {
            return "[newMasterBroker=" + this.newmaster + ", oldMasterBroker=" + this.oldmaster + ", xid=" + this.xid + ", uuid=" + this.uuid + "]";
        }
        return (this.newmaster == null ? "" : "[newMasterBroker=" + this.newmaster) + (this.oldmaster == null ? "" : "[oldMasterBroker=" + this.oldmaster) + ", xid=" + this.getXid() + ", ts=" + this.getTimestamp() + ", uuid=" + this.getUUID() + "]";
    }

    public static Long getReplyPacketXid(GPacket gp) {
        return (Long)gp.getProp((Object)"X");
    }
}

