/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.util;

import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.IOException;
import java.util.Enumeration;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.hk2.api.ServiceLocator;

public class ResourceUtil {
    private static final String RESOURCES_XML_META_INF = "META-INF/glassfish-resources.xml";
    private static final String RESOURCES_XML_WEB_INF = "WEB-INF/glassfish-resources.xml";
    private static final String PAYARA_RESOURCES_XML_META_INF = "META-INF/payara-resources.xml";
    private static final String PAYARA_RESOURCES_XML_WEB_INF = "WEB-INF/payara-resources.xml";

    public static boolean hasGlassfishResourcesXML(ReadableArchive archive, ServiceLocator locator) {
        boolean hasResourcesXML;
        block8: {
            hasResourcesXML = false;
            if (archive != null) {
                try {
                    if (DeploymentUtils.isArchiveOfType((ReadableArchive)archive, (ArchiveType)DOLUtils.earType(), (ServiceLocator)locator)) {
                        if (archive.exists(RESOURCES_XML_META_INF)) {
                            return true;
                        }
                        Enumeration entries = archive.entries();
                        while (entries.hasMoreElements()) {
                            boolean answer;
                            String element = (String)entries.nextElement();
                            if (!element.endsWith(".jar") && !element.endsWith(".war") && !element.endsWith(".rar") && !element.endsWith("_jar") && !element.endsWith("_war") && !element.endsWith("_rar")) continue;
                            ReadableArchive subArchive = archive.getSubArchive(element);
                            boolean bl = answer = subArchive != null && ResourceUtil.hasGlassfishResourcesXML(subArchive, locator);
                            if (subArchive != null) {
                                subArchive.close();
                            }
                            if (!answer) continue;
                            return true;
                        }
                        break block8;
                    }
                    if (DeploymentUtils.isArchiveOfType((ReadableArchive)archive, (ArchiveType)DOLUtils.warType(), (ServiceLocator)locator)) {
                        return archive.exists(RESOURCES_XML_WEB_INF);
                    }
                    return archive.exists(RESOURCES_XML_META_INF);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return hasResourcesXML;
    }

    public static boolean hasPayaraResourcesXML(ReadableArchive archive, ServiceLocator locator) {
        boolean hasResourcesXML;
        block8: {
            hasResourcesXML = false;
            if (archive != null) {
                try {
                    if (DeploymentUtils.isArchiveOfType((ReadableArchive)archive, (ArchiveType)DOLUtils.earType(), (ServiceLocator)locator)) {
                        if (archive.exists(PAYARA_RESOURCES_XML_META_INF)) {
                            return true;
                        }
                        Enumeration entries = archive.entries();
                        while (entries.hasMoreElements()) {
                            boolean answer;
                            String element = (String)entries.nextElement();
                            if (!element.endsWith(".jar") && !element.endsWith(".war") && !element.endsWith(".rar") && !element.endsWith("_jar") && !element.endsWith("_war") && !element.endsWith("_rar")) continue;
                            ReadableArchive subArchive = archive.getSubArchive(element);
                            boolean bl = answer = subArchive != null && ResourceUtil.hasPayaraResourcesXML(subArchive, locator);
                            if (subArchive != null) {
                                subArchive.close();
                            }
                            if (!answer) continue;
                            return true;
                        }
                        break block8;
                    }
                    if (DeploymentUtils.isArchiveOfType((ReadableArchive)archive, (ArchiveType)DOLUtils.warType(), (ServiceLocator)locator)) {
                        return archive.exists(PAYARA_RESOURCES_XML_WEB_INF);
                    }
                    return archive.exists(PAYARA_RESOURCES_XML_META_INF);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return hasResourcesXML;
    }
}

