/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.module;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.resource.ResourceException;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.api.ResourcesBinder;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.glassfish.resources.admin.cli.ResourceFactory;
import org.glassfish.resources.admin.cli.ResourceManager;
import org.glassfish.resources.admin.cli.ResourcesXMLParser;
import org.glassfish.resources.admin.cli.SunResourcesXML;
import org.glassfish.resources.api.ResourcesRegistry;
import org.glassfish.resources.module.ResourceUtilities;
import org.glassfish.resources.module.ResourcesApplication;
import org.glassfish.resources.module.ResourcesContainer;
import org.glassfish.resources.util.ResourceUtil;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;

@Service
public class ResourcesDeployer
extends JavaEEDeployer<ResourcesContainer, ResourcesApplication>
implements PostConstruct,
PreDestroy,
EventListener {
    private final ResourceFactory resourceFactory;
    @Inject
    private Domain domain;
    @Inject
    private ServerContext context;
    @Inject
    private Provider<ResourcesApplication> resourcesApplicationProvider;
    private final ApplicationRegistry appRegistry;
    private final Provider<ResourceManagerFactory> resourceManagerFactoryProvider;
    private final ResourcesBinder resourcesBinder;
    @Inject
    private ConfigSupport configSupport;
    @Inject
    private Events events;
    @Inject
    private ServiceLocator locator;
    private final Applications applications;
    private static Map<String, Application> preservedApps = new HashMap<String, Application>();
    private static final Logger _logger = LogDomains.getLogger(ResourcesDeployer.class, (String)"javax.enterprise.resource.resourceadapter");
    private static final String RESOURCES_XML_META_INF = "META-INF/glassfish-resources.xml";
    private static final String RESOURCES_XML_WEB_INF = "WEB-INF/glassfish-resources.xml";
    private static final String PAYARA_RESOURCES_XML_META_INF = "META-INF/payara-resources.xml";
    private static final String PAYARA_RESOURCES_XML_WEB_INF = "WEB-INF/payara-resources.xml";

    @Inject
    public ResourcesDeployer(ResourceFactory resourceFactoryParam, ApplicationRegistry appRegistryParam, Provider<ResourceManagerFactory> resourceManagerFactoryProviderParam, ResourcesBinder resourcesBinderParam, Applications applicationsParam) {
        this.resourceFactory = resourceFactoryParam;
        this.appRegistry = appRegistryParam;
        this.resourceManagerFactoryProvider = resourceManagerFactoryProviderParam;
        this.resourcesBinder = resourcesBinderParam;
        this.applications = applicationsParam;
    }

    public void postConstruct() {
        this.events.register((EventListener)this);
    }

    public void preDestroy() {
        this.events.unregister((EventListener)this);
    }

    public ResourcesApplication load(ResourcesContainer container, DeploymentContext context) {
        super.load((Container)container, context);
        ResourcesDeployer.debug("App-Scoped-Resources ResourcesDeployer.load()");
        ResourcesApplication application = this.resourcesApplicationProvider.get();
        application.setApplicationName(ResourcesDeployer.getAppNameFromDeployCmdParams(context));
        return application;
    }

    public void unload(ResourcesApplication appContainer, DeploymentContext context) {
        ResourcesDeployer.debug("Resources-Deployer :unload() called");
    }

    public void getResources(ReadableArchive archive, String appName, List<org.glassfish.resources.api.Resource> connectorResources, List<org.glassfish.resources.api.Resource> nonConnectorResources, Map<org.glassfish.resources.api.Resource, ResourcesXMLParser> resourceXmlParsers) {
        String processedFilename = "glassfish-resources.xml";
        try {
            if (ResourceUtil.hasGlassfishResourcesXML((ReadableArchive)archive, (ServiceLocator)this.locator) || ResourceUtil.hasPayaraResourcesXML((ReadableArchive)archive, (ServiceLocator)this.locator)) {
                HashMap appScopedResources = new HashMap();
                HashMap<String, String> fileNames = new HashMap<String, String>();
                this.retrieveAllResourcesXMLs(fileNames, archive, appName);
                for (Map.Entry entry : fileNames.entrySet()) {
                    String moduleName = (String)entry.getKey();
                    String fileName = (String)entry.getValue();
                    ResourcesDeployer.debug("GlassFish Resources XML : " + fileName);
                    processedFilename = fileName;
                    moduleName = org.glassfish.resourcebase.resources.util.ResourceUtil.getActualModuleNameWithExtension((String)moduleName);
                    String scope = appName.equals(moduleName) ? "java:app/" : "java:module/";
                    File file = new File(fileName);
                    ResourcesXMLParser parser = new ResourcesXMLParser(file, scope);
                    ResourcesDeployer.validateResourcesXML(file, parser);
                    List resources = parser.getResourcesList();
                    if (nonConnectorResources != null) {
                        nonConnectorResources.addAll(ResourcesXMLParser.getNonConnectorResourcesList((List)resources, (boolean)false, (boolean)true));
                    }
                    if (connectorResources != null) {
                        connectorResources.addAll(ResourcesXMLParser.getConnectorResourcesList((List)resources, (boolean)false, (boolean)true));
                    }
                    if (resourceXmlParsers == null) continue;
                    for (org.glassfish.resources.api.Resource res : resources) {
                        resourceXmlParsers.put(res, parser);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Failure while processing " + processedFilename + " in the archive ", (Throwable)e);
        }
    }

    private void processArchive(DeploymentContext dc) {
        String processedFilename = "glassfish-resources.xml";
        try {
            ReadableArchive archive = dc.getSource();
            if (ResourceUtil.hasGlassfishResourcesXML((ReadableArchive)archive, (ServiceLocator)this.locator) || ResourceUtil.hasPayaraResourcesXML((ReadableArchive)archive, (ServiceLocator)this.locator)) {
                HashMap appScopedResources = new HashMap();
                HashMap jndiNames = new HashMap();
                ArrayList<AbstractMap.SimpleEntry<String, String>> raNames = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
                HashMap<String, String> fileNames = new HashMap<String, String>();
                String appName = ResourcesDeployer.getAppNameFromDeployCmdParams(dc);
                this.retrieveAllResourcesXMLs(fileNames, archive, appName);
                for (Map.Entry entry : fileNames.entrySet()) {
                    String moduleName = (String)entry.getKey();
                    String fileName = (String)entry.getValue();
                    ResourcesDeployer.debug("Sun Resources XML : " + fileName);
                    processedFilename = fileName;
                    moduleName = org.glassfish.resourcebase.resources.util.ResourceUtil.getActualModuleNameWithExtension((String)moduleName);
                    String scope = appName.equals(moduleName) ? "java:app/" : "java:module/";
                    File file = new File(fileName);
                    ResourcesXMLParser parser = new ResourcesXMLParser(file, scope);
                    ResourcesDeployer.validateResourcesXML(file, parser);
                    List list = parser.getResourcesList();
                    HashMap<String, List> resourcesList = new HashMap<String, List>();
                    ArrayList<String> jndiNamesList = new ArrayList<String>();
                    List nonConnectorResources = ResourcesXMLParser.getNonConnectorResourcesList((List)list, (boolean)false, (boolean)true);
                    resourcesList.put("NON-CONNECTOR", nonConnectorResources);
                    for (org.glassfish.resources.api.Resource resource : nonConnectorResources) {
                        String jndiName = this.extractJNDIName(resource);
                        if (this.hasRAName(resource)) {
                            raNames.add(new AbstractMap.SimpleEntry<String, String>(this.extractRAName(resource), resource.getType()));
                        }
                        if (jndiName == null) continue;
                        jndiNamesList.add(jndiName);
                    }
                    List connectorResources = ResourcesXMLParser.getConnectorResourcesList((List)list, (boolean)false, (boolean)true);
                    resourcesList.put("CONNECTOR", connectorResources);
                    for (org.glassfish.resources.api.Resource resource : connectorResources) {
                        String jndiName = this.extractJNDIName(resource);
                        if (this.hasRAName(resource)) {
                            raNames.add(new AbstractMap.SimpleEntry<String, String>(this.extractRAName(resource), resource.getType()));
                        }
                        if (jndiName == null) continue;
                        jndiNamesList.add(jndiName);
                    }
                    jndiNames.put(moduleName, jndiNamesList);
                    appScopedResources.put(moduleName, resourcesList);
                }
                dc.addTransientAppMetaData("app-scoped-resources-jndi-names", jndiNames);
                dc.addTransientAppMetaData("app-scoped-resources-ra-names", raNames);
                dc.addTransientAppMetaData("app-scoped-resources-map", appScopedResources);
                ApplicationInfo appInfo = this.appRegistry.get(appName);
                if (appInfo != null) {
                    Application app = (Application)dc.getTransientAppMetaData("application", Application.class);
                    appInfo.addTransientAppMetaData("application", (Object)app);
                }
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Failure while processing " + processedFilename + " in the archive ", (Throwable)e);
        }
    }

    private String extractJNDIName(org.glassfish.resources.api.Resource resource) {
        HashMap attrs = resource.getAttributes();
        return (String)attrs.get("jndi-name");
    }

    private boolean hasRAName(org.glassfish.resources.api.Resource resource) {
        return resource.getType().equals("admin-object-resource") || resource.getType().equals("connector-connection-pool") || resource.getType().equals("resource-adapter-config") || resource.getType().equals("work-security-map");
    }

    private String extractRAName(org.glassfish.resources.api.Resource resource) {
        if (resource.getType().equals("admin-object-resource")) {
            return (String)resource.getAttributes().get("res-adapter");
        }
        return (String)resource.getAttributes().get("resource-adapter-name");
    }

    private static void validateResourcesXML(File file, ResourcesXMLParser parser) throws ResourceConflictException {
        String filePath = file.getPath();
        SunResourcesXML sunResourcesXML = new SunResourcesXML(filePath, parser.getResourcesList());
        ArrayList<SunResourcesXML> resourcesXMLList = new ArrayList<SunResourcesXML>();
        resourcesXMLList.add(sunResourcesXML);
        ResourceUtilities.resolveResourceDuplicatesConflictsWithinArchive(resourcesXMLList);
    }

    public void retainResourceConfig(DeploymentContext dc, Map<String, Resources> allResources) throws Exception {
        List modules;
        String appName = ResourcesDeployer.getAppNameFromDeployCmdParams(dc);
        Application application = (Application)dc.getTransientAppMetaData("application", Application.class);
        Resources appScopedResources = allResources.get(appName);
        if (appScopedResources != null) {
            application.setResources(appScopedResources);
        }
        if (DeploymentUtils.isArchiveOfType((ReadableArchive)dc.getSource(), (ArchiveType)DOLUtils.earType(), (ServiceLocator)this.locator) && (modules = application.getModule()) != null) {
            for (Module module : modules) {
                Resources moduleScopedResources = allResources.get(module.getName());
                if (moduleScopedResources == null) continue;
                module.setResources(moduleScopedResources);
            }
        }
    }

    public void populateResourceConfigInAppInfo(DeploymentContext dc) {
        String appName = ResourcesDeployer.getAppNameFromDeployCmdParams(dc);
        Application application = this.applications.getApplication(appName);
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (application != null && appInfo != null) {
            List modules;
            Resources appScopedResources = application.getResources();
            if (appScopedResources != null) {
                appInfo.addTransientAppMetaData("application", (Object)application);
                appInfo.addTransientAppMetaData(application.getName() + "-resources", (Object)appScopedResources);
            }
            if ((modules = application.getModule()) != null) {
                for (Module module : modules) {
                    Resources moduleScopedResources = module.getResources();
                    if (moduleScopedResources == null) continue;
                    appInfo.addTransientAppMetaData(module.getName() + "-resources", (Object)moduleScopedResources);
                }
            }
        }
    }

    public void createResources(DeploymentContext dc, boolean embedded, boolean deployResources) throws ResourceException {
        String appName = ResourcesDeployer.getAppNameFromDeployCmdParams(dc);
        Application app = (Application)dc.getTransientAppMetaData("application", Application.class);
        Map resourcesList = (Map)dc.getTransientAppMetadata().get("app-scoped-resources-map");
        if (resourcesList != null) {
            List modules;
            Map appLevelResources = (Map)resourcesList.get(appName);
            if (appLevelResources != null) {
                List connectorResources = (List)appLevelResources.get("CONNECTOR");
                this.createAppScopedResources(app, connectorResources, dc, embedded);
                List nonConnectorResources = (List)appLevelResources.get("NON-CONNECTOR");
                this.createAppScopedResources(app, nonConnectorResources, dc, embedded);
            }
            if ((modules = app.getModule()) != null) {
                for (Module module : modules) {
                    Map moduleResources;
                    String actualModuleName = org.glassfish.resourcebase.resources.util.ResourceUtil.getActualModuleNameWithExtension((String)module.getName());
                    if (appName.equals(actualModuleName) || (moduleResources = (Map)resourcesList.get(actualModuleName)) == null) continue;
                    List connectorResources = (List)moduleResources.get("CONNECTOR");
                    this.createModuleScopedResources(app, module, connectorResources, dc, embedded);
                    List nonConnectorResources = (List)moduleResources.get("NON-CONNECTOR");
                    this.createModuleScopedResources(app, module, nonConnectorResources, dc, embedded);
                }
            }
        }
    }

    private Collection<Resource> createConfig(Resources resources, Collection<org.glassfish.resources.api.Resource> resourcesToRegister, boolean embedded) throws ResourceException {
        ArrayList<Resource> resourceConfigs = new ArrayList<Resource>();
        for (org.glassfish.resources.api.Resource resource : resourcesToRegister) {
            HashMap attrList = resource.getAttributes();
            Properties props = resource.getProperties();
            String desc = resource.getDescription();
            if (desc != null) {
                attrList.put("description", desc);
            }
            try {
                Resource configBeanResource;
                ResourceManager rm = this.resourceFactory.getResourceManager(resource);
                if (embedded && ResourcesDeployer.isEmbeddedResource(resource, resourcesToRegister)) {
                    configBeanResource = rm.createConfigBean(resources, attrList, props, false);
                    resources.getResources().add(configBeanResource);
                    resourceConfigs.add(configBeanResource);
                    continue;
                }
                if (embedded || ResourcesDeployer.isEmbeddedResource(resource, resourcesToRegister)) continue;
                configBeanResource = rm.createConfigBean(resources, attrList, props, true);
                resources.getResources().add(configBeanResource);
                resourceConfigs.add(configBeanResource);
            }
            catch (Exception e) {
                throw new ResourceException((Throwable)e);
            }
        }
        return resourceConfigs;
    }

    private static boolean isConnectorResource(org.glassfish.resources.api.Resource resource) {
        return resource.getType().equals("admin-object-resource") || resource.getType().equals("connector-connection-pool") || resource.getType().equals("connector-resource") || resource.getType().equals("resource-adapter-config") || resource.getType().equals("work-security-map");
    }

    private static boolean isEmbeddedResource(org.glassfish.resources.api.Resource resource, Collection<org.glassfish.resources.api.Resource> resources) {
        boolean result = false;
        if (ResourcesDeployer.isConnectorResource(resource)) {
            String attributeName = null;
            if (resource.getType().equals("admin-object-resource")) {
                attributeName = "res-adapter";
            } else if (resource.getType().equals("connector-connection-pool")) {
                attributeName = "resource-adapter-name";
            } else if (resource.getType().equals("connector-resource")) {
                String poolName = (String)resource.getAttributes().get("pool-name");
                if (poolName != null) {
                    org.glassfish.resources.api.Resource poolResource;
                    resource = poolResource = ResourcesDeployer.getPoolResource(poolName, resources);
                    attributeName = "resource-adapter-name";
                }
            } else if (resource.getType().equals("work-security-map")) {
                attributeName = "resource-adapter-name";
            }
            if (attributeName != null && resource != null) {
                result = ResourcesDeployer.isEmbeddedRar(resource, attributeName);
            }
        }
        return result;
    }

    private static org.glassfish.resources.api.Resource getPoolResource(String poolName, Collection<org.glassfish.resources.api.Resource> resources) {
        org.glassfish.resources.api.Resource result = null;
        for (org.glassfish.resources.api.Resource resource : resources) {
            String cpName;
            if (!resource.getType().equals("connector-connection-pool") || !poolName.equals(cpName = (String)resource.getAttributes().get("name"))) continue;
            result = resource;
            break;
        }
        return result;
    }

    private static boolean isEmbeddedRar(org.glassfish.resources.api.Resource resource, String attributeName) {
        boolean result = false;
        String raName = (String)resource.getAttributes().get(attributeName);
        if (raName != null && raName.contains("#")) {
            result = true;
        }
        return result;
    }

    private void createAppScopedResources(Application app, List<org.glassfish.resources.api.Resource> resources, DeploymentContext dc, boolean embedded) throws ResourceException {
        try {
            if (resources != null) {
                Application application = (Application)dc.getTransientAppMetaData("application", Application.class);
                Resources asc = (Resources)dc.getTransientAppMetaData("app-level-resources-config", Resources.class);
                if (asc == null) {
                    asc = (Resources)application.createChild(Resources.class);
                    application.setResources(asc);
                    dc.addTransientAppMetaData("app-level-resources-config", (Object)asc);
                    ApplicationInfo appInfo = this.appRegistry.get(app.getName());
                    if (appInfo != null) {
                        appInfo.addTransientAppMetaData(app.getName() + "-resources", (Object)asc);
                    }
                }
                this.createConfig(asc, resources, embedded);
                String appName = app.getName();
                ResourcesDeployer.preserveResources(asc, appName, appName);
            }
        }
        catch (Exception e) {
            Object[] params = new Object[]{app.getName(), e};
            _logger.log(Level.SEVERE, "gf.resources.app.scope.deployment.failure", params);
            throw new ResourceException((Throwable)e);
        }
    }

    private static void preserveResources(Resources resources, String appName, String moduleName) {
        HashMap<String, Resources> allResources = ResourcesRegistry.getResources((String)appName);
        if (allResources != null) {
            allResources.put(moduleName, resources);
        } else {
            allResources = new HashMap<String, Resources>();
            allResources.put(moduleName, resources);
            ResourcesRegistry.putResources((String)appName, allResources);
        }
    }

    private void createModuleScopedResources(Application app, Module module, List<org.glassfish.resources.api.Resource> resources, DeploymentContext dc, boolean embedded) throws ResourceException {
        try {
            if (resources != null) {
                Resources msc = (Resources)dc.getTransientAppMetaData(module.getName() + "-resources", Resources.class);
                if (msc == null) {
                    msc = (Resources)module.createChild(Resources.class);
                    module.setResources(msc);
                    dc.addTransientAppMetaData(module.getName() + "-resources", (Object)msc);
                    ApplicationInfo appInfo = this.appRegistry.get(app.getName());
                    if (appInfo != null) {
                        appInfo.addTransientAppMetaData(module.getName() + "-resources", (Object)msc);
                    }
                }
                this.createConfig(msc, resources, embedded);
                ResourcesDeployer.preserveResources(msc, app.getName(), module.getName());
            }
        }
        catch (Exception e) {
            Object[] params = new Object[]{module.getName(), app.getName(), e};
            _logger.log(Level.SEVERE, "gf.resources.module.scope.deployment.failure", params);
            throw new ResourceException((Throwable)e);
        }
    }

    public void deployResourcesFromConfiguration(String appName, boolean embedded) throws Exception {
        Application application = this.applications.getApplication(appName);
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (application != null && appInfo != null) {
            List modules;
            Resources appScopedResources = application.getResources();
            if (appScopedResources != null) {
                this.deployResources(appName, null, appScopedResources.getResources(), embedded);
            }
            if ((modules = application.getModule()) != null) {
                for (Module module : modules) {
                    Resources moduleScopedResources = module.getResources();
                    String moduleName = module.getName();
                    if (moduleScopedResources == null) continue;
                    this.deployResources(appName, moduleName, moduleScopedResources.getResources(), embedded);
                }
            }
        }
    }

    public void deployResources(String applicationName, boolean postDeployPhase) throws Exception {
        Map allResources = ResourcesRegistry.getResources((String)applicationName);
        if (allResources != null) {
            for (Map.Entry entry : allResources.entrySet()) {
                String moduleName = (String)entry.getKey();
                Resources resources = (Resources)entry.getValue();
                if (applicationName.equals(moduleName)) {
                    this.deployResources(applicationName, null, resources.getResources(), postDeployPhase);
                    continue;
                }
                this.deployResources(applicationName, moduleName, resources.getResources(), postDeployPhase);
            }
        }
    }

    public void deployResources(String applicationName, String moduleName, Collection<Resource> resources, boolean postDeployPhase) throws Exception {
        for (Resource resource : resources) {
            if (resource instanceof BindableResource) {
                BindableResource bindableResource = (BindableResource)resource;
                ResourceInfo resourceInfo = new ResourceInfo(bindableResource.getJndiName(), applicationName, moduleName);
                if (!this.getResourceDeployer(bindableResource).canDeploy(postDeployPhase, resources, (Resource)bindableResource)) continue;
                this.resourcesBinder.deployResource(resourceInfo, (Resource)bindableResource);
                continue;
            }
            if (!this.getResourceDeployer(resource).canDeploy(postDeployPhase, resources, resource)) continue;
            this.getResourceDeployer(resource).deployResource((Object)resource, applicationName, moduleName);
        }
    }

    private static String getAppNameFromDeployCmdParams(DeploymentContext dc) {
        DeployCommandParameters commandParams = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        return commandParams.name();
    }

    public void retrieveAllResourcesXMLs(Map<String, String> fileNames, ReadableArchive archive, String actualArchiveName) throws IOException {
        if (DeploymentUtils.isArchiveOfType((ReadableArchive)archive, (ArchiveType)DOLUtils.earType(), (ServiceLocator)this.locator)) {
            String fileName;
            String archivePath;
            if (archive.exists(PAYARA_RESOURCES_XML_META_INF)) {
                archivePath = archive.getURI().getPath();
                fileName = archivePath + PAYARA_RESOURCES_XML_META_INF;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "Payara-Resources Deployer - fileName : {0} - parent : {1}", new Object[]{fileName, archive.getName()});
                }
                fileNames.put(actualArchiveName, fileName);
            }
            if (archive.exists(RESOURCES_XML_META_INF)) {
                archivePath = archive.getURI().getPath();
                fileName = archivePath + RESOURCES_XML_META_INF;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("GlassFish-Resources Deployer - fileName : " + fileName + " - parent : " + archive.getName());
                }
                fileNames.put(actualArchiveName, fileName);
            }
            Enumeration entries = archive.entries();
            while (entries.hasMoreElements()) {
                ReadableArchive subArchive;
                String element = (String)entries.nextElement();
                if (!element.endsWith(".jar") && !element.endsWith(".war") && !element.endsWith(".rar") && !element.endsWith("_jar") && !element.endsWith("_war") && !element.endsWith("_rar") || (subArchive = archive.getSubArchive(element)) == null) continue;
                this.retrieveResourcesXMLFromArchive(fileNames, subArchive, subArchive.getName());
            }
        } else {
            this.retrieveResourcesXMLFromArchive(fileNames, archive, actualArchiveName);
        }
    }

    private void retrieveResourcesXMLFromArchive(Map<String, String> fileNames, ReadableArchive archive, String actualArchiveName) {
        String fileName;
        String archivePath;
        if (ResourceUtil.hasPayaraResourcesXML((ReadableArchive)archive, (ServiceLocator)this.locator)) {
            archivePath = archive.getURI().getPath();
            fileName = DeploymentUtils.isArchiveOfType((ReadableArchive)archive, (ArchiveType)DOLUtils.warType(), (ServiceLocator)this.locator) ? archivePath + PAYARA_RESOURCES_XML_WEB_INF : archivePath + PAYARA_RESOURCES_XML_META_INF;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Payara-Resources Deployer - fileName : {0} - parent : {1}", new Object[]{fileName, archive.getName()});
            }
            fileNames.put(actualArchiveName, fileName);
        }
        if (ResourceUtil.hasGlassfishResourcesXML((ReadableArchive)archive, (ServiceLocator)this.locator)) {
            archivePath = archive.getURI().getPath();
            fileName = DeploymentUtils.isArchiveOfType((ReadableArchive)archive, (ArchiveType)DOLUtils.warType(), (ServiceLocator)this.locator) ? archivePath + RESOURCES_XML_WEB_INF : archivePath + RESOURCES_XML_META_INF;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("GlassFish-Resources Deployer - fileName : " + fileName + " - parent : " + archive.getName());
            }
            fileNames.put(actualArchiveName, fileName);
        }
    }

    private ResourceDeployer getResourceDeployer(Object resource) {
        return this.resourceManagerFactoryProvider.get().getResourceDeployer(resource);
    }

    public void event(EventListener.Event event) {
        if (event.is(Deployment.DEPLOYMENT_BEFORE_CLASSLOADER_CREATION)) {
            DeploymentContext dc = (DeploymentContext)event.hook();
            DeployCommandParameters deployParams = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
            this.processResources(dc, deployParams);
        } else if (event.is(Deployment.UNDEPLOYMENT_VALIDATION)) {
            DeploymentContext dc = (DeploymentContext)event.hook();
            UndeployCommandParameters undeployCommandParameters = (UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class);
            this.preserveResources(dc, undeployCommandParameters);
        } else if (Deployment.UNDEPLOYMENT_FAILURE.equals((Object)event.type())) {
            DeploymentContext dc = (DeploymentContext)event.hook();
            this.cleanupPreservedResources(dc, event);
        } else if (Deployment.DEPLOYMENT_FAILURE.equals((Object)event.type())) {
            DeploymentContext dc = (DeploymentContext)event.hook();
            String appName = ResourcesDeployer.getAppNameFromDeployCmdParams(dc);
            this.cleanupResources(appName, ((DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class)).origin);
            this.cleanupPreservedResources(dc, event);
        } else if (Deployment.DEPLOYMENT_SUCCESS.equals((Object)event.type())) {
            ApplicationInfo applicationInfo = (ApplicationInfo)event.hook();
            String appName = applicationInfo.getName();
            ResourcesRegistry.remove((String)appName);
        }
    }

    private void processResources(DeploymentContext dc, DeployCommandParameters deployParams) {
        try {
            if (deployParams.origin == OpsParams.Origin.deploy || deployParams.origin == OpsParams.Origin.deploy_instance) {
                String preserve;
                Properties properties = deployParams.properties;
                if (properties != null && (preserve = properties.getProperty("preserveAppScopedResources")) != null && Boolean.valueOf(preserve).booleanValue()) {
                    Boolean redeploy = false;
                    redeploy = deployParams.force;
                    if (redeploy.booleanValue()) {
                        String appName = ResourcesDeployer.getAppNameFromDeployCmdParams(dc);
                        Map allResources = ResourcesRegistry.remove((String)appName);
                        Application oldApp = preservedApps.remove(appName);
                        if (allResources != null && oldApp != null) {
                            Application application = (Application)dc.getTransientAppMetaData("application", Application.class);
                            this.validatePreservedResources(allResources, oldApp, application);
                            this.retainResourceConfig(dc, allResources);
                        }
                        return;
                    }
                }
                Application app = (Application)dc.getTransientAppMetaData("application", Application.class);
                String applicationName = ResourcesDeployer.getAppNameFromDeployCmdParams(dc);
                if (app != null) {
                    this.processArchive(dc);
                    this.createResources(dc, false, true);
                    this.createResources(dc, true, false);
                    this.deployResources(applicationName, false);
                } else {
                    this.deployResourcesFromConfiguration(applicationName, false);
                    this.populateResourceConfigInAppInfo(dc);
                }
            } else if (deployParams.origin == OpsParams.Origin.load) {
                this.populateResourceConfigInAppInfo(dc);
            }
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Exception while processing archive of application [ " + ResourcesDeployer.getAppNameFromDeployCmdParams(dc) + " ] for resources definitions : " + e.getCause());
            }
            throw new DeploymentException((Throwable)e);
        }
    }

    private void validatePreservedResources(Map<String, Resources> allResources, Application oldApp, Application newApp) throws ResourceConflictException {
        String appName = newApp.getName();
        Resources appScopedResources = allResources.get(appName);
        if (appScopedResources != null) {
            for (Resource resource : appScopedResources.getResources()) {
                this.getResourceDeployer(resource).validatePreservedResource(oldApp, newApp, resource, appScopedResources);
            }
        }
        List newModules = newApp.getModule();
        for (Module newModule : newModules) {
            Resources oldModuleResources;
            Module oldModule = oldApp.getModule(newModule.getName());
            if (oldModule == null || (oldModuleResources = oldModule.getResources()) == null) continue;
            for (Resource resource : oldModuleResources.getResources()) {
                this.getResourceDeployer(resource).validatePreservedResource(oldApp, newApp, resource, oldModuleResources);
            }
        }
    }

    private void cleanupResources(String appName, OpsParams.Origin deploymentPhase) {
        try {
            Application application;
            if (deploymentPhase == OpsParams.Origin.deploy || deploymentPhase == OpsParams.Origin.deploy_instance || deploymentPhase == OpsParams.Origin.create_application_ref) {
                Map allResources = ResourcesRegistry.remove((String)appName);
                if (allResources != null) {
                    for (Map.Entry entry : allResources.entrySet()) {
                        String moduleName = (String)entry.getKey();
                        Resources resources = (Resources)entry.getValue();
                        String actualModuleName = moduleName;
                        if (appName.equals(moduleName)) {
                            actualModuleName = null;
                        }
                        this.undeployResources(resources, appName, actualModuleName);
                    }
                }
            } else if (deploymentPhase == OpsParams.Origin.load && (application = this.applications.getApplication(appName)) != null) {
                Resources appScopedResources = application.getResources();
                this.undeployResources(appScopedResources, appName, null);
                List modules = application.getModule();
                if (modules != null) {
                    for (Module module : modules) {
                        Resources moduleScopedResources = module.getResources();
                        this.undeployResources(moduleScopedResources, appName, module.getName());
                    }
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Exception while cleaning-up resources during deployment failure", e);
        }
    }

    private void undeployResources(Resources resources, String appName, String moduleName) {
        if (resources != null) {
            for (Resource resource : resources.getResources()) {
                try {
                    if (resource instanceof ResourcePool) continue;
                    this.getResourceDeployer(resource).undeployResource((Object)resource, appName, moduleName);
                }
                catch (Exception exception) {}
            }
            Collection pools = resources.getResources(ResourcePool.class);
            for (ResourcePool pool : pools) {
                try {
                    this.getResourceDeployer(pool).undeployResource((Object)pool, appName, moduleName);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void cleanupPreservedResources(DeploymentContext dc, EventListener.Event event) {
        if (Deployment.DEPLOYMENT_FAILURE.equals((Object)event.type())) {
            DeployCommandParameters deployCommandParameters = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
            if (deployCommandParameters.origin == OpsParams.Origin.deploy || deployCommandParameters.origin == OpsParams.Origin.deploy_instance || deployCommandParameters.origin == OpsParams.Origin.create_application_ref) {
                Properties properties = deployCommandParameters.properties;
                String appName = deployCommandParameters.name();
                this.cleanupPreservedResources(appName, properties);
            }
        } else if (Deployment.UNDEPLOYMENT_FAILURE.equals((Object)event.type())) {
            UndeployCommandParameters undeployCommandParameters = (UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class);
            if (undeployCommandParameters.origin == OpsParams.Origin.undeploy) {
                Properties properties = undeployCommandParameters.properties;
                String appName = undeployCommandParameters.name();
                this.cleanupPreservedResources(appName, properties);
            }
        }
    }

    private void cleanupPreservedResources(String appName, Properties properties) {
        String preserve;
        if (properties != null && (preserve = properties.getProperty("preserveAppScopedResources")) != null && Boolean.valueOf(preserve).booleanValue()) {
            ResourcesRegistry.remove((String)appName);
            preservedApps.remove(appName);
        }
    }

    private void preserveResources(DeploymentContext dc, UndeployCommandParameters undeployCommandParameters) {
        try {
            String preserve;
            Properties properties;
            if (undeployCommandParameters.origin == OpsParams.Origin.undeploy && (properties = undeployCommandParameters.properties) != null && (preserve = properties.getProperty("preserveAppScopedResources")) != null && Boolean.valueOf(preserve).booleanValue()) {
                ResourcesDeployer.debug("Preserve app scoped resources enabled");
                UndeployCommandParameters commandParams = (UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class);
                String appName = commandParams.name();
                Application app = this.applications.getApplication(appName);
                this.preserveResources(app);
                preservedApps.put(appName, app);
            }
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
    }

    private void preserveResources(Application app) {
        List modules;
        String appName = app.getName();
        HashMap<String, Resources> allResources = new HashMap<String, Resources>();
        Resources appScopedResources = app.getResources();
        if (appScopedResources != null) {
            allResources.put(appName, appScopedResources);
        }
        if ((modules = app.getModule()) != null) {
            for (Module module : modules) {
                Resources moduleScopedResources = module.getResources();
                if (moduleScopedResources == null) continue;
                allResources.put(module.getName(), moduleScopedResources);
            }
        }
        ResourcesRegistry.putResources((String)appName, allResources);
    }

    private static void debug(String message) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("[ASR] ResourceDeployer : " + message);
        }
    }
}

