/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.composite.RestModel;
import org.glassfish.admin.rest.model.ResponseBody;
import org.glassfish.admin.rest.utils.JsonUtil;

public class RestCollectionResponseBody<T extends RestModel>
extends ResponseBody {
    private String collectionName;
    private UriInfo uriInfo;
    private List<T> items = new ArrayList<T>();

    public RestCollectionResponseBody(UriInfo uriInfo, String collectionName) {
        this.setUriInfo(uriInfo);
        this.setCollectionName(collectionName);
    }

    public RestCollectionResponseBody(boolean includeResourceLinks, UriInfo uriInfo, String collectionName) {
        super(includeResourceLinks);
        this.setUriInfo(uriInfo);
        this.setCollectionName(collectionName);
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public List<T> getItems() {
        return this.items;
    }

    public void setItems(List<T> items) {
        this.items = items;
    }

    public void addItem(T item, String name) {
        URI uri = this.collectionName != null ? this.uriInfo.getAbsolutePathBuilder().path("id").path(name).build(new Object[0]) : null;
        this.addItem(item, name, uri);
    }

    public void addItem(T item, String name, URI uri) {
        this.addItem(item, this.collectionName, name, uri);
    }

    public void addItem(T item, String collectionName, String name, URI uri) {
        this.getItems().add(item);
        if (collectionName != null && uri != null) {
            this.addResourceLink(collectionName, name, uri);
        }
    }

    @Override
    protected void populateJson(JsonObject object) throws JsonException {
        super.populateJson(object);
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (RestModel item : this.getItems()) {
            array.add(JsonUtil.getJsonValue(item));
        }
        object.put((Object)"items", (Object)array.build());
    }
}

