/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.glassfish.admin.rest.model.ResponseBody;
import org.glassfish.admin.rest.utils.JsonUtil;

public class SseResponseBody
extends ResponseBody {
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public SseResponseBody() {
    }

    public SseResponseBody(boolean includeResourceLinks) {
        super(includeResourceLinks);
    }

    public SseResponseBody addHeader(String name, Object value) {
        if (value != null) {
            List<String> values = this.headers.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                this.headers.put(name, values);
            }
            values.add(value.toString());
        }
        return this;
    }

    @Override
    public JsonObject toJson() throws JsonException {
        JsonObject json = super.toJson();
        if (!this.headers.isEmpty()) {
            JsonObject o = Json.createObjectBuilder().build();
            for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                String key = entry.getKey();
                for (String value : entry.getValue()) {
                    JsonUtil.accumalate(o, key, JsonUtil.getJsonValue(value));
                }
            }
            json = JsonUtil.accumalate(json, "headers", (JsonValue)o);
        }
        return json;
    }
}

