/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import com.sun.enterprise.admin.report.ActionReporter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.jvnet.hk2.config.ConfigBean;

@Provider
@Produces(value={"text/html"})
public class ActionReportResultHtmlProvider
extends BaseProvider<ActionReportResult> {
    private static final String ANCHOR_OPEN = "<a href=\"";
    private static final String HEADING_END = "</h3>";
    private static final String LIST_ITEM_END = "</li>";
    private static final String LIST_END = "</ul>";
    private static final String DELETE = "DELETE";

    public ActionReportResultHtmlProvider() {
        super(ActionReportResult.class, MediaType.TEXT_HTML_TYPE);
    }

    @Override
    public String getContent(ActionReportResult proxy) {
        RestActionReporter ar = (RestActionReporter)proxy.getActionReport();
        StringBuilder result = new StringBuilder(ProviderUtil.getHtmlHeader(this.getBaseUri()));
        String message = ResourceUtil.encodeString(ar.getCombinedMessage());
        if (!message.isEmpty()) {
            result.append("<h3>").append(message).append(HEADING_END);
        }
        if (proxy.isError()) {
            result.append("<h2>").append(ar.getActionDescription()).append(" Error:</h2>").append(proxy.getErrorMessage());
        } else {
            Map childResources = (Map)ar.getExtraProperties().get("childResources");
            List commands = (List)ar.getExtraProperties().get("commands");
            MethodMetaData postMetaData = proxy.getMetaData().getMethodMetaData("POST");
            MethodMetaData deleteMetaData = proxy.getMetaData().getMethodMetaData(DELETE);
            MethodMetaData getMetaData = proxy.getMetaData().getMethodMetaData("GET");
            ConfigBean entity = proxy.getEntity();
            if (proxy.getCommandDisplayName() != null && getMetaData != null && entity == null) {
                result.append(this.processReport(ar));
            }
            if (postMetaData != null && entity == null) {
                String postCommand = ProviderUtil.getHtmlRespresentationsForCommand(postMetaData, "POST", proxy.getCommandDisplayName() == null ? "Create" : proxy.getCommandDisplayName(), (UriInfo)this.uriInfo.get());
                result.append(ProviderUtil.getHtmlForComponent(postCommand, "Create " + ar.getActionDescription(), ""));
            }
            if (deleteMetaData != null && entity == null) {
                String deleteCommand = ProviderUtil.getHtmlRespresentationsForCommand(deleteMetaData, DELETE, proxy.getCommandDisplayName() == null ? "Delete" : proxy.getCommandDisplayName(), (UriInfo)this.uriInfo.get());
                result.append(ProviderUtil.getHtmlForComponent(deleteCommand, "Delete " + ar.getActionDescription(), ""));
            }
            if (getMetaData != null && entity == null && proxy.getCommandDisplayName() != null) {
                String getCommand = ProviderUtil.getHtmlRespresentationsForCommand(getMetaData, "GET", proxy.getCommandDisplayName() == null ? "Get" : proxy.getCommandDisplayName(), (UriInfo)this.uriInfo.get());
                result.append(ProviderUtil.getHtmlForComponent(getCommand, "Get " + ar.getActionDescription(), ""));
            }
            if (entity != null) {
                String attributes = ProviderUtil.getHtmlRepresentationForAttributes(proxy.getEntity(), (UriInfo)this.uriInfo.get());
                result.append(ProviderUtil.getHtmlForComponent(attributes, ar.getActionDescription() + " Attributes", ""));
                String deleteCommand = ProviderUtil.getHtmlRespresentationsForCommand(proxy.getMetaData().getMethodMetaData(DELETE), DELETE, proxy.getCommandDisplayName() == null ? "Delete" : proxy.getCommandDisplayName(), (UriInfo)this.uriInfo.get());
                result.append(ProviderUtil.getHtmlForComponent(deleteCommand, "Delete " + entity.model.getTagName(), ""));
            } else if (proxy.getLeafContent() != null) {
                String content = "<form action=\"" + ((UriInfo)this.uriInfo.get()).getAbsolutePath().toString() + "\" method=\"post\"><dl><dt><label for=\"" + proxy.getLeafContent().name + "\">" + proxy.getLeafContent().name + ":&nbsp;</label></dt><dd><input name=\"" + proxy.getLeafContent().name + "\" value =\"" + proxy.getLeafContent().value + "\" type=\"text\" ></dd><dt class=\"button\"></dt><dd class=\"button\"><input value=\"Update\" type=\"submit\"></dd></dl></form><br><hr class=\"separator\"/";
                result.append(content);
            } else {
                Map vals = (Map)ar.getExtraProperties().get("entity");
                if (vals != null && !vals.isEmpty()) {
                    result.append("<ul>");
                    for (Map.Entry entry : vals.entrySet()) {
                        Object object = entry.getValue();
                        if (object == null) continue;
                        if (object instanceof Collection) {
                            if (((Collection)object).isEmpty()) continue;
                            Collection c = (Collection)object;
                            Iterator i = c.iterator();
                            result.append("<li>").append(entry.getKey());
                            result.append("<ul>");
                            while (i.hasNext()) {
                                result.append("<li>").append(this.getHtmlRepresentation(i.next())).append(LIST_ITEM_END);
                            }
                            result.append(LIST_END);
                            result.append(LIST_ITEM_END);
                            continue;
                        }
                        if (object instanceof Map) {
                            if (((Map)object).isEmpty()) continue;
                            Map m = (Map)object;
                            if (vals.size() != 1) {
                                result.append("<li>").append(ANCHOR_OPEN).append(((UriInfo)this.uriInfo.get()).getAbsolutePath().toString()).append("/").append(entry.getKey()).append("\">").append(entry.getKey()).append("</a>");
                            } else {
                                result.append("<li>").append(entry.getKey());
                            }
                            result.append("<ul>");
                            for (Map.Entry anEntry : m.entrySet()) {
                                String htmlRepresentation = this.getHtmlRepresentation(anEntry.getValue());
                                if (htmlRepresentation == null) continue;
                                result.append("<li>").append(anEntry.getKey()).append(" : ").append(htmlRepresentation).append(LIST_ITEM_END);
                            }
                            result.append(LIST_END);
                            result.append(LIST_ITEM_END);
                            continue;
                        }
                        result.append("<li>").append(entry.getKey()).append(" : ").append(object.toString()).append(LIST_ITEM_END);
                    }
                    result.append(LIST_END);
                } else if ((childResources == null || childResources.isEmpty()) && this.uriInfo != null && ((UriInfo)this.uriInfo.get()).getPath().equalsIgnoreCase("domain")) {
                    result.append(ProviderUtil.getHint((UriInfo)this.uriInfo.get(), "text/html"));
                }
            }
            if (childResources != null && !childResources.isEmpty()) {
                String childResourceLinks = this.getResourcesLinks(childResources);
                result.append(ProviderUtil.getHtmlForComponent(childResourceLinks, "Child Resources", ""));
            }
            if (commands != null && !commands.isEmpty()) {
                String commandLinks = this.getCommandLinks(commands);
                result.append(ProviderUtil.getHtmlForComponent(commandLinks, "Commands", ""));
            }
        }
        return result.append("</div></body></html>").toString();
    }

    protected String getBaseUri() {
        if (this.uriInfo != null && this.uriInfo.get() != null) {
            return ((UriInfo)this.uriInfo.get()).getBaseUri().toASCIIString();
        }
        return "";
    }

    protected String getResourcesLinks(Map<String, String> childResources) {
        StringBuilder links = new StringBuilder("<div>");
        for (Map.Entry<String, String> link : childResources.entrySet()) {
            links.append(ANCHOR_OPEN).append(link.getValue()).append("\">").append(link.getKey()).append("</a><br>");
        }
        return links.append("</div><br/>").toString();
    }

    protected String getCommandLinks(List<Map<String, String>> commands) {
        StringBuilder result = new StringBuilder("<div>");
        boolean showHiddenCommands = this.canShowHiddenCommands();
        for (Map<String, String> commandList : commands) {
            String command = commandList.get("command");
            String path = commandList.get("path");
            if (path.startsWith("_") && !showHiddenCommands) {
                result.append("<!--");
            }
            result.append(ANCHOR_OPEN).append(ProviderUtil.getElementLink((UriInfo)this.uriInfo.get(), command)).append("\">").append(command).append("</a><br>");
            if (!path.startsWith("_") || showHiddenCommands) continue;
            result.append("-->");
        }
        return result.append("</div><br>").toString();
    }

    protected String processReport(ActionReporter ar) {
        List subReports;
        List children;
        Properties extraProperties;
        Properties properties;
        String message;
        StringBuilder result = new StringBuilder();
        String des = ar.getActionDescription();
        if (des == null) {
            des = "";
        }
        if ((message = ResourceUtil.encodeString(ar instanceof RestActionReporter ? ((RestActionReporter)ar).getCombinedMessage() : ar.getMessage())) != null) {
            result.append("<h2>").append(des).append(" output:</h2><h3>").append("<pre>").append(message).append("</pre>").append(HEADING_END);
        }
        if (ar.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
            result.append("<h3>Exit Code: ").append(ar.getActionExitCode().toString()).append(HEADING_END);
        }
        if (!(properties = ar.getTopMessagePart().getProps()).isEmpty()) {
            result.append(this.processProperties(properties));
        }
        if (!((extraProperties = ar.getExtraProperties()) == null || extraProperties.isEmpty() || extraProperties.size() == 1 && extraProperties.get("methods") != null)) {
            result.append(this.getExtraProperties(extraProperties));
        }
        if (!(children = ar.getTopMessagePart().getChildren()).isEmpty()) {
            result.append(this.processChildren(children));
        }
        if (!(subReports = ar.getSubActionsReport()).isEmpty()) {
            result.append(this.processSubReports(subReports));
        }
        return result.toString();
    }

    protected String processProperties(Properties props) {
        StringBuilder result = new StringBuilder("<h3>Properties</h3>");
        result.append(this.getHtml(props));
        return result.append("</table>").toString();
    }

    protected String getExtraProperties(Properties props) {
        StringBuilder result = new StringBuilder("<h3>Extra Properties</h3>");
        result.append(this.getHtml(props));
        return result.toString();
    }

    protected String processChildren(List<ActionReport.MessagePart> parts) {
        StringBuilder result = new StringBuilder("<h3>Children</h3><ul>");
        for (ActionReport.MessagePart part : parts) {
            result.append("<li><table border=\"1\" style=\"border-collapse: collapse\">").append("<tr><td>Message</td>").append("<td>").append(part.getMessage()).append("</td></tr><td>Properties</td><td>").append(this.getHtml(part.getProps())).append("</td></tr>");
            List children = part.getChildren();
            if (!children.isEmpty()) {
                result.append("<tr><td>Children</td><td>").append(this.processChildren(part.getChildren())).append("</td></tr>");
            }
            result.append("</table></li>");
        }
        return result.append(LIST_END).toString();
    }

    protected String processSubReports(List<ActionReporter> subReports) {
        StringBuilder result = new StringBuilder("<h3>Sub Reports</h3><ul>");
        for (ActionReporter subReport : subReports) {
            result.append(this.processReport(subReport));
        }
        return result.append(LIST_END).toString();
    }

    protected String getHtmlRepresentation(Object object) {
        String result = null;
        if (object == null) {
            return "";
        }
        if (object instanceof Collection) {
            if (!((Collection)object).isEmpty()) {
                result = this.getHtml((Collection)object);
            }
        } else if (object instanceof Map) {
            if (!((Map)object).isEmpty()) {
                result = this.getHtml((Map)object);
            }
        } else {
            result = object.toString();
        }
        return result;
    }

    protected String getHtml(Collection c) {
        StringBuilder result = new StringBuilder("<ul>");
        Iterator i = c.iterator();
        while (i.hasNext()) {
            result.append("<li>").append(this.getHtmlRepresentation(i.next())).append(LIST_ITEM_END);
        }
        return result.append("</li></ul>").toString();
    }

    protected String getHtml(Map map) {
        StringBuilder result = new StringBuilder();
        if (!map.isEmpty()) {
            result.append("<table border=\"1\" style=\"border-collapse: collapse\"><tr><th>key</th><th>value</th></tr>");
            for (Map.Entry entry : map.entrySet()) {
                String htmlRepresentation = this.getHtmlRepresentation(entry.getValue());
                if (htmlRepresentation == null) continue;
                result.append("<tr><td>").append(entry.getKey()).append("</td><td>").append(htmlRepresentation).append("</td></tr>");
            }
            result.append("</table>");
        }
        return result.toString();
    }
}

